/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import javax.persistence.Transient;
import open.dolphin.infomodel.DiagnosisCategoryModel;
import open.dolphin.infomodel.DiagnosisOutcomeModel;
import open.dolphin.infomodel.KarteEntryBean;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.PatientLiteModel;
import open.dolphin.infomodel.UserLiteModel;
import open.dolphin.log.LogWriter;
import open.dolphin.utils.CombinedStringParser;
import open.dolphin.utils.DiagnosisCode;

public class RegisteredDiagnosisModel
extends KarteEntryBean {
    private String diagnosis;
    private String diagnosisCode;
    private String diagnosisCodeSystem;
    private String firstEncounterDate;
    private String relatedHealthInsurance;
    private DiagnosisCategoryModel diagnosisCategoryModel;
    private DiagnosisOutcomeModel diagnosisOutcomeModel;
    @Transient
    private PatientLiteModel patientLiteModel;
    @Transient
    private UserLiteModel userLiteModel;

    public RegisteredDiagnosisModel() {
    }

    public RegisteredDiagnosisModel(RegisteredDiagnosisModel original) {
        this.setDiagnosis(original.getDiagnosis());
        this.setDiagnosisCode(original.getDiagnosisCode());
        this.setDiagnosisCodeSystem(original.getDiagnosisCodeSystem());
    }

    public String getDiagnosis() {
        return this.diagnosis;
    }

    public void setDiagnosis(String diagnosis) {
        this.diagnosis = diagnosis;
    }

    public String getDiagnosisCode() {
        return this.diagnosisCode;
    }

    public void setDiagnosisCode(String diagnosisCode) {
        this.diagnosisCode = diagnosisCode;
    }

    public String getAlternateDiagnosisCode() {
        return new DiagnosisCode(this.diagnosisCode).getAlternateCode();
    }

    public String getDiagnosisCodeSystem() {
        return this.diagnosisCodeSystem;
    }

    public void setDiagnosisCodeSystem(String diagnosisCodeSystem) {
        this.diagnosisCodeSystem = diagnosisCodeSystem;
    }

    public String getCategory() {
        return this.diagnosisCategoryModel != null ? this.diagnosisCategoryModel.getDiagnosisCategory() : null;
    }

    public void setCategory(String category) {
        if (this.diagnosisCategoryModel == null) {
            this.diagnosisCategoryModel = new DiagnosisCategoryModel();
        }
        this.diagnosisCategoryModel.setDiagnosisCategory(category);
    }

    public String getCategoryDesc() {
        return this.diagnosisCategoryModel != null ? this.diagnosisCategoryModel.getDiagnosisCategoryDesc() : null;
    }

    public void setCategoryDesc(String categoryDesc) {
        if (this.diagnosisCategoryModel == null) {
            this.diagnosisCategoryModel = new DiagnosisCategoryModel();
        }
        this.diagnosisCategoryModel.setDiagnosisCategoryDesc(categoryDesc);
    }

    public String getCategoryCodeSys() {
        return this.diagnosisCategoryModel != null ? this.diagnosisCategoryModel.getDiagnosisCategoryCodeSys() : null;
    }

    public void setCategoryCodeSys(String categoryTable) {
        if (this.diagnosisCategoryModel == null) {
            this.diagnosisCategoryModel = new DiagnosisCategoryModel();
        }
        this.diagnosisCategoryModel.setDiagnosisCategoryCodeSys(categoryTable);
    }

    public String getFirstEncounterDate() {
        return this.firstEncounterDate;
    }

    public void setFirstEncounterDate(String firstEncounterDate) {
        this.firstEncounterDate = firstEncounterDate;
    }

    public String getStartDate() {
        if (this.getStarted() != null) {
            return ModelUtils.getDateAsString(this.getStarted());
        }
        return null;
    }

    public void setStartDate(String startDate) {
        if (startDate != null) {
            int index = startDate.indexOf(84);
            if (index < 0) {
                startDate = startDate + "T00:00:00";
            }
            this.setStarted(ModelUtils.getDateTimeAsObject(startDate));
        }
    }

    public String getEndDate() {
        if (this.getEnded() != null) {
            return ModelUtils.getDateAsString(this.getEnded());
        }
        return null;
    }

    public void setEndDate(String endDate) {
        if (endDate != null) {
            if (!endDate.isEmpty()) {
                int index = endDate.indexOf(84);
                if (index < 0) {
                    endDate = endDate + "T00:00:00";
                }
                this.setEnded(ModelUtils.getDateTimeAsObject(endDate));
            } else {
                this.setEnded(null);
            }
        }
    }

    public String getOutcome() {
        return this.diagnosisOutcomeModel != null ? this.diagnosisOutcomeModel.getOutcome() : null;
    }

    public void setOutcome(String outcome) {
        if (this.diagnosisOutcomeModel == null) {
            this.diagnosisOutcomeModel = new DiagnosisOutcomeModel();
        }
        this.diagnosisOutcomeModel.setOutcome(outcome);
    }

    public String getOutcomeDesc() {
        return this.diagnosisOutcomeModel != null ? this.diagnosisOutcomeModel.getOutcomeDesc() : null;
    }

    public void setOutcomeDesc(String outcomeDesc) {
        if (this.diagnosisOutcomeModel == null) {
            this.diagnosisOutcomeModel = new DiagnosisOutcomeModel();
        }
        this.diagnosisOutcomeModel.setOutcomeDesc(outcomeDesc);
    }

    public String getOutcomeCodeSys() {
        return this.diagnosisOutcomeModel != null ? this.diagnosisOutcomeModel.getOutcomeCodeSys() : null;
    }

    public void setOutcomeCodeSys(String outcomeTable) {
        if (this.diagnosisOutcomeModel == null) {
            this.diagnosisOutcomeModel = new DiagnosisOutcomeModel();
        }
        this.diagnosisOutcomeModel.setOutcomeCodeSys(outcomeTable);
    }

    public String getRelatedHealthInsurance() {
        return this.relatedHealthInsurance;
    }

    public void setRelatedHealthInsurance(String relatedHealthInsurance) {
        this.relatedHealthInsurance = relatedHealthInsurance;
    }

    public DiagnosisCategoryModel getDiagnosisCategoryModel() {
        return this.diagnosisCategoryModel;
    }

    public void setDiagnosisCategoryModel(DiagnosisCategoryModel diagnosisCategoryModel) {
        this.diagnosisCategoryModel = diagnosisCategoryModel;
    }

    public DiagnosisOutcomeModel getDiagnosisOutcomeModel() {
        return this.diagnosisOutcomeModel;
    }

    public void setDiagnosisOutcomeModel(DiagnosisOutcomeModel diagnosisOutcomeModel) {
        this.diagnosisOutcomeModel = diagnosisOutcomeModel;
    }

    public PatientLiteModel getPatientLiteModel() {
        return this.patientLiteModel;
    }

    public void setPatientLiteModel(PatientLiteModel patientLiteModel) {
        this.patientLiteModel = patientLiteModel;
    }

    public UserLiteModel getUserLiteModel() {
        return this.userLiteModel;
    }

    public void setUserLiteModel(UserLiteModel userLiteModel) {
        this.userLiteModel = userLiteModel;
    }

    private static String[] splitDiagnosis(String diagnosis) {
        if (diagnosis == null) {
            return null;
        }
        String[] ret = null;
        try {
            ret = diagnosis.split("\\s*,\\s*");
        }
        catch (Exception e) {
            LogWriter.error("RegisteredDiagnosisModel", "splitDiagnosis");
        }
        return ret;
    }

    public String getDiagnosisName() {
        String[] splits = RegisteredDiagnosisModel.splitDiagnosis(this.diagnosis);
        return splits != null && splits.length == 2 && splits[0] != null ? splits[0] : this.diagnosis;
    }

    public String getAlternateDiagnosisName() {
        CombinedStringParser parser = new CombinedStringParser(this.getDiagnosisName());
        if (parser.size() > 1) {
            return parser.toPlainString();
        }
        return this.getDiagnosisName();
    }

    public String getDiagnosisAlias() {
        String[] splits = RegisteredDiagnosisModel.splitDiagnosis(this.diagnosis);
        return splits != null && splits.length == 2 && splits[1] != null ? splits[1] : null;
    }

    public String getAliasOrName() {
        String[] aliasOrName = RegisteredDiagnosisModel.splitDiagnosis(this.diagnosis);
        if (aliasOrName != null && aliasOrName.length == 2 && aliasOrName[1] != null) {
            return aliasOrName[1];
        }
        return this.diagnosis;
    }

    public void clear() {
        this.setId(0L);
        this.setKarte(null);
        this.setCreator(null);
        this.setDiagnosisCategoryModel(null);
        this.setDiagnosisOutcomeModel(null);
        this.setFirstEncounterDate(null);
        this.setStartDate(null);
        this.setEndDate(null);
        this.setRelatedHealthInsurance(null);
        this.setFirstConfirmDate(null);
        this.setConfirmDate(null);
        this.setStatus(null);
        this.setPatientLiteModel(null);
        this.setUserLiteModel(null);
    }
}

