/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.plugin.labotestdocumentpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.container.NameValuePair;
import open.dolphin.delegater.remote.RemoteLaboDelegater;
import open.dolphin.dto.LaboSearchSpec;
import open.dolphin.helper.DBTask;
import open.dolphin.helper.IChartCommandAccepter;
import open.dolphin.infomodel.LaboItemValue;
import open.dolphin.infomodel.LaboModuleValue;
import open.dolphin.infomodel.LaboSpecimenValue;
import open.dolphin.plugin.labotestdocumentpanel.AllLaboTest;
import open.dolphin.plugin.labotestdocumentpanel.LaboTestGraphPanel;
import open.dolphin.plugin.labotestdocumentpanel.LaboTestItemID;
import open.dolphin.plugin.labotestdocumentpanel.SimpleLaboModule;
import open.dolphin.plugin.labotestdocumentpanel.SimpleLaboSpecimen;
import open.dolphin.plugin.labotestdocumentpanel.SimpleLaboTest;
import open.dolphin.plugin.labotestdocumentpanel.SimpleLaboTestItem;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.utils.MMLDate;

public class LaboTestDocumentPanel
extends JPanel
implements IChartDocument,
IChartCommandAccepter {
    public static final String TITLE = "\u30e9\u30dc\u30c6\u30b9\u30c8";
    private static final int CELL_WIDTH = 120;
    private static final int DEFAULT_DIVIDER_LOC = 210;
    private static final int DEFAULT_DIVIDER_WIDTH = 10;
    private Object[] header;
    private Object[][] laboData;
    private List<SimpleLaboModule> laboModules;
    private AllLaboTest allLaboTest;
    private NameValuePair[] periodObject = GlobalConstants.getNameValuePair("docHistory.combo.period");
    private RemoteLaboDelegater ldl;
    private LaboTestGraphPanel laboTestGraph;
    private int dividerWidth;
    private int dividerLoc;
    private Color specimenColor = GlobalConstants.getColor("labotest.color.specimen");
    private Color lowColor = GlobalConstants.getColor("labotest.color.low");
    private Color normalColor = GlobalConstants.getColor("labotest.color.normal");
    private Color highColor = GlobalConstants.getColor("labotest.color.high");
    private Preferences myPrefs = Preferences.userNodeForPackage(this.getClass());
    private static final String[] CHART_MENUS = new String[]{"openKarte", "save", "direction", "delete", "print", "modifyKarte", "ascending", "descending", "showModified", "showUnsend", "showSend", "insertText", "insertSchema", "insertStamp", "selectInsurance", "cut", "copy", "paste", "undo", "redo"};
    private IChart parent;
    private String title = "\u30e9\u30dc\u30c6\u30b9\u30c8";
    private boolean dirty;
    private JRadioButton absoluteRadio;
    private ButtonGroup bg;
    private JPanel comboPanel;
    private JPanel controlPanel;
    private JTextField countField;
    private JPanel countPanel;
    private JComboBox extractionCombo;
    private JScrollPane jScrollPane1;
    private JRadioButton relativeRadio;
    private JTable rowLabel;
    private JSplitPane splitPane;
    private JTable table;
    private JPanel tablePanel;

    public LaboTestDocumentPanel(IChart parent) {
        this.parent = parent;
        this.initComponents();
        this.initCustomComponents();
        this.allLaboTest = new AllLaboTest();
        this.laboModules = new ArrayList<SimpleLaboModule>();
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.Plugin;
    }

    private void initComponents() {
        this.rowLabel = new JTable();
        this.table = new JTable();
        this.tablePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.controlPanel = new JPanel();
        this.relativeRadio = new JRadioButton();
        this.absoluteRadio = new JRadioButton();
        this.bg = new ButtonGroup();
        this.countPanel = new JPanel();
        this.countField = new JTextField();
        this.comboPanel = new JPanel();
        this.extractionCombo = new JComboBox();
        this.splitPane = new JSplitPane();
        this.rowLabel.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.rowLabel.setName("rowLabel");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setName("table");
        this.tablePanel.setName("tablePanel");
        this.tablePanel.setLayout(new BorderLayout(7, 0));
        this.jScrollPane1.setName("jScrollPane1");
        this.tablePanel.add((Component)this.jScrollPane1, "Center");
        this.controlPanel.setName("controlPanel");
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 0));
        this.tablePanel.add((Component)this.controlPanel, "South");
        this.relativeRadio.setText("\u76f8\u5bfe\u30b0\u30e9\u30d5");
        this.relativeRadio.setName("relativeRadio");
        this.relativeRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LaboTestDocumentPanel.this.relativeRadioActionPerformed(evt);
            }
        });
        this.absoluteRadio.setText("\u7d76\u5bfe\u5024\u30b0\u30e9\u30d5");
        this.absoluteRadio.setName("absoluteRadio");
        this.absoluteRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LaboTestDocumentPanel.this.absoluteRadioActionPerformed(evt);
            }
        });
        this.countPanel.setName("countPanel");
        this.countPanel.setLayout(new FlowLayout(0, 0, 0));
        this.countField.setEditable(false);
        this.countField.setText("jTextField1");
        this.countField.setName("countField");
        this.countPanel.add(this.countField);
        this.comboPanel.setName("comboPanel");
        this.comboPanel.setLayout(new FlowLayout(0, 0, 0));
        this.extractionCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"1\u30b1\u6708", "3\u30b1\u6708", "\u534a\u5e74", "1\u5e74", "2\u5e74", "3\u5e74", "5\u5e74"}));
        this.extractionCombo.setName("extractionCombo");
        this.extractionCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LaboTestDocumentPanel.this.extractionComboItemStateChanged(evt);
            }
        });
        this.comboPanel.add(this.extractionCombo);
        this.setLayout(new BorderLayout());
        this.splitPane.setOrientation(0);
        this.splitPane.setName("splitPane");
        this.splitPane.setOneTouchExpandable(true);
        this.add((Component)this.splitPane, "Center");
    }

    private void extractionComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            NameValuePair pair = (NameValuePair)this.extractionCombo.getSelectedItem();
            String value = pair.getValue();
            int addValue = Integer.parseInt(value);
            GregorianCalendar today = new GregorianCalendar();
            today.add(2, addValue);
            this.searchLaboTest(MMLDate.getDate(today));
        }
    }

    private void relativeRadioActionPerformed(ActionEvent evt) {
        int mode;
        boolean b = this.absoluteRadio.isSelected();
        this.myPrefs.putBoolean("laboTestDocument.absoluteGraphProp", b);
        if (this.laboTestGraph == null) {
            return;
        }
        int myMode = this.getMyGraphMode();
        if (myMode != (mode = this.laboTestGraph.getMode()) && this.laboTestGraph != null) {
            this.laboTestGraph.setMode(myMode);
        }
    }

    private void absoluteRadioActionPerformed(ActionEvent evt) {
        int mode;
        boolean b = this.absoluteRadio.isSelected();
        this.myPrefs.putBoolean("laboTestDocument.absoluteGraphProp", b);
        if (this.laboTestGraph == null) {
            return;
        }
        int myMode = this.getMyGraphMode();
        if (myMode != (mode = this.laboTestGraph.getMode()) && this.laboTestGraph != null) {
            this.laboTestGraph.setMode(myMode);
        }
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        return false;
    }

    public void generateObjectsForTable() {
        String itemText = "\u9805  \u76ee";
        String registText = "\u767b \u9332";
        String reportText = "\u5831 \u544a";
        String statusText = "\u30b9\u30c6\u30fc\u30bf\u30b9";
        String laboCenterText = "\u691c\u67fb\u30bb\u30f3\u30bf\u30fc";
        String setNameText = "\u30bb\u30c3\u30c8\u540d";
        int moduleCount = this.laboModules.size();
        this.header = new Object[moduleCount + 1];
        this.header[0] = itemText;
        for (int i = 1; i <= moduleCount; ++i) {
            this.header[i] = this.laboModules.get(i - 1).getHeader();
        }
        int rowCount = this.allLaboTest.getRowCount() + 6;
        this.laboData = new Object[rowCount][moduleCount + 1];
        this.laboData[rowCount - 6][0] = "";
        this.laboData[rowCount - 5][0] = registText;
        this.laboData[rowCount - 4][0] = reportText;
        this.laboData[rowCount - 3][0] = statusText;
        this.laboData[rowCount - 2][0] = laboCenterText;
        this.laboData[rowCount - 1][0] = setNameText;
        this.allLaboTest.fillRow(this.laboData, 0, 0);
        for (int j = 1; j <= moduleCount; ++j) {
            SimpleLaboModule sm = this.laboModules.get(j - 1);
            sm.fillNormaliedData(this.laboData, j, this.allLaboTest);
        }
    }

    public void constructTable() {
        if (this.header != null && this.header.length > 0 && this.laboData != null) {
            LaboTestTableModel model = new LaboTestTableModel(this.laboData, this.header);
            this.table.setModel(model);
            this.rowLabel.setModel(model);
            TableColumnModel tcm = this.table.getColumnModel();
            DefaultTableColumnModel tcm2 = new DefaultTableColumnModel();
            TableColumn col = tcm.getColumn(0);
            tcm.removeColumn(col);
            tcm2.addColumn(col);
            col = tcm2.getColumn(0);
            col.setMinWidth(120);
            col.setPreferredWidth(120);
            this.rowLabel.setColumnModel(tcm2);
            this.rowLabel.setPreferredScrollableViewportSize(this.rowLabel.getPreferredSize());
            tcm = this.table.getColumnModel();
            int cols = tcm.getColumnCount();
            for (int i = 0; i < cols; ++i) {
                col = tcm.getColumn(i);
                col.setMinWidth(120);
                col.setPreferredWidth(120);
            }
            ListSelectionModel m = this.table.getSelectionModel();
            m.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        LaboTestDocumentPanel.this.createLaboTestGraph();
                    }
                }
            });
            this.allLaboTest.clear();
            this.laboModules.clear();
        }
    }

    private void initCustomComponents() {
        this.jScrollPane1.setViewportView(this.table);
        this.jScrollPane1.setRowHeaderView(this.rowLabel);
        this.table.setRowSelectionAllowed(true);
        this.jScrollPane1.setCorner("UPPER_LEFT_CORNER", this.rowLabel.getTableHeader());
        this.table.setDefaultRenderer(this.table.getColumnClass(0), new ImageTableCellRenderer());
        this.table.getTableHeader().setUpdateTableInRealTime(false);
        this.table.setAutoResizeMode(0);
        this.rowLabel.getTableHeader().setUpdateTableInRealTime(false);
        this.rowLabel.setAutoResizeMode(0);
        this.dividerWidth = 10;
        this.dividerLoc = 210;
        this.createControlPanel(this.controlPanel);
        this.laboTestGraph = new LaboTestGraphPanel();
        this.laboTestGraph.setPreferredSize(new Dimension(500, this.dividerLoc));
        this.jScrollPane1.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        this.jScrollPane1.setPreferredSize(new Dimension(3, 600));
        this.splitPane.setLeftComponent(this.laboTestGraph);
        this.splitPane.setRightComponent(this.tablePanel);
        this.splitPane.setDividerSize(this.dividerWidth);
        this.splitPane.setDividerLocation(this.dividerLoc);
    }

    @Override
    public void start() {
        NameValuePair pair = (NameValuePair)this.extractionCombo.getSelectedItem();
        String value = pair.getValue();
        int addValue = Integer.parseInt(value);
        GregorianCalendar today = new GregorianCalendar();
        today.add(2, addValue);
        this.searchLaboTest(MMLDate.getDate(today));
    }

    @Override
    public void stop() {
    }

    private String trimJSpace(String str) {
        String ret = null;
        if (str != null) {
            int index = str.indexOf("\u3000");
            ret = index > 0 ? str.substring(0, index) : str;
        }
        return ret;
    }

    private void searchLaboTest(String fromDate) {
        this.countField.setText("");
        this.table.removeAll();
        final LaboSearchSpec spec = new LaboSearchSpec();
        spec.setKarteId(this.getParentContext().getKarte().getId());
        spec.setFromDate(fromDate);
        spec.setToDate(MMLDate.getDate());
        this.ldl = new RemoteLaboDelegater();
        DBTask<Void> task = new DBTask<Void>(this.getParentContext()){

            @Override
            public Void doInBackground() throws Exception {
                List<LaboModuleValue> results = LaboTestDocumentPanel.this.ldl.getLaboModules(spec);
                if (results == null || results.isEmpty()) {
                    return null;
                }
                LaboTestDocumentPanel.this.laboModules.clear();
                for (LaboModuleValue moduleValue : results) {
                    SimpleLaboModule simpleLaboModule = new SimpleLaboModule();
                    LaboTestDocumentPanel.this.laboModules.add(simpleLaboModule);
                    simpleLaboModule.setSampleTime(moduleValue.getSampleTime());
                    simpleLaboModule.setRegistTime(moduleValue.getRegistTime());
                    simpleLaboModule.setReportTime(moduleValue.getReportTime());
                    simpleLaboModule.setMmlConfirmDate(moduleValue.getConfirmDate());
                    simpleLaboModule.setReportStatus(moduleValue.getReportStatus());
                    simpleLaboModule.setTestCenterName(moduleValue.getLaboratoryCenter());
                    simpleLaboModule.setSet(moduleValue.getSetName());
                    Set<LaboSpecimenValue> specimens = moduleValue.getLaboSpecimens();
                    if (specimens == null) continue;
                    LaboTestDocumentPanel.this.allLaboTest.clear();
                    for (LaboSpecimenValue bean : specimens) {
                        SimpleLaboTest laboTest = new SimpleLaboTest();
                        simpleLaboModule.addSimpleLaboTest(laboTest);
                        SimpleLaboSpecimen specimen = new SimpleLaboSpecimen();
                        laboTest.setSimpleSpecimen(specimen);
                        specimen.setSpecimenCodeID(bean.getSpecimenCodeId());
                        specimen.setSpecimenCode(bean.getSpecimenCode());
                        specimen.setSpecimenName(bean.getSpecimenName());
                        LaboTestDocumentPanel.this.allLaboTest.addSpecimen(specimen);
                        Set<LaboItemValue> items = bean.getLaboItems();
                        if (items == null) continue;
                        for (LaboItemValue itemBean : items) {
                            SimpleLaboTestItem testItem = new SimpleLaboTestItem();
                            LaboTestItemID testItemID = new LaboTestItemID();
                            testItem.setItemCodeID(itemBean.getItemCodeId());
                            testItemID.setItemCodeID(itemBean.getItemCodeId());
                            testItem.setItemCode(itemBean.getItemCode());
                            testItemID.setItemCode(itemBean.getItemCode());
                            testItem.setItemName(LaboTestDocumentPanel.this.trimJSpace(itemBean.getItemName()));
                            testItemID.setItemName(LaboTestDocumentPanel.this.trimJSpace(itemBean.getItemName()));
                            LaboTestDocumentPanel.this.allLaboTest.addTestItem(specimen, testItemID);
                            testItem.setItemValue(itemBean.getItemValue());
                            testItem.setItemUnit(itemBean.getUnit());
                            testItem.setLow(itemBean.getLow());
                            testItem.setUp(itemBean.getUp());
                            testItem.setNormal(itemBean.getNormal());
                            testItem.setOut(itemBean.getNout());
                            laboTest.addSimpleLaboTestItem(testItem);
                        }
                    }
                }
                return null;
            }

            @Override
            public void succeeded(Void result) {
                int count = LaboTestDocumentPanel.this.laboModules.size();
                LaboTestDocumentPanel.this.countField.setText(String.valueOf(count));
                LaboTestDocumentPanel.this.generateObjectsForTable();
                LaboTestDocumentPanel.this.constructTable();
            }
        };
        task.execute();
    }

    private void createLaboTestGraph() {
        int j;
        int[] selectedRows = this.table.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0 || this.laboTestGraph == null) {
            return;
        }
        ArrayList retList = null;
        ArrayList<SimpleLaboTestItem> list = null;
        int columnCount = this.table.getColumnCount();
        boolean hasNonNull = false;
        for (int i = 0; i < selectedRows.length; ++i) {
            list = new ArrayList<SimpleLaboTestItem>();
            hasNonNull = false;
            for (j = 0; j < columnCount; ++j) {
                Object o = this.table.getValueAt(selectedRows[i], j);
                if (o != null && o instanceof SimpleLaboTestItem) {
                    SimpleLaboTestItem item = (SimpleLaboTestItem)o;
                    String value = item.getItemValue();
                    if (value != null) {
                        try {
                            Float.parseFloat(value);
                            list.add(item);
                            hasNonNull = true;
                        }
                        catch (NullPointerException nulle) {
                            list.add(null);
                        }
                        catch (NumberFormatException ne) {
                            list.add(null);
                        }
                        catch (Exception oe) {
                            list.add(null);
                        }
                        continue;
                    }
                    list.add(null);
                    continue;
                }
                list.add(null);
            }
            if (!hasNonNull) continue;
            if (retList == null) {
                retList = new ArrayList();
            }
            retList.add(list);
        }
        if (retList == null || retList.isEmpty()) {
            return;
        }
        String[] sampleTime = new String[this.header.length - 1];
        for (j = 1; j < this.header.length; ++j) {
            int index;
            String val = (String)this.header[j];
            sampleTime[j - 1] = val != null ? ((index = val.indexOf(": ")) > 0 ? val.substring(index + 1) : val) : null;
        }
        this.laboTestGraph.setTestValue(sampleTime, retList, this.getMyGraphMode());
    }

    private int getMyGraphMode() {
        return this.absoluteRadio.isSelected() ? 0 : 1;
    }

    private JPanel createControlPanel(JPanel panel) {
        panel.add(Box.createHorizontalStrut(7));
        panel.add(new JLabel("\u62bd\u51fa\u671f\u9593(\u904e\u53bb)"));
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.extractionCombo.setModel(new DefaultComboBoxModel<NameValuePair>(this.periodObject));
        int past = GlobalVariables.getPreferences().getInt("laboTest.period", -6);
        int index = NameValuePair.getIndex(String.valueOf(past), this.periodObject);
        panel.add(this.comboPanel);
        panel.add(Box.createHorizontalStrut(7));
        panel.add(new JLabel("\u4ef6\u6570"));
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.countPanel);
        panel.add(Box.createHorizontalGlue());
        this.bg.add(this.relativeRadio);
        this.bg.add(this.absoluteRadio);
        panel.add(this.relativeRadio);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.absoluteRadio);
        boolean bAbsolute = this.myPrefs.getBoolean("laboTestDocument.absoluteGraphProp", true);
        this.relativeRadio.setSelected(!bAbsolute);
        this.absoluteRadio.setSelected(bAbsolute);
        panel.add(Box.createHorizontalStrut(7));
        return panel;
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    @Override
    public void enter() {
        this.getParentContext().getChartMediator().setAccepter(this);
        this.disableMenus();
        this.getParentContext().enabledAction("newKarte", true);
        this.getParentContext().enabledAction("newDocument", true);
        this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isReadOnly() {
        return this.getParentContext().isReadOnly();
    }

    public void disableMenus() {
        ChartMediator mediator = this.getParentContext().getChartMediator();
        mediator.disableMenus(CHART_MENUS);
    }

    protected void warning(String title, String message) {
        Window parentWindow = SwingUtilities.getWindowAncestor(this);
        JOptionPane.showMessageDialog(parentWindow, message, GlobalConstants.getFrameTitle(title), 2);
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    @Override
    public boolean update(Object o) {
        return true;
    }

    class ImageTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = -520905432722518156L;
        private Color penCol = Color.black;
        private String upperValueText = "(\u4e0a\u9650\u5024";
        private String standardValueText = "(\u57fa\u6e96\u5024";
        private String lowerValueText = "(\u4e0b\u9650\u5024";

        public ImageTableCellRenderer() {
            this.setOpaque(true);
            this.setBackground(Color.white);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            if (value != null) {
                if (value instanceof String) {
                    this.penCol = Color.black;
                    this.setForeground(this.penCol);
                    this.setText((String)value);
                    this.setToolTipText("");
                } else if (value instanceof SimpleLaboTestItem) {
                    SimpleLaboTestItem testItem = (SimpleLaboTestItem)value;
                    String out = testItem.getOut();
                    this.penCol = out == null ? Color.black : (out.equals("L") ? LaboTestDocumentPanel.this.lowColor : (out.equals("N") ? LaboTestDocumentPanel.this.normalColor : (out.equals("H") ? LaboTestDocumentPanel.this.highColor : Color.black)));
                    this.setForeground(this.penCol);
                    this.setText(testItem.toString());
                    StringBuilder buf = new StringBuilder();
                    if (testItem.getUp() != null) {
                        buf.append(this.upperValueText);
                        buf.append(testItem.getUp());
                        buf.append(") ");
                    }
                    if (testItem.getLow() != null) {
                        buf.append(this.lowerValueText);
                        buf.append(testItem.getLow());
                        buf.append(") ");
                    }
                    if (testItem.getNormal() != null) {
                        buf.append(this.standardValueText);
                        buf.append(testItem.getNormal());
                        buf.append(")");
                    }
                    if (buf.length() > 0) {
                        this.setToolTipText(buf.toString());
                    }
                } else if (value instanceof SimpleLaboSpecimen) {
                    SimpleLaboSpecimen specimen = (SimpleLaboSpecimen)value;
                    this.setBackground(LaboTestDocumentPanel.this.specimenColor);
                    this.setForeground(Color.black);
                    this.setText(specimen.toString());
                }
            } else {
                this.penCol = Color.black;
                this.setForeground(this.penCol);
                this.setText("");
                this.setToolTipText("");
            }
            return this;
        }
    }

    class LaboTestTableModel
    extends DefaultTableModel {
        private LaboTestTableModel(Object[][] laboData, Object[] header) {
            super(laboData, header);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

