/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.pvtclientserver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import open.dolphin.client.ModelSender;
import open.dolphin.infomodel.PatientVisitModel;
import open.dolphin.log.LogWriter;
import open.dolphin.pvtclientserver.IHandler;
import open.dolphin.pvtclientserver.PVTBuilder;
import open.dolphin.utils.DebugDump;

public class PVTMessageReader
implements IHandler {
    private static final int BUFFER_SIZE = 8192;
    private static final int EOT = 4;
    private static final int ACK = 6;
    private byte[] data = new byte[81920];
    private int length;
    private String encode;

    public PVTMessageReader(String encode) {
        this.encode = encode;
    }

    @Override
    public void handle(SelectionKey key) throws ClosedChannelException, IOException {
        if (key.isReadable()) {
            try {
                this.read(key);
            }
            catch (SQLException ex) {
                LogWriter.error(this.getClass(), ex);
            }
        }
    }

    private void read(SelectionKey key) throws ClosedChannelException, IOException, SQLException {
        SocketChannel channel = (SocketChannel)key.channel();
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        buffer.clear();
        int len = channel.read(buffer);
        if (len < 0) {
            channel.close();
            String pvtXml = new String(this.data, 0, this.length - 1, this.encode);
            DebugDump.dumpToFile("receivePvt.log", pvtXml);
            BufferedReader patientInfo = new BufferedReader(new StringReader(pvtXml));
            PVTBuilder builder = new PVTBuilder();
            builder.parse(patientInfo);
            PatientVisitModel model = builder.getProduct();
            LogWriter.info(this.getClass(), model.getPatientName() + "\u3055\u3093\u306e\u6765\u9662\u60c5\u5831\u3092 Queue \u3078\u767b\u9332\u3057\u307e\u3057\u305f");
            ModelSender.getInstance().offer(model);
        } else {
            buffer.flip();
            buffer.get(this.data, this.length, len);
            this.length += len;
            if (buffer.get(len - 1) == 4) {
                LogWriter.debug(this.getClass(), "Received EOT");
                ByteBuffer ackBuf2 = ByteBuffer.wrap(new byte[]{6});
                channel.write(ackBuf2);
                LogWriter.debug(this.getClass(), "ACK \u3092\u8fd4\u3057\u3057\u307e\u3057\u305f");
            }
        }
    }
}

