/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Rectangle;
import java.awt.image.Raster;

public final class UnpackedImageData {
    public final Raster raster;
    public final Rectangle rect;
    public final int type;
    public final Object data;
    public final int pixelStride;
    public final int lineStride;
    public final int[] bandOffsets;
    public final boolean convertToDest;

    public UnpackedImageData(Raster raster, Rectangle rectangle, int n, Object object, int n2, int n3, int[] nArray, boolean bl) {
        this.raster = raster;
        this.rect = rectangle;
        this.type = n;
        this.data = object;
        this.pixelStride = n2;
        this.lineStride = n3;
        this.bandOffsets = nArray;
        this.convertToDest = bl;
    }

    public byte[][] getByteData() {
        return this.type == 0 ? (byte[][])this.data : null;
    }

    public byte[] getByteData(int n) {
        byte[][] byArray = this.getByteData();
        return byArray == null ? null : byArray[n];
    }

    public short[][] getShortData() {
        return (short[][])(this.type == 1 || this.type == 2 ? (short[][])this.data : null);
    }

    public short[] getShortData(int n) {
        short[][] sArray = this.getShortData();
        return sArray == null ? null : sArray[n];
    }

    public int[][] getIntData() {
        return this.type == 3 ? (int[][])this.data : null;
    }

    public int[] getIntData(int n) {
        int[][] nArray = this.getIntData();
        return nArray == null ? null : nArray[n];
    }

    public float[][] getFloatData() {
        return this.type == 4 ? (float[][])this.data : null;
    }

    public float[] getFloatData(int n) {
        float[][] fArray = this.getFloatData();
        return fArray == null ? null : fArray[n];
    }

    public double[][] getDoubleData() {
        return this.type == 5 ? (double[][])this.data : null;
    }

    public double[] getDoubleData(int n) {
        double[][] dArray = this.getDoubleData();
        return dArray == null ? null : dArray[n];
    }

    public int getOffset(int n) {
        return this.bandOffsets[n];
    }

    public int getMinOffset() {
        int n = this.bandOffsets[0];
        int n2 = 1;
        while (n2 < this.bandOffsets.length) {
            n = Math.min(n, this.bandOffsets[n2]);
            ++n2;
        }
        return n;
    }

    public int getMaxOffset() {
        int n = this.bandOffsets[0];
        int n2 = 1;
        while (n2 < this.bandOffsets.length) {
            n = Math.max(n, this.bandOffsets[n2]);
            ++n2;
        }
        return n;
    }
}

