/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.image;

import java.util.Iterator;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import org.dcm4cheri.image.ConfigurationException;
import org.dcm4cheri.image.ConfigurationUtils;

public class ImageWriterFactory {
    private static final ImageWriterFactory instance = new ImageWriterFactory();
    private final Properties map = new Properties();

    public static final ImageWriterFactory getInstance() {
        return instance;
    }

    private ImageWriterFactory() {
        ConfigurationUtils.loadPropertiesForClass(this.map, ImageWriterFactory.class);
    }

    public ImageWriter getWriterForTransferSyntax(String tsuid) {
        String s = this.map.getProperty(tsuid);
        if (s == null) {
            throw new UnsupportedOperationException("No Image Writer available for Transfer Syntax:" + tsuid);
        }
        int delim = s.indexOf(44);
        if (delim == -1) {
            throw new ConfigurationException("Missing ',' in " + tsuid + "=" + s);
        }
        String formatName = s.substring(0, delim);
        String className = s.substring(delim + 1);
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName(formatName);
        while (it.hasNext()) {
            ImageWriter r = it.next();
            if (!className.equals(r.getClass().getName())) continue;
            return r;
        }
        throw new ConfigurationException("No Image Writer of class " + className + " available for format:" + formatName);
    }
}

