/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Request;
import org.dcm4cheri.srom.CodeImpl;

class RequestImpl
implements Request {
    static final Request[] EMPTY_ARRAY = new Request[0];
    private final String studyInstanceUID;
    private final String accessionNumber;
    private final String fillerOrderNumber;
    private final String placerOrderNumber;
    private final String procedureID;
    private final String procedureDescription;
    private final Code procedureCode;

    public RequestImpl(String studyInstanceUID, String accessionNumber, String fillerOrderNumber, String placerOrderNumber, String procedureID, String procedureDescription, Code procedureCode) {
        this.studyInstanceUID = studyInstanceUID;
        if (this.studyInstanceUID.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.accessionNumber = accessionNumber;
        this.fillerOrderNumber = fillerOrderNumber;
        this.placerOrderNumber = placerOrderNumber;
        this.procedureID = procedureID;
        this.procedureDescription = procedureDescription;
        this.procedureCode = procedureCode;
    }

    public RequestImpl(Dataset ds) throws DcmValueException {
        this(ds.getString(0x20000D), ds.getString(524368), ds.getString(4202519), ds.getString(4202518), ds.getString(0x401001), ds.getString(3280992), CodeImpl.newCode(ds.getItem(3280996)));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RequestImpl)) {
            return false;
        }
        RequestImpl o = (RequestImpl)obj;
        return this.studyInstanceUID.equals(o.studyInstanceUID);
    }

    public int hashCode() {
        return this.studyInstanceUID.hashCode();
    }

    public String toString() {
        return "Request[uid=" + this.studyInstanceUID + ",accession=" + this.accessionNumber + ",fillerOrd=" + this.fillerOrderNumber + ",placerOrd=" + this.placerOrderNumber + ",procedure(" + this.procedureID + "," + this.procedureDescription + "," + this.procedureCode + ")]";
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public String getFillerOrderNumber() {
        return this.fillerOrderNumber;
    }

    public String getPlacerOrderNumber() {
        return this.placerOrderNumber;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public String getProcedureID() {
        return this.procedureID;
    }

    public String getProcedureDescription() {
        return this.procedureDescription;
    }

    public Code getProcedureCode() {
        return this.procedureCode;
    }

    public void toDataset(Dataset ds) {
        ds.putUI(0x20000D, this.studyInstanceUID);
        ds.putLO(524368, this.accessionNumber);
        ds.putLO(4202519, this.fillerOrderNumber);
        ds.putLO(4202518, this.placerOrderNumber);
        ds.putSH(0x401001, this.procedureID);
        ds.putLO(3280992, this.procedureDescription);
        if (this.procedureCode != null) {
            this.procedureCode.toDataset(ds.putSQ(3280996).addNewItem());
        }
    }
}

