/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * SymptomsDialog.java
 *
 * Created on 2009/11/09, 13:43:29
 */
package open.dolphin.client;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import open.dolphin.container.Pair;
import open.dolphin.dao.SqlMasterDao;
import open.dolphin.infomodel.InteractEntry;
import open.dolphin.infomodel.SsKijyoEntry;

/**
 *　禁忌　MEMO:画面
 * @author
 */
public class SymptomsDialog extends javax.swing.JDialog {

    private boolean isCancel;

    /** Creates new form SymptomsDialog
     * @param parent 
     * @param modal
     * @param dao
     * @param symptoms
     */
    public SymptomsDialog(java.awt.Frame parent, boolean modal, SqlMasterDao dao, List<Pair<InteractEntry, SsKijyoEntry>> symptoms) {
        super(parent, modal);
        initComponents();

        DefaultTableModel symptomsModel = new DefaultTableModel() {

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        
        symptomsModel.addColumn("薬剤名称");
        symptomsModel.addColumn("薬剤名称");
        symptomsModel.addColumn("症状");
        symptomsModel.addColumn("原因");

        symptomTable.setModel(symptomsModel);

        for (Pair<InteractEntry, SsKijyoEntry> symptom : symptoms) {
            List row = new ArrayList(4);
            row.add(dao.getNameByCode(symptom.key.getPharmaceuticalsCodeFrom()));
            row.add(dao.getNameByCode(symptom.key.getPharmaceuticalsCodeTo()));
            row.add(symptom.value.getSymptoms());
            row.add(symptom.value.getInteract());
            symptomsTextArea.setText(symptom.value.getSymptoms());
            interactTextArea.setText(symptom.value.getInteract());
            symptomsModel.addRow(row.toArray());
        }
    }
    /**
     *
     * @return
     */
    public boolean IsCancel() {
        return isCancel;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        symptomTable = new javax.swing.JTable();
        jButton1 = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        symptomsTextArea = new javax.swing.JTextArea();
        jScrollPane3 = new javax.swing.JScrollPane();
        interactTextArea = new javax.swing.JTextArea();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jButton2 = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("禁忌があります");
        setLocationByPlatform(true);
        setModal(true);
        setResizable(false);

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        symptomTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "薬剤１", "薬剤２", "症状", "原因"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, false, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        symptomTable.setName("symptomTable"); // NOI18N
        symptomTable.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        symptomTable.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                symptomTableMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(symptomTable);

        jButton1.setText("追加する");
        jButton1.setName("jButton1"); // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jScrollPane2.setName("jScrollPane2"); // NOI18N

        symptomsTextArea.setColumns(20);
        symptomsTextArea.setEditable(false);
        symptomsTextArea.setLineWrap(true);
        symptomsTextArea.setAutoscrolls(false);
        symptomsTextArea.setFocusable(false);
        symptomsTextArea.setName("symptomsTextArea"); // NOI18N
        jScrollPane2.setViewportView(symptomsTextArea);

        jScrollPane3.setName("jScrollPane3"); // NOI18N

        interactTextArea.setColumns(20);
        interactTextArea.setEditable(false);
        interactTextArea.setLineWrap(true);
        interactTextArea.setRows(5);
        interactTextArea.setAutoscrolls(false);
        interactTextArea.setFocusable(false);
        interactTextArea.setName("interactTextArea"); // NOI18N
        jScrollPane3.setViewportView(interactTextArea);

        jLabel1.setText("原因");
        jLabel1.setName("jLabel1"); // NOI18N

        jLabel2.setText("症状");
        jLabel2.setName("jLabel2"); // NOI18N

        jButton2.setText("追加しない");
        jButton2.setName("jButton2"); // NOI18N
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 606, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 606, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 606, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel2))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel1))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(166, 166, 166)
                        .addComponent(jButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 143, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(jButton2, javax.swing.GroupLayout.PREFERRED_SIZE, 135, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 138, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(9, 9, 9)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 71, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButton1)
                    .addComponent(jButton2))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents
    /**
     *
     * @param evt
     */
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed

        isCancel = false;
        this.setVisible(false);
    }//GEN-LAST:event_jButton1ActionPerformed
    /**
     *
     * @param evt
     */
    private void symptomTableMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_symptomTableMouseClicked
        int selectedIndex = symptomTable.getSelectedRow();
        symptomsTextArea.setText((String) ((DefaultTableModel) symptomTable.getModel()).getValueAt(selectedIndex, 2));
        interactTextArea.setText((String) ((DefaultTableModel) symptomTable.getModel()).getValueAt(selectedIndex, 3));
    }//GEN-LAST:event_symptomTableMouseClicked
    /**
     * 
     * @param evt
     */
    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed

        isCancel = true;
        this.setVisible(false);
    }//GEN-LAST:event_jButton2ActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea interactTextArea;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTable symptomTable;
    private javax.swing.JTextArea symptomsTextArea;
    // End of variables declaration//GEN-END:variables
}
