/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import org.jdesktop.application.Application;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleFrameApplication
extends Application {
    private static final Logger logger = Logger.getLogger(SingleFrameApplication.class.getName());
    private ResourceMap appResources = null;
    private FrameView mainView = null;

    public final JFrame getMainFrame() {
        return this.getMainView().getFrame();
    }

    protected final void setMainFrame(JFrame mainFrame) {
        this.getMainView().setFrame(mainFrame);
    }

    private String sessionFilename(Window window) {
        if (window == null) {
            return null;
        }
        String name = window.getName();
        return name == null ? null : name + ".session.xml";
    }

    protected void configureWindow(Window root) {
        this.getContext().getResourceMap().injectComponents(root);
    }

    private void initRootPaneContainer(RootPaneContainer c) {
        String filename;
        Window window;
        JFrame mainFrame;
        String k;
        JRootPane rootPane = c.getRootPane();
        if (rootPane.getClientProperty(k = "SingleFrameApplication.initRootPaneContainer") != null) {
            return;
        }
        rootPane.putClientProperty(k, Boolean.TRUE);
        Container root = rootPane.getParent();
        if (root instanceof Window) {
            this.configureWindow((Window)root);
        }
        if (c == (mainFrame = this.getMainFrame())) {
            mainFrame.addWindowListener(new MainFrameListener());
            mainFrame.setDefaultCloseOperation(0);
        } else if (root instanceof Window) {
            window = (Window)root;
            window.addHierarchyListener(new SecondaryWindowListener());
        }
        if (root instanceof JFrame) {
            root.addComponentListener(new FrameBoundsListener());
        }
        if (root instanceof Window && (root.getWidth() == 0 || root.getHeight() == 0)) {
            window = (Window)root;
            window.pack();
            if (!window.isLocationByPlatform()) {
                JFrame owner = c != mainFrame ? mainFrame : null;
                window.setLocationRelativeTo(owner);
            }
        }
        if (root instanceof Window && (filename = this.sessionFilename((Window)root)) != null) {
            try {
                this.getContext().getSessionStorage().restore(root, filename);
            }
            catch (Exception e) {
                String msg = String.format("couldn't restore sesssion [%s]", filename);
                logger.log(Level.WARNING, msg, e);
            }
        }
    }

    protected void show(JComponent c) {
        if (c == null) {
            throw new IllegalArgumentException("null JComponent");
        }
        JFrame f = this.getMainFrame();
        f.getContentPane().add((Component)c, "Center");
        this.initRootPaneContainer(f);
        f.setVisible(true);
    }

    public void show(JDialog c) {
        if (c == null) {
            throw new IllegalArgumentException("null JDialog");
        }
        this.initRootPaneContainer(c);
        c.setVisible(true);
    }

    public void show(JFrame c) {
        if (c == null) {
            throw new IllegalArgumentException("null JFrame");
        }
        this.initRootPaneContainer(c);
        c.setVisible(true);
    }

    private void saveSession(Window window) {
        String filename = this.sessionFilename(window);
        if (filename != null) {
            try {
                this.getContext().getSessionStorage().save(window, filename);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "couldn't save sesssion", e);
            }
        }
    }

    private boolean isVisibleWindow(Window w) {
        return w.isVisible() && (w instanceof JFrame || w instanceof JDialog || w instanceof JWindow);
    }

    private List<Window> getVisibleSecondaryWindows() {
        ArrayList<Window> rv;
        block8: {
            block7: {
                rv = new ArrayList<Window>();
                Method getWindowsM = null;
                try {
                    getWindowsM = Window.class.getMethod("getWindows", new Class[0]);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if (getWindowsM == null) break block7;
                Window[] windows = null;
                try {
                    windows = (Window[])getWindowsM.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    throw new Error("HCTB - can't get top level windows list", e);
                }
                if (windows == null) break block8;
                for (Window window : windows) {
                    if (!this.isVisibleWindow(window)) continue;
                    rv.add(window);
                }
                break block8;
            }
            Frame[] frames = Frame.getFrames();
            if (frames != null) {
                for (Frame frame : frames) {
                    if (!this.isVisibleWindow(frame)) continue;
                    rv.add(frame);
                }
            }
        }
        return rv;
    }

    @Override
    protected void shutdown() {
        this.saveSession(this.getMainFrame());
        for (Window window : this.getVisibleSecondaryWindows()) {
            this.saveSession(window);
        }
    }

    public FrameView getMainView() {
        if (this.mainView == null) {
            this.mainView = new FrameView(this);
        }
        return this.mainView;
    }

    @Override
    public void show(View view) {
        if (this.mainView == null && view instanceof FrameView) {
            this.mainView = (FrameView)view;
        }
        RootPaneContainer c = (RootPaneContainer)((Object)view.getRootPane().getParent());
        this.initRootPaneContainer(c);
        ((Window)((Object)c)).setVisible(true);
    }

    private static class FrameBoundsListener
    implements ComponentListener {
        private FrameBoundsListener() {
        }

        private void maybeSaveFrameSize(ComponentEvent e) {
            JFrame f;
            if (e.getComponent() instanceof JFrame && ((f = (JFrame)e.getComponent()).getExtendedState() & 6) == 0) {
                String clientPropertyKey = "WindowState.normalBounds";
                f.getRootPane().putClientProperty(clientPropertyKey, f.getBounds());
            }
        }

        public void componentResized(ComponentEvent e) {
            this.maybeSaveFrameSize(e);
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }
    }

    private class SecondaryWindowListener
    implements HierarchyListener {
        private SecondaryWindowListener() {
        }

        public void hierarchyChanged(HierarchyEvent e) {
            Window secondaryWindow;
            if ((e.getChangeFlags() & 4L) != 0L && e.getSource() instanceof Window && !(secondaryWindow = (Window)e.getSource()).isShowing()) {
                SingleFrameApplication.this.saveSession(secondaryWindow);
            }
        }
    }

    private class MainFrameListener
    extends WindowAdapter {
        private MainFrameListener() {
        }

        public void windowClosing(WindowEvent e) {
            SingleFrameApplication.this.exit(e);
        }
    }
}

