/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.dcm4cheri.util.StringUtils;

public class Executer {
    static final Logger log = Logger.getLogger(Executer.class);
    private final String cmd;
    private final Process child;
    private final Thread stdoutReader;
    private final Thread stderrReader;

    private static String[] tokenize(String cmd) {
        ArrayList<String> cmdarray = new ArrayList<String>();
        int len = cmd.length();
        char[] c = new char[len + 1];
        cmd.getChars(0, len, c, 0);
        c[len] = 32;
        int delim = 0;
        int off = 0;
        for (int i = 0; i <= len; ++i) {
            if (delim == 0) {
                if (c[i] == ' ') continue;
                if (c[i] == '\"') {
                    delim = 34;
                    off = i + 1;
                    continue;
                }
                delim = 32;
                off = i;
                continue;
            }
            if (c[i] != delim) continue;
            int count = i - off;
            if (count > 0) {
                cmdarray.add(new String(c, off, count));
            }
            delim = 0;
        }
        return cmdarray.toArray(new String[cmdarray.size()]);
    }

    public Executer(String cmd) throws IOException {
        this(cmd, null, null);
    }

    public Executer(String[] cmdarray) throws IOException {
        this(cmdarray, null, null);
    }

    public Executer(String cmd, OutputStream stdout, OutputStream stderr) throws IOException {
        this(Executer.tokenize(cmd), stdout, stderr);
    }

    public Executer(String[] cmdarray, OutputStream stdout, OutputStream stderr) throws IOException {
        this.cmd = StringUtils.toString(cmdarray, ' ');
        if (log.isDebugEnabled()) {
            log.debug("invoke: " + this.cmd);
        }
        this.child = Runtime.getRuntime().exec(cmdarray);
        this.stdoutReader = this.startCopy(this.child.getInputStream(), stdout);
        this.stderrReader = this.startCopy(this.child.getErrorStream(), stderr);
    }

    public final String cmd() {
        return this.cmd;
    }

    public int waitFor() throws InterruptedException {
        this.stdoutReader.join();
        this.stderrReader.join();
        int exit = this.child.waitFor();
        if (log.isDebugEnabled()) {
            log.debug("exit(" + exit + "): " + this.cmd);
        }
        return exit;
    }

    public void destroy() {
        this.child.destroy();
    }

    private Thread startCopy(final InputStream in, final OutputStream out) {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    int len;
                    byte[] buf = new byte[512];
                    while ((len = in.read(buf)) != -1) {
                        if (out == null) continue;
                        out.write(buf, 0, len);
                    }
                }
                catch (IOException e) {
                    log.warn("i/o error reading stdout/stderr of " + Executer.this.cmd, e);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.warn("i/o exception on close of stdout/stderr of " + Executer.this.cmd, e);
                    }
                }
            }
        });
        t.start();
        return t;
    }
}

