/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.util;

import org.dcm4che.util.MLLP_Protocol;

public final class MLLP_URL {
    private MLLP_Protocol protocol;
    private String host;
    private int port = 0;

    public MLLP_URL(String spec) {
        this.parse(spec.trim());
    }

    public MLLP_URL(String protocol, String host, int port) {
        this.protocol = MLLP_Protocol.valueOf(protocol);
        this.host = host;
        this.port = port;
    }

    public final String getProtocol() {
        return this.protocol.toString();
    }

    public final boolean isTLS() {
        return this.protocol.isTLS();
    }

    public final String[] getCipherSuites() {
        return this.protocol.getCipherSuites();
    }

    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public String toString() {
        return this.protocol.toString() + "://" + this.host + ':' + this.port;
    }

    private void parse(String s) {
        int delimPos1 = s.indexOf("://");
        if (delimPos1 == -1) {
            throw new IllegalArgumentException(s);
        }
        int delimPos2 = s.indexOf(58, delimPos1 + 3);
        if (delimPos2 == -1) {
            throw new IllegalArgumentException(s);
        }
        this.protocol = MLLP_Protocol.valueOf(s.substring(0, delimPos1));
        this.host = s.substring(delimPos1 + 3, delimPos2);
        this.port = Integer.parseInt(s.substring(delimPos2 + 1));
    }
}

