/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import org.dcm4che.util.HostNameUtils;

public class SyslogWriter
extends OutputStreamWriter {
    private static final String[] MONTH = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] DAY = new String[]{null, " 1", " 2", " 3", " 4", " 5", " 6", " 7", " 8", " 9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    private static final String[] MINUTE = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59"};
    public static final int LOG_EMERG = 0;
    public static final int LOG_ALERT = 1;
    public static final int LOG_CRIT = 2;
    public static final int LOG_ERR = 3;
    public static final int LOG_WARNING = 4;
    public static final int LOG_NOTICE = 5;
    public static final int LOG_INFO = 6;
    public static final int LOG_DEBUG = 7;
    public static final int LOG_KERN = 0;
    public static final int LOG_USER = 8;
    public static final int LOG_MAIL = 16;
    public static final int LOG_DAEMON = 24;
    public static final int LOG_AUTH = 32;
    public static final int LOG_SYSLOG = 40;
    public static final int LOG_LPR = 48;
    public static final int LOG_NEWS = 56;
    public static final int LOG_UUCP = 64;
    public static final int LOG_CRON = 72;
    public static final int LOG_AUTHPRIV = 80;
    public static final int LOG_FTP = 88;
    public static final int LOG_LOCAL0 = 128;
    public static final int LOG_LOCAL1 = 136;
    public static final int LOG_LOCAL2 = 144;
    public static final int LOG_LOCAL3 = 152;
    public static final int LOG_LOCAL4 = 160;
    public static final int LOG_LOCAL5 = 168;
    public static final int LOG_LOCAL6 = 176;
    public static final int LOG_LOCAL7 = 184;
    private static final String[] LEVEL = new String[]{"emerg", "alert", "crit", "err", "warning", "notice", "info", "debug"};
    public String syslogHost;
    public int syslogPort = 514;
    private String tag;
    private int facility = 8;
    private InetAddress address;
    private DatagramSocket ds;
    private boolean printHostName = true;
    private String contentPrefix = "";
    private final MyByteArrayOutputStream bout;

    public static String levelAsString(int level) {
        try {
            return LEVEL[level];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("level: " + level);
        }
    }

    public static final int forName(String name) {
        try {
            return SyslogWriter.class.getField("LOG_" + name.toUpperCase()).getInt(null);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(name);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    public SyslogWriter() {
        this(new MyByteArrayOutputStream());
    }

    private SyslogWriter(MyByteArrayOutputStream bout) {
        super(bout);
        this.bout = bout;
    }

    public void setSyslogHost(String syslogHost) throws UnknownHostException {
        this.address = InetAddress.getByName(syslogHost);
        this.syslogHost = syslogHost;
    }

    public String getSyslogHost() {
        return this.syslogHost;
    }

    public void setSyslogPort(int syslogPort) {
        this.syslogPort = syslogPort;
    }

    public int getSyslogPort() {
        return this.syslogPort;
    }

    public void setPrintHostName(boolean printHostName) {
        this.printHostName = printHostName;
    }

    public void setContentPrefix(String contentPrefix) {
        this.contentPrefix = contentPrefix;
    }

    public void setFacility(String facility) {
        this.facility = SyslogWriter.forName(facility);
    }

    public String getFacilityAsString() {
        switch (this.facility) {
            case 0: {
                return "kern";
            }
            case 8: {
                return "user";
            }
            case 16: {
                return "mail";
            }
            case 24: {
                return "daemon";
            }
            case 32: {
                return "auth";
            }
            case 40: {
                return "syslog";
            }
            case 48: {
                return "lpr";
            }
            case 56: {
                return "news";
            }
            case 64: {
                return "uucp";
            }
            case 72: {
                return "cron";
            }
            case 80: {
                return "authpriv";
            }
            case 88: {
                return "ftp";
            }
            case 128: {
                return "local0";
            }
            case 136: {
                return "local1";
            }
            case 144: {
                return "local2";
            }
            case 152: {
                return "local3";
            }
            case 160: {
                return "local4";
            }
            case 168: {
                return "local5";
            }
            case 176: {
                return "local6";
            }
            case 184: {
                return "local7";
            }
        }
        throw new RuntimeException();
    }

    public void setFacility(int facility) {
        switch (facility) {
            case 0: 
            case 8: 
            case 16: 
            case 24: 
            case 32: 
            case 40: 
            case 48: 
            case 56: 
            case 64: 
            case 72: 
            case 80: 
            case 88: 
            case 128: 
            case 136: 
            case 144: 
            case 152: 
            case 160: 
            case 168: 
            case 176: 
            case 184: {
                break;
            }
            default: {
                throw new IllegalArgumentException("facility: " + facility);
            }
        }
        this.facility = facility;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public synchronized void writeHeader(int level) throws IOException {
        this.writeHeader(level, System.currentTimeMillis());
    }

    public synchronized void writeHeader(int level, long millis) throws IOException {
        if ((level & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException("level: " + level);
        }
        this.reset();
        this.write(60);
        this.write(String.valueOf(this.facility | level));
        this.write(62);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        this.write(MONTH[cal.get(2)]);
        this.write(32);
        this.write(DAY[cal.get(5)]);
        this.write(32);
        this.write(MINUTE[cal.get(11)]);
        this.write(58);
        this.write(MINUTE[cal.get(12)]);
        this.write(58);
        this.write(MINUTE[cal.get(13)]);
        this.write(32);
        if (this.printHostName) {
            this.write(HostNameUtils.getLocalHostName());
            this.write(32);
        }
        if (this.tag != null) {
            this.write(this.tag);
        }
        this.write(this.contentPrefix);
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        super.flush();
        this.bout.writeTo(out);
    }

    public synchronized void write(int level, String msg) throws IOException {
        this.write(level, msg, System.currentTimeMillis());
    }

    public synchronized void write(int level, String msg, long millis) throws IOException {
        this.writeHeader(level, millis);
        this.write(msg);
        this.flush();
    }

    public synchronized void writeTo(int level, String msg, OutputStream out) throws IOException {
        this.writeTo(level, msg, out, System.currentTimeMillis());
    }

    public synchronized void writeTo(int level, String msg, OutputStream out, long millis) throws IOException {
        this.writeHeader(level, millis);
        this.write(msg);
        this.writeTo(out);
    }

    public synchronized void reset() throws IOException {
        super.flush();
        this.bout.reset();
    }

    public synchronized void flush() throws IOException {
        if (this.address == null) {
            this.address = InetAddress.getLocalHost();
        }
        if (this.ds == null) {
            this.ds = new DatagramSocket();
        }
        super.flush();
        if (this.bout.size() > 0) {
            this.ds.send(new DatagramPacket(this.bout.getBuffer(), this.bout.size(), this.address, this.syslogPort));
            this.bout.reset();
        }
    }

    private static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        private MyByteArrayOutputStream() {
        }

        byte[] getBuffer() {
            return this.buf;
        }
    }
}

