/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.auditlog;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.dcm4che.auditlog.RemoteNode;
import org.dcm4che.data.Dataset;
import org.dcm4che.util.Base64;
import org.dcm4cheri.auditlog.IHEYr4;

class DicomQuery
implements IHEYr4.Message {
    private String keys;
    private RemoteNode requestor;
    private String cuid;

    public DicomQuery(Dataset keys, RemoteNode requestor, String cuid) {
        this.keys = DicomQuery.encode(keys);
        this.requestor = requestor;
        this.cuid = cuid;
    }

    private static String encode(Dataset keys) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(512);
        try {
            keys.writeDataset(bout, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize keys", e);
        }
        return Base64.byteArrayToBase64(bout.toByteArray());
    }

    public void writeTo(StringBuffer sb) {
        sb.append("<DicomQuery><Keys>").append(this.keys).append("</Keys><Requestor>");
        this.requestor.writeTo(sb);
        sb.append("</Requestor><CUID>").append(this.cuid).append("</CUID></DicomQuery>");
    }
}

