/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.auditlog;

import java.util.Date;
import org.dcm4che.auditlog.InstancesAction;
import org.dcm4che.auditlog.MediaDescription;
import org.dcm4che.auditlog.Patient;
import org.dcm4che.auditlog.RemoteNode;
import org.dcm4che.auditlog.User;
import org.dcm4che.data.Dataset;
import org.dcm4che.util.ISO8601DateFormat;
import org.dcm4cheri.auditlog.ActorConfig;
import org.dcm4cheri.auditlog.ActorStartStop;
import org.dcm4cheri.auditlog.DicomQuery;
import org.dcm4cheri.auditlog.Export;
import org.dcm4cheri.auditlog.PatientRecord;
import org.dcm4cheri.auditlog.ProcedureRecord;
import org.dcm4cheri.auditlog.RnodeWithInstanceActionDescription;
import org.dcm4cheri.auditlog.SecurityAlert;
import org.dcm4cheri.auditlog.StudyDeleted;
import org.dcm4cheri.auditlog.UserAuthenticated;

class IHEYr4 {
    private static String localHostName;
    private Message msg;
    private String host;
    private long millis;

    private IHEYr4(Message msg, String host, long millis) {
        this.msg = msg;
        this.host = host;
        this.millis = millis;
    }

    public static IHEYr4 newInstancesStored(RemoteNode rnode, InstancesAction action, String host, long millis) {
        return new IHEYr4(new RnodeWithInstanceActionDescription("InstancesStored", rnode, action, "RemoteNode"), host, millis);
    }

    public static IHEYr4 newBeginStoringInstances(RemoteNode rnode, InstancesAction action, String host, long millis) {
        return new IHEYr4(new RnodeWithInstanceActionDescription("BeginStoringInstances", rnode, action, "Rnode"), host, millis);
    }

    public static IHEYr4 newInstancesSent(RemoteNode rnode, InstancesAction action, String host, long millis) {
        return new IHEYr4(new RnodeWithInstanceActionDescription("InstancesSent", rnode, action, "RNode"), host, millis);
    }

    public static IHEYr4 newActorStartStop(String actorName, String applicationAction, User user, String host, long millis) {
        return new IHEYr4(new ActorStartStop(actorName, applicationAction, user), host, millis);
    }

    public static IHEYr4 newActorConfig(String description, User user, String configType, String host, long millis) {
        return new IHEYr4(new ActorConfig(description, user, configType), host, millis);
    }

    public static IHEYr4 newStudyDeleted(InstancesAction action, String desc, String host, long millis) {
        return new IHEYr4(new StudyDeleted(action, desc), host, millis);
    }

    public static IHEYr4 newPatientRecord(String action, Patient patient, User user, String desc, String host, long millis) {
        return new IHEYr4(new PatientRecord(action, patient, user, desc), host, millis);
    }

    public static IHEYr4 newProcedureRecord(String action, String placerOrderNumber, String fillerOrderNumber, String suid, String accessionNumber, Patient patient, User user, String desc, String host, long millis) {
        return new IHEYr4(new ProcedureRecord(action, placerOrderNumber, fillerOrderNumber, suid, accessionNumber, patient, user, desc), host, millis);
    }

    public static IHEYr4 newDicomQuery(Dataset keys, RemoteNode requestor, String cuid, String host, long millis) {
        return new IHEYr4(new DicomQuery(keys, requestor, cuid), host, millis);
    }

    public static IHEYr4 newSecurityAlert(String alertType, User user, String description, String host, long millis) {
        return new IHEYr4(new SecurityAlert(alertType, user, description), host, millis);
    }

    public static IHEYr4 newUserAuthenticated(String localUserName, String action, String host, long millis) {
        return new IHEYr4(new UserAuthenticated(localUserName, action), host, millis);
    }

    public static IHEYr4 newExport(MediaDescription media, User user, String host, long millis) {
        return new IHEYr4(new Export(media, user), host, millis);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(512);
        sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><IHEYr4>");
        this.msg.writeTo(sb);
        sb.append("<Host>").append(this.host).append("</Host><TimeStamp>");
        sb.append(new ISO8601DateFormat().format(new Date(this.millis)));
        sb.append("</TimeStamp></IHEYr4>");
        return sb.toString();
    }

    static interface Message {
        public void writeTo(StringBuffer var1);
    }
}

