/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.auditlog;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.dcm4che.auditlog.InstancesAction;
import org.dcm4che.auditlog.Patient;
import org.dcm4che.auditlog.User;

class InstancesActionImpl
implements InstancesAction {
    private String action;
    private String accessionNumber;
    private LinkedHashSet suids = new LinkedHashSet(3);
    private Patient patient;
    private User user;
    private LinkedHashSet cuids = new LinkedHashSet(7);
    private int numberOfInstances = 0;
    private String mppsUID;

    public InstancesActionImpl(String action, String suid, Patient patient) {
        this.action = action;
        this.addStudyInstanceUID(suid);
        this.patient = patient;
    }

    public final void setAccessionNumber(String accessionNumber) {
        this.accessionNumber = accessionNumber;
    }

    public final void addStudyInstanceUID(String suid) {
        this.suids.add(suid);
    }

    public final String[] listStudyInstanceUIDs() {
        return this.suids.toArray(new String[this.suids.size()]);
    }

    public final void addSOPClassUID(String cuid) {
        this.cuids.add(cuid);
    }

    public final void clearSOPClassUIDs() {
        this.cuids.clear();
    }

    public final String[] listSOPClassUIDs() {
        return this.cuids.toArray(new String[this.cuids.size()]);
    }

    public final void setUser(User user) {
        this.user = user;
    }

    public final void setNumberOfInstances(int numberOfInstances) {
        this.numberOfInstances = numberOfInstances;
    }

    public final void incNumberOfInstances(int inc) {
        this.numberOfInstances += inc;
    }

    public final void setMPPSInstanceUID(String mppsUID) {
        this.mppsUID = mppsUID;
    }

    public final String getMPPSInstanceUID() {
        return this.mppsUID;
    }

    public void writeTo(StringBuffer sb) {
        sb.append("<ObjectAction>").append(this.action).append("</ObjectAction>");
        if (this.accessionNumber != null) {
            sb.append("<AccessionNumber><![CDATA[").append(this.accessionNumber).append("]]></AccessionNumber>");
        }
        Iterator it = this.suids.iterator();
        while (it.hasNext()) {
            sb.append("<SUID>").append(it.next()).append("</SUID>");
        }
        this.patient.writeTo(sb);
        if (this.user != null) {
            this.user.writeTo(sb);
        }
        it = this.cuids.iterator();
        while (it.hasNext()) {
            sb.append("<CUID>").append(it.next()).append("</CUID>");
        }
        if (this.numberOfInstances > 0) {
            sb.append("<NumberOfInstances>").append(this.numberOfInstances).append("</NumberOfInstances>");
        }
        if (this.mppsUID != null) {
            sb.append("<MPPSUID>").append(this.mppsUID).append("</MPPSUID>");
        }
    }
}

