/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageOutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dcm4che.data.ConfigurationError;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DatasetSerializer;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4che.data.SpecificCharacterSet;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.VRs;
import org.dcm4che.image.ColorModelFactory;
import org.dcm4cheri.data.DcmElementImpl;
import org.dcm4cheri.data.DcmHandlerAdapter;
import org.dcm4cheri.data.DcmHandlerAdapter2;
import org.dcm4cheri.data.DcmObjectImpl;
import org.dcm4cheri.data.DcmStreamHandlerImpl;
import org.dcm4cheri.data.FilterDataset;
import org.dcm4cheri.data.FragmentElement;
import org.dcm4cheri.data.OutputStreamAdapter;
import org.dcm4cheri.data.SQElement;
import org.dcm4cheri.data.ValueElement;
import org.xml.sax.ContentHandler;

abstract class BaseDatasetImpl
extends DcmObjectImpl
implements Dataset {
    private FileMetaInfo fmi = null;
    private int[] grTags = new int[8];
    private int[] grLens = new int[8];
    private int grCount = 0;
    protected int totLen = 0;
    private static SAXTransformerFactory tfFactory;
    private static Templates templates;
    private static TagDictionary tagDictionary;
    private static final ColorSpace sRGB;
    private static final ImageTypeSpecifier RGB_PLANE;
    private static final ImageTypeSpecifier RGB_PIXEL;

    BaseDatasetImpl() {
    }

    private static SAXTransformerFactory getTransformerFactory() {
        if (tfFactory == null) {
            tfFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
        return tfFactory;
    }

    private static Templates getTemplates() {
        if (templates == null) {
            InputStream in = BaseDatasetImpl.class.getResourceAsStream("dump2.xsl");
            try {
                templates = BaseDatasetImpl.getTransformerFactory().newTemplates(new StreamSource(in));
            }
            catch (Exception e) {
                throw new ConfigurationError("Failed to load/compile dump2.xsl", e);
            }
        }
        return templates;
    }

    private static TagDictionary getTagDictionary() {
        if (tagDictionary == null) {
            DictionaryFactory df = DictionaryFactory.getInstance();
            tagDictionary = df.getDefaultTagDictionary();
        }
        return tagDictionary;
    }

    public final Dataset setFileMetaInfo(FileMetaInfo fmi) {
        this.fmi = fmi;
        return this;
    }

    public FileMetaInfo getFileMetaInfo() {
        return this.fmi;
    }

    public String toString() {
        return "Dataset[size=" + this.size() + "]";
    }

    private int[] ensureCapacity(int[] old, int n) {
        if (n <= old.length) {
            return old;
        }
        int[] retval = new int[old.length << 1];
        System.arraycopy(old, 0, retval, 0, old.length);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int calcLength(DcmEncodeParam param) {
        this.totLen = 0;
        this.grCount = 0;
        int prevGrTag = -1;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                DcmElement el = (DcmElement)iter.next();
                int curGrTag = el.tag() & 0xFFFF0000;
                if (curGrTag != prevGrTag) {
                    ++this.grCount;
                    this.grTags = this.ensureCapacity(this.grTags, this.grCount + 1);
                    this.grLens = this.ensureCapacity(this.grLens, this.grCount + 1);
                    this.grTags[this.grCount - 1] = prevGrTag = curGrTag;
                    this.grLens[this.grCount - 1] = 0;
                }
                int n = this.grCount - 1;
                this.grLens[n] = this.grLens[n] + (param.explicitVR && !VRs.isLengthField16Bit(el.vr()) ? 12 : 8);
                if (el instanceof ValueElement) {
                    int n2 = this.grCount - 1;
                    this.grLens[n2] = this.grLens[n2] + el.length();
                    continue;
                }
                if (el instanceof FragmentElement) {
                    int n3 = this.grCount - 1;
                    this.grLens[n3] = this.grLens[n3] + ((FragmentElement)el).calcLength();
                    continue;
                }
                int n4 = this.grCount - 1;
                this.grLens[n4] = this.grLens[n4] + ((SQElement)el).calcLength(param);
            }
        }
        this.grTags[this.grCount] = -1;
        if (!param.skipGroupLen) {
            this.totLen += this.grCount * 12;
        }
        for (int i = 0; i < this.grCount; ++i) {
            this.totLen += this.grLens[i];
        }
        return this.totLen;
    }

    public int length() {
        return this.totLen;
    }

    public void clear() {
        super.clear();
        this.totLen = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDataset(DcmHandler handler, DcmEncodeParam param) throws IOException {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (!(param.skipGroupLen && param.undefItemLen && param.undefSeqLen)) {
                this.calcLength(param);
            }
            handler.startDataset();
            handler.setDcmDecodeParam(param);
            this.doWrite(handler, param);
            handler.endDataset();
        }
    }

    private void doWrite(DcmHandler handler, DcmEncodeParam param) throws IOException {
        int grIndex = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            DcmElement el = (DcmElement)iter.next();
            if (!param.skipGroupLen && this.grTags[grIndex] == (el.tag() & 0xFFFF0000)) {
                byte[] b4 = new byte[4];
                ByteBuffer.wrap(b4).order(param.byteOrder).putInt(this.grLens[grIndex]);
                handler.startElement(this.grTags[grIndex], 21836, el.getStreamPosition());
                handler.value(b4, 0, 4);
                handler.endElement();
                ++grIndex;
            }
            if (el instanceof SQElement) {
                int len = param.undefSeqLen ? -1 : el.length();
                handler.startElement(el.tag(), 21329, el.getStreamPosition());
                handler.startSequence(len);
                int j = 0;
                int m = el.countItems();
                while (j < m) {
                    BaseDatasetImpl ds = (BaseDatasetImpl)el.getItem(j);
                    int itemlen = param.undefItemLen ? -1 : ds.length();
                    handler.startItem(++j, ds.getItemOffset(), itemlen);
                    ds.doWrite(handler, param);
                    handler.endItem(itemlen);
                }
                handler.endSequence(len);
                handler.endElement();
                continue;
            }
            if (el instanceof FragmentElement) {
                long offset = el.getStreamPosition();
                handler.startElement(el.tag(), el.vr(), offset);
                handler.startSequence(-1);
                if (offset != -1L) {
                    offset += 12L;
                }
                int j = 0;
                int m = el.countItems();
                while (j < m) {
                    ByteBuffer bb = el.getDataFragment(j, param.byteOrder);
                    handler.fragment(++j, offset, bb.array(), bb.arrayOffset(), bb.limit());
                    if (offset == -1L) continue;
                    offset += (long)(bb.limit() + 9 & 0xFFFFFFFE);
                }
                handler.endSequence(-1);
                handler.endElement();
                continue;
            }
            int len = el.length();
            handler.startElement(el.tag(), el.vr(), el.getStreamPosition());
            ByteBuffer bb = el.getByteBuffer(param.byteOrder);
            handler.value(bb.array(), bb.arrayOffset(), bb.limit());
            handler.endElement();
        }
    }

    public void writeDataset(OutputStream out, DcmEncodeParam param) throws IOException {
        OutputStream outputStream;
        if (param == null) {
            param = DcmDecodeParam.IVR_LE;
        }
        DeflaterOutputStream deflater = null;
        if (param.deflated) {
            deflater = new DeflaterOutputStream(out);
            outputStream = deflater;
        } else {
            outputStream = out;
        }
        this.writeDataset(new DcmStreamHandlerImpl(outputStream), param);
        if (deflater != null) {
            deflater.finish();
        }
    }

    public void writeFile(OutputStream out, DcmEncodeParam param) throws IOException {
        FileMetaInfo fmi = this.getFileMetaInfo();
        if (fmi != null) {
            param = this.checkCompatibility(fmi, param);
            fmi.write(out);
        }
        this.writeDataset(out, param);
    }

    public void writeDataset(ImageOutputStream out, DcmEncodeParam param) throws IOException {
        DcmStreamHandlerImpl dcmStreamHandlerImpl;
        if (param == null) {
            param = DcmDecodeParam.IVR_LE;
        }
        DeflaterOutputStream deflater = null;
        if (param.deflated) {
            deflater = new DeflaterOutputStream(new OutputStreamAdapter(out));
            DcmStreamHandlerImpl dcmStreamHandlerImpl2 = new DcmStreamHandlerImpl(deflater);
            dcmStreamHandlerImpl = dcmStreamHandlerImpl2;
        } else {
            dcmStreamHandlerImpl = new DcmStreamHandlerImpl(out);
        }
        this.writeDataset(dcmStreamHandlerImpl, param);
        if (deflater != null) {
            deflater.finish();
        }
    }

    private DcmEncodeParam checkCompatibility(FileMetaInfo fmi, DcmEncodeParam param) {
        DcmEncodeParam fmiParam = DcmDecodeParam.valueOf(fmi.getTransferSyntaxUID());
        if (param == null) {
            return fmiParam;
        }
        if (param.byteOrder == fmiParam.byteOrder && param.explicitVR == fmiParam.explicitVR && param.encapsulated == fmiParam.encapsulated && param.deflated == fmiParam.deflated) {
            return param;
        }
        throw new IllegalArgumentException("param: " + param + " does not match with " + fmi);
    }

    public void writeFile(ImageOutputStream out, DcmEncodeParam param) throws IOException {
        FileMetaInfo fmi = this.getFileMetaInfo();
        if (fmi != null) {
            param = this.checkCompatibility(fmi, param);
            fmi.write(out);
        }
        this.writeDataset(out, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(File f, DcmEncodeParam param) throws IOException {
        BufferedOutputStream in = new BufferedOutputStream(new FileOutputStream(f));
        try {
            this.writeFile(in, param);
        }
        finally {
            try {
                ((OutputStream)in).close();
            }
            catch (IOException ignore) {}
        }
    }

    public void writeDataset(ContentHandler ch, TagDictionary dict) throws IOException {
        this.writeDataset(new DcmHandlerAdapter(ch, dict), DcmDecodeParam.EVR_LE);
    }

    public void writeDataset2(ContentHandler ch, TagDictionary dict, int[] excludeTags, int excludeValueLengthLimit, File basedir) throws IOException {
        this.writeDataset(new DcmHandlerAdapter2(ch, dict, excludeTags, excludeValueLengthLimit, basedir), DcmDecodeParam.EVR_LE);
    }

    public void dumpDataset(OutputStream out, Map param) throws IOException {
        this.dumpDataset(new StreamResult(out), param, 128);
    }

    public void dumpDataset(OutputStream out, Map param, int excludeValueLengthLimit) throws IOException {
        this.dumpDataset(new StreamResult(out), param, excludeValueLengthLimit);
    }

    public void dumpDataset(Writer w, Map param) throws IOException {
        this.dumpDataset(new StreamResult(w), param, 128);
    }

    public void dumpDataset(Writer w, Map param, int excludeValueLengthLimit) throws IOException {
        this.dumpDataset(new StreamResult(w), param, excludeValueLengthLimit);
    }

    private void dumpDataset(Result result, Map param, int excludeValueLengthLimit) throws IOException {
        TransformerHandler th;
        try {
            th = BaseDatasetImpl.getTransformerFactory().newTransformerHandler(BaseDatasetImpl.getTemplates());
            if (param != null) {
                Transformer t = th.getTransformer();
                Iterator it = param.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    t.setParameter((String)e.getKey(), e.getValue());
                }
            }
        }
        catch (Exception e) {
            throw new ConfigurationError("Failed to initialize XSLT", e);
        }
        th.setResult(result);
        this.writeDataset2(th, BaseDatasetImpl.getTagDictionary(), null, excludeValueLengthLimit, null);
    }

    public void writeFile(ContentHandler ch, TagDictionary dict) throws IOException {
        DcmHandlerAdapter xml = new DcmHandlerAdapter(ch, dict);
        xml.startDcmFile();
        FileMetaInfo fmi = this.getFileMetaInfo();
        if (fmi != null) {
            fmi.write(xml);
        }
        this.writeDataset(xml, DcmDecodeParam.EVR_LE);
        xml.endDcmFile();
    }

    public void writeFile2(ContentHandler ch, TagDictionary dict, int[] excludeTags, int excludeValueLengthLimit, File basedir) throws IOException {
        DcmHandlerAdapter2 xml = new DcmHandlerAdapter2(ch, dict, excludeTags, excludeValueLengthLimit, basedir);
        xml.startDcmFile();
        FileMetaInfo fmi = this.getFileMetaInfo();
        if (fmi != null) {
            fmi.write(xml);
        }
        this.writeDataset(xml, DcmDecodeParam.EVR_LE);
        xml.endDcmFile();
    }

    public Dataset subSet(int fromTag, int toTag) {
        return new FilterDataset.Segment(this, fromTag, toTag);
    }

    public Dataset subSet(Dataset filter) {
        return new FilterDataset.Selection(this, filter);
    }

    public Dataset subSet(int[] tags, int[] vrs, boolean exclude, boolean excludePrivate) {
        return new FilterDataset.TagFilter(this, tags, vrs, exclude, excludePrivate);
    }

    public Dataset subSet(int[] tags, int[] vrs) {
        return new FilterDataset.TagFilter(this, tags, vrs, false, false);
    }

    public Dataset exclude(int[] tags, int[] vrs) {
        return new FilterDataset.TagFilter(this, tags, vrs, true, false);
    }

    public Dataset subSet(int[] tags, boolean exclude, boolean excludePrivate) {
        return new FilterDataset.TagFilter(this, tags, null, exclude, excludePrivate);
    }

    public Dataset subSet(int[] tags) {
        return new FilterDataset.TagFilter(this, tags, null, false, false);
    }

    public Dataset exclude(int[] tags) {
        return new FilterDataset.TagFilter(this, tags, null, true, false);
    }

    public Dataset excludePrivate() {
        return new FilterDataset.ExcludePrivate(this);
    }

    public boolean match(Dataset keys, boolean ignorePNCase, boolean ignoreEmpty) {
        if (keys == null) {
            return true;
        }
        SpecificCharacterSet keyCS = keys.getSpecificCharacterSet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            if (this.match((DcmElementImpl)iter.next(), ignorePNCase, ignoreEmpty, keyCS)) continue;
            return false;
        }
        return true;
    }

    private boolean match(DcmElementImpl key, boolean ignorePNCase, boolean ignoreEmpty, SpecificCharacterSet keyCS) {
        int tag = key.tag();
        if (tag == 524293) {
            return true;
        }
        DcmElementImpl e = (DcmElementImpl)this.get(tag);
        if (e == null) {
            return ignoreEmpty || key.isEmpty();
        }
        return e.match(key, ignorePNCase, ignoreEmpty, keyCS, this.getSpecificCharacterSet());
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new DatasetSerializer(this);
    }

    public BufferedImage toBufferedImage() {
        return this.toBufferedImage(1);
    }

    public BufferedImage toBufferedImage(int frame) {
        BufferedImage bi;
        int dataBufType;
        boolean signed;
        ByteBuffer pixelData;
        int planarConf;
        int spp;
        int highBit;
        int bitsStored;
        int bitsAllocd;
        int height;
        int width;
        block26: {
            String pmi;
            block25: {
                width = this.getInt(2621457, -1);
                height = this.getInt(2621456, -1);
                if (width == -1 || height == -1) {
                    throw new IllegalStateException("Illegal width/height: width = " + width + ", height = " + height);
                }
                bitsAllocd = this.getInt(2621696, -1);
                bitsStored = this.getInt(2621697, -1);
                highBit = this.getInt(2621698, -1);
                int pixelRep = this.getInt(2621699, -1);
                pmi = this.getString(2621444, null);
                spp = this.getInt(0x280002, -1);
                planarConf = this.getInt(2621446, -1);
                pixelData = this.getByteBuffer(2145386512);
                if (bitsAllocd == -1 || bitsStored == -1 || highBit == -1 || pixelRep == -1 || pmi == null || spp == -1 || planarConf == -1 && spp > 1 || pixelData == null) {
                    throw new IllegalStateException("Missing required Image Pixel Module attributes");
                }
                if (!(pmi.equals("RGB") && spp == 3 || pmi.equals("PALETTE COLOR") && spp == 1 || pmi.equals("MONOCHROME1") && spp == 1 || pmi.equals("MONOCHROME2") && spp == 1)) {
                    throw new IllegalStateException("Invalid Photometric Interpretation (" + pmi + ") and Samples per Pixel (" + spp + ") configuration");
                }
                boolean bl = signed = pixelRep == 1;
                if (planarConf == -1) {
                    planarConf = 1;
                }
                if (bitsAllocd == 8) {
                    dataBufType = 0;
                } else if (bitsAllocd == 16) {
                    dataBufType = 1;
                } else {
                    throw new IllegalStateException("Bits Allocated must be 8 or 16, " + bitsAllocd + " is not supported");
                }
                if (highBit != bitsStored - 1) {
                    throw new IllegalStateException("High bit must be Bits Stored - 1 " + highBit + " is not supported");
                }
                bi = null;
                if (!pmi.equals("RGB")) break block25;
                switch (planarConf) {
                    case 0: {
                        bi = RGB_PIXEL.createBufferedImage(width, height);
                        break block26;
                    }
                    case 1: {
                        bi = RGB_PLANE.createBufferedImage(width, height);
                        break block26;
                    }
                    default: {
                        throw new IllegalStateException("Invalid Planar Configuration for RGB");
                    }
                }
            }
            if (pmi.equals("MONOCHROME1") || pmi.equals("MONOCHROME2") || pmi.equals("PALETTE COLOR")) {
                ColorModelFactory cmFactory = ColorModelFactory.getInstance();
                bi = new ImageTypeSpecifier(cmFactory.getColorModel(cmFactory.makeParam(this)), new PixelInterleavedSampleModel(dataBufType, 1, 1, 1, 1, new int[]{0})).createBufferedImage(width, height);
            }
        }
        DataBuffer dataBuf = bi.getRaster().getDataBuffer();
        Object[] dest = null;
        if (planarConf == 0) {
            switch (dataBufType) {
                case 0: {
                    dest = ((DataBufferByte)dataBuf).getData();
                    break;
                }
                case 1: {
                    dest = ((DataBufferUShort)dataBuf).getData();
                }
            }
            this.readPixelData(pixelData, dest, dataBufType, frame, bitsAllocd, bitsStored, highBit, signed, spp, width, height);
        } else {
            for (int i = 0; i < spp; ++i) {
                switch (dataBufType) {
                    case 0: {
                        dest = ((DataBufferByte)dataBuf).getData(i);
                        break;
                    }
                    case 1: {
                        dest = ((DataBufferUShort)dataBuf).getData(i);
                    }
                }
                this.readPixelData(pixelData, dest, dataBufType, frame, bitsAllocd, bitsStored, highBit, signed, 1, width, height);
            }
        }
        return bi;
    }

    private void readPixelData(ByteBuffer pixelData, Object dest, int destDataType, int frame, int ba, int bs, int hb, boolean signed, int spp, int width, int height) {
        int size = width * height * spp;
        int frameSize = size * (ba / 8);
        int i = 0;
        if (frame * frameSize > pixelData.limit()) {
            throw new IllegalArgumentException("Bad frame number: " + frame);
        }
        pixelData.position(frameSize * --frame);
        switch (destDataType) {
            case 0: {
                byte[] bufByte = (byte[])dest;
                while (i < size) {
                    bufByte[i++] = pixelData.get();
                }
                break;
            }
            case 1: {
                short[] bufUShort = (short[])dest;
                while (i < size) {
                    bufUShort[i++] = pixelData.getShort();
                }
                break;
            }
        }
    }

    public void putBufferedImage(BufferedImage bi) {
        this.putBufferedImage(bi, null, true);
    }

    public void putBufferedImage(BufferedImage bi, Rectangle sourceRegion) {
        this.putBufferedImage(bi, sourceRegion, true);
    }

    public void putBufferedImage(BufferedImage bi, Rectangle sourceRegion, boolean writeIndexedAsPaletteColor) {
        boolean writeAsMono;
        int dataType = bi.getType();
        boolean bl = writeAsMono = dataType == 10 || dataType == 11;
        if (writeAsMono) {
            this.putBufferedImageAsMonochrome(bi, sourceRegion, true);
        } else {
            boolean writeAsRGB;
            boolean bl2 = writeAsRGB = !writeIndexedAsPaletteColor || !(bi.getColorModel() instanceof IndexColorModel);
            if (writeAsRGB) {
                this.putBufferedImageAsRgb(bi, sourceRegion);
            } else {
                this.putBufferedImageAsPaletteColor(bi, sourceRegion);
            }
        }
    }

    public void putBufferedImageAsRgb(BufferedImage bi, Rectangle sourceRegion) {
        Rectangle rect = new Rectangle(bi.getWidth(), bi.getHeight());
        Rectangle sourceRect = sourceRegion == null ? rect : rect.intersection(sourceRegion);
        if (sourceRect.isEmpty()) {
            throw new IllegalArgumentException("Source region is empty." + this);
        }
        int width = sourceRect.width;
        int height = sourceRect.height;
        boolean signed = false;
        int bitsAllocd = 8;
        int bitsStored = 8;
        int highBit = 7;
        this.putUS(0x280002, 3);
        this.putUS(2621696, bitsAllocd);
        this.putUS(2621697, bitsStored);
        this.putUS(2621698, highBit);
        this.putCS(2621444, "RGB");
        this.putUS(2621456, height);
        this.putUS(2621457, width);
        this.putUS(2621699, signed ? 1 : 0);
        this.putUS(2621446, 0);
        this.putIS(2621492, new int[]{1, 1});
        byte[] rgbOut = new byte[width * height * 3];
        int dataType = bi.getData().getDataBuffer().getDataType();
        ColorModel cm = bi.getColorModel();
        int[] pixels = bi.getRGB(sourceRect.x, sourceRect.y, width, height, null, 0, width);
        int ind = 0;
        for (int i = 0; i < pixels.length; ++i) {
            rgbOut[ind++] = (byte)(pixels[i] >> 16 & 0xFF);
            rgbOut[ind++] = (byte)(pixels[i] >> 8 & 0xFF);
            rgbOut[ind++] = (byte)(pixels[i] & 0xFF);
        }
        this.putOB(2145386512, ByteBuffer.wrap(rgbOut));
    }

    public void putBufferedImageAsMonochrome(BufferedImage bi, Rectangle sourceRegion, boolean writeAsMonochrome2) {
        int max;
        int bitsAllocated;
        Rectangle rect = new Rectangle(bi.getWidth(), bi.getHeight());
        Rectangle sourceRect = sourceRegion == null ? rect : rect.intersection(sourceRegion);
        if (sourceRect.isEmpty()) {
            throw new IllegalArgumentException("Source region is empty." + this);
        }
        int dataType = bi.getType();
        int width = sourceRect.width;
        int height = sourceRect.height;
        boolean signed = false;
        int bitsStored = bitsAllocated = dataType == 10 ? 8 : 16;
        int highBit = bitsStored - 1;
        this.putUS(0x280002, 1);
        if (writeAsMonochrome2) {
            this.putCS(2621444, "MONOCHROME2");
        } else {
            this.putCS(2621444, "MONOCHROME1");
        }
        this.putUS(2621456, height);
        this.putUS(2621457, width);
        this.putUS(2621696, bitsAllocated);
        this.putUS(2621697, bitsStored);
        this.putUS(2621698, highBit);
        this.putUS(2621699, signed ? 1 : 0);
        this.putIS(2621492, new int[]{1, 1});
        int[] pixels = bi.getRaster().getPixels(sourceRect.x, sourceRect.y, width, height, (int[])null);
        int min = max = pixels[0];
        for (int i = 1; i < pixels.length; ++i) {
            int value = pixels[i];
            if (value > max) {
                max = value;
                continue;
            }
            if (value >= min) continue;
            min = value;
        }
        if (bitsAllocated <= 8) {
            byte[] out = new byte[pixels.length];
            for (int pixelsIdx = 0; pixelsIdx < pixels.length; ++pixelsIdx) {
                out[pixelsIdx] = (byte)(pixels[pixelsIdx % 2 == 0 ? pixelsIdx + 1 : pixelsIdx - 1] & 0xFF);
            }
            ByteBuffer byteBuf = ByteBuffer.wrap(out);
            this.putOW(2145386512, byteBuf);
        } else {
            byte[] out = new byte[pixels.length * 2];
            int outIdx = 0;
            for (int pixelsIdx = 0; pixelsIdx < pixels.length; ++pixelsIdx) {
                out[outIdx++] = (byte)(pixels[pixelsIdx] >> 8 & 0xFF);
                out[outIdx++] = (byte)(pixels[pixelsIdx] & 0xFF);
            }
            ByteBuffer byteBuf = ByteBuffer.wrap(out);
            this.putOW(2145386512, byteBuf);
        }
        this.putSS(2621702, min);
        this.putSS(2621703, max);
        float rs = this.getFloat(2625619, 1.0f);
        float ri = this.getFloat(2625618, 0.0f);
        if (!this.contains(2625618)) {
            this.putDS(2625618, ri);
            this.putDS(2625619, rs);
            this.putLO(2625620, "PIXELVALUE");
        }
        if (!this.contains(2625616)) {
            String[] wc = new String[]{Float.toString(rs * (float)(max + min) / 2.0f + ri)};
            this.putDS(2625616, wc);
            String[] ww = new String[]{Float.toString(rs * (float)(max - min) / 2.0f)};
            this.putDS(2625617, ww);
        }
    }

    public void putBufferedImageAsPaletteColor(BufferedImage bi, Rectangle sourceRegion) {
        int bitsAllocd;
        Rectangle rect = new Rectangle(bi.getWidth(), bi.getHeight());
        Rectangle sourceRect = sourceRegion == null ? rect : rect.intersection(sourceRegion);
        if (sourceRect.isEmpty()) {
            throw new IllegalArgumentException("Source region is empty." + this);
        }
        int dataType = bi.getData().getDataBuffer().getDataType();
        ColorModel cm = bi.getColorModel();
        if (!(cm instanceof IndexColorModel)) {
            throw new IllegalArgumentException("BufferedImage's ColorModel must be an IndexColorModel to represent as a \"PALETTE COLOR\" DICOM image");
        }
        IndexColorModel icm = (IndexColorModel)cm;
        int maxPaletteSize = 65536;
        int paletteSize = icm.getMapSize();
        int paletteIndexSize = icm.getPixelSize();
        if (paletteSize > 65536) {
            throw new IllegalArgumentException("BufferedImage contains a palette that is too large to be encoded as a DICOM Color LUT (" + paletteSize + ")");
        }
        if (paletteIndexSize == 0 || paletteIndexSize > 16) {
            throw new UnsupportedOperationException("BufferedImages with a pixel size of " + paletteIndexSize + " bits are not supported, only 1 to 16 bits are supported");
        }
        int width = sourceRect.width;
        int height = sourceRect.height;
        boolean signed = false;
        int bitsStored = bitsAllocd = paletteIndexSize <= 8 ? 8 : 16;
        int highBit = bitsStored - 1;
        this.putUS(0x280002, 1);
        this.putCS(2621444, "PALETTE COLOR");
        this.putUS(2621456, height);
        this.putUS(2621457, width);
        this.putUS(2621696, bitsAllocd);
        this.putUS(2621697, bitsStored);
        this.putUS(2621698, highBit);
        this.putUS(2621699, signed ? 1 : 0);
        this.putIS(2621492, new int[]{1, 1});
        ByteBuffer pDescriptor = ByteBuffer.allocate(6);
        pDescriptor.putShort((short)(paletteSize == 65536 ? 0 : paletteSize));
        pDescriptor.putShort((short)0);
        pDescriptor.putShort((short)8);
        this.putXX(2625793, 21843, pDescriptor);
        this.putXX(2625794, 21843, pDescriptor);
        this.putXX(2625795, 21843, pDescriptor);
        byte[] rPalette = new byte[paletteSize];
        byte[] gPalette = new byte[paletteSize];
        byte[] bPalette = new byte[paletteSize];
        icm.getReds(rPalette);
        icm.getGreens(gPalette);
        icm.getBlues(bPalette);
        ByteBuffer rByteBuffer = ByteBuffer.allocate(paletteSize);
        ByteBuffer gByteBuffer = ByteBuffer.allocate(paletteSize);
        ByteBuffer bByteBuffer = ByteBuffer.allocate(paletteSize);
        for (int idx = 0; idx < paletteSize; idx += 2) {
            rByteBuffer.putShort((short)((rPalette[idx + 1] << 8) + rPalette[idx]));
            gByteBuffer.putShort((short)((gPalette[idx + 1] << 8) + gPalette[idx]));
            bByteBuffer.putShort((short)((bPalette[idx + 1] << 8) + bPalette[idx]));
        }
        this.putOW(2626049, rByteBuffer);
        this.putOW(2626050, gByteBuffer);
        this.putOW(2626051, bByteBuffer);
        int[] pixels = bi.getRaster().getPixels(sourceRect.x, sourceRect.y, width, height, (int[])null);
        int ind = 0;
        if (paletteIndexSize <= 8) {
            byte[] indOut = new byte[width * height];
            for (int i = 0; i < pixels.length; ++i) {
                indOut[i] = (byte)(pixels[i % 2 == 0 ? i + 1 : i - 1] & 0xFF);
            }
            this.putOW(2145386512, ByteBuffer.wrap(indOut));
        } else if (paletteIndexSize > 8 && paletteIndexSize <= 16) {
            byte[] indOut = new byte[width * height * 2];
            for (int i = 0; i < pixels.length; ++i) {
                indOut[ind++] = (byte)(pixels[i] >> 8 & 0xFF);
                indOut[ind++] = (byte)(pixels[i] & 0xFF);
            }
            this.putOW(2145386512, ByteBuffer.wrap(indOut));
        }
    }

    static {
        sRGB = ColorSpace.getInstance(1000);
        RGB_PLANE = ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2}, new int[]{0, 0, 0}, 0, false, false);
        RGB_PIXEL = ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2}, 0, false, false);
    }
}

