/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dcm4che.data.Command;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.data.DcmValueException;
import org.dcm4cheri.data.DcmObjectImpl;
import org.dcm4cheri.data.DcmParserImpl;
import org.dcm4cheri.data.DcmStreamHandlerImpl;

final class CommandImpl
extends DcmObjectImpl
implements Command {
    private int cmdField = -1;
    private int dataSetType = -1;
    private int status = -1;
    private int msgID = -1;
    private String sopClassUID = null;
    private String sopInstUID = null;

    CommandImpl() {
    }

    public int getCommandField() {
        return this.cmdField;
    }

    public int getMessageID() {
        return this.msgID;
    }

    public int getMessageIDToBeingRespondedTo() {
        return this.msgID;
    }

    public String getAffectedSOPClassUID() {
        return this.sopClassUID;
    }

    public String getRequestedSOPClassUID() {
        return this.sopClassUID;
    }

    public String getAffectedSOPInstanceUID() {
        return this.sopInstUID;
    }

    public String getRequestedSOPInstanceUID() {
        return this.sopInstUID;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isPending() {
        switch (this.status) {
            case 65280: 
            case 65281: {
                return true;
            }
        }
        return false;
    }

    public boolean isRequest() {
        switch (this.cmdField) {
            case 1: 
            case 16: 
            case 32: 
            case 33: 
            case 48: 
            case 256: 
            case 272: 
            case 288: 
            case 304: 
            case 320: 
            case 336: 
            case 4095: {
                return true;
            }
        }
        return false;
    }

    public boolean isResponse() {
        switch (this.cmdField) {
            case 32769: 
            case 32784: 
            case 32800: 
            case 32801: 
            case 32816: 
            case 33024: 
            case 33040: 
            case 33056: 
            case 33072: 
            case 33088: 
            case 33104: {
                return true;
            }
        }
        return false;
    }

    public boolean hasDataset() {
        if (this.dataSetType == -1) {
            throw new IllegalStateException();
        }
        return this.dataSetType != 257;
    }

    private Command initCxxxxRQ(int cmd, int msgID, String sopClassUID, int priority) {
        if (priority != 0 && priority != 1 && priority != 2) {
            throw new IllegalArgumentException("priority=" + priority);
        }
        if (sopClassUID.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.putUI(2, sopClassUID);
        this.putUS(256, cmd);
        this.putUS(272, msgID);
        this.putUS(1792, priority);
        return this;
    }

    private Command initCxxxxRSP(int cmd, int msgID, String sopClassUID, int status) {
        if (sopClassUID != null) {
            this.putUI(2, sopClassUID);
        }
        this.putUS(256, cmd);
        this.putUS(288, msgID);
        this.putUS(2304, status);
        return this;
    }

    public Command initCStoreRQ(int msgID, String sopClassUID, String sopInstUID, int priority) {
        if (sopInstUID.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.initCxxxxRQ(1, msgID, sopClassUID, priority);
        this.putUI(4096, sopInstUID);
        return this;
    }

    public Command setMoveOriginator(String aet, int msgID) {
        if (aet.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.putAE(4144, aet);
        this.putUS(4145, msgID);
        return this;
    }

    public Command initCStoreRSP(int msgID, String sopClassUID, String sopInstUID, int status) {
        return this.initNxxxxRSP(32769, msgID, sopClassUID, sopInstUID, status);
    }

    public Command initCFindRQ(int msgID, String sopClassUID, int priority) {
        return this.initCxxxxRQ(32, msgID, sopClassUID, priority);
    }

    public Command initCFindRSP(int msgID, String sopClassUID, int status) {
        return this.initCxxxxRSP(32800, msgID, sopClassUID, status);
    }

    public Command initCCancelRQ(int msgID) {
        this.putUS(256, 4095);
        this.putUS(288, msgID);
        return this;
    }

    public Command initCGetRQ(int msgID, String sopClassUID, int priority) {
        return this.initCxxxxRQ(16, msgID, sopClassUID, priority);
    }

    public Command initCGetRSP(int msgID, String sopClassUID, int status) {
        return this.initCxxxxRSP(32784, msgID, sopClassUID, status);
    }

    public Command initCMoveRQ(int msgID, String sopClassUID, int priority, String moveDest) {
        if (moveDest.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.initCxxxxRQ(33, msgID, sopClassUID, priority);
        this.putAE(1536, moveDest);
        return this;
    }

    public Command initCMoveRSP(int msgID, String sopClassUID, int status) {
        return this.initCxxxxRSP(32801, msgID, sopClassUID, status);
    }

    public Command initCEchoRQ(int msgID, String sopClassUID) {
        if (sopClassUID.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.putUI(2, sopClassUID);
        this.putUS(256, 48);
        this.putUS(272, msgID);
        return this;
    }

    public Command initCEchoRQ(int msgID) {
        return this.initCEchoRQ(msgID, "1.2.840.10008.1.1");
    }

    public Command initCEchoRSP(int msgID, String sopClassUID, int status) {
        return this.initCxxxxRSP(32816, msgID, sopClassUID, status);
    }

    public Command initCEchoRSP(int msgID) {
        return this.initCxxxxRSP(32816, msgID, "1.2.840.10008.1.1", 0);
    }

    private Command initNxxxxRQ(int cmd, int msgID, String sopClassUID, String sopInstanceUID) {
        if (sopClassUID.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (sopInstanceUID.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.putUI(3, sopClassUID);
        this.putUS(256, cmd);
        this.putUS(272, msgID);
        this.putUI(4097, sopInstanceUID);
        return this;
    }

    private Command initNxxxxRSP(int cmd, int msgID, String sopClassUID, String sopInstanceUID, int status) {
        if (sopClassUID != null) {
            this.putUI(2, sopClassUID);
        }
        this.putUS(256, cmd);
        this.putUS(288, msgID);
        this.putUS(2304, status);
        if (sopInstanceUID != null) {
            this.putUI(4096, sopInstanceUID);
        }
        return this;
    }

    public Command initNEventReportRQ(int msgID, String sopClassUID, String sopInstanceUID, int eventTypeID) {
        if (sopClassUID.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (sopInstanceUID.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.putUI(2, sopClassUID);
        this.putUS(256, 256);
        this.putUS(272, msgID);
        this.putUI(4096, sopInstanceUID);
        this.putUS(4098, eventTypeID);
        return this;
    }

    public Command initNEventReportRSP(int msgID, String sopClassUID, String sopInstUID, int status) {
        return this.initNxxxxRSP(33024, msgID, sopClassUID, sopInstUID, status);
    }

    public Command initNGetRQ(int msgID, String sopClassUID, String sopInstUID, int[] attrIDs) {
        this.initNxxxxRQ(272, msgID, sopClassUID, sopInstUID);
        if (attrIDs != null) {
            this.putAT(4101, attrIDs);
        }
        return this;
    }

    public Command initNGetRSP(int msgID, String sopClassUID, String sopInstUID, int status) {
        return this.initNxxxxRSP(33040, msgID, sopClassUID, sopInstUID, status);
    }

    public Command initNSetRQ(int msgID, String sopClassUID, String sopInstUID) {
        return this.initNxxxxRQ(288, msgID, sopClassUID, sopInstUID);
    }

    public Command initNSetRSP(int msgID, String sopClassUID, String sopInstUID, int status) {
        return this.initNxxxxRSP(33056, msgID, sopClassUID, sopInstUID, status);
    }

    public Command initNActionRQ(int msgID, String sopClassUID, String sopInstUID, int actionTypeID) {
        this.initNxxxxRQ(304, msgID, sopClassUID, sopInstUID);
        this.putUS(4104, actionTypeID);
        return this;
    }

    public Command initNActionRSP(int msgID, String sopClassUID, String sopInstUID, int status) {
        return this.initNxxxxRSP(33072, msgID, sopClassUID, sopInstUID, status);
    }

    public Command initNCreateRQ(int msgID, String sopClassUID, String sopInstanceUID) {
        if (sopClassUID.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.putUI(2, sopClassUID);
        this.putUS(256, 320);
        this.putUS(272, msgID);
        if (sopInstanceUID != null) {
            this.putUI(4096, sopInstanceUID);
        }
        return this;
    }

    public Command initNCreateRSP(int msgID, String sopClassUID, String sopInstUID, int status) {
        return this.initNxxxxRSP(33088, msgID, sopClassUID, sopInstUID, status);
    }

    public Command initNDeleteRQ(int msgID, String sopClassUID, String sopInstUID) {
        return this.initNxxxxRQ(336, msgID, sopClassUID, sopInstUID);
    }

    public Command initNDeleteRSP(int msgID, String sopClassUID, String sopInstUID, int status) {
        return this.initNxxxxRSP(33104, msgID, sopClassUID, sopInstUID, status);
    }

    protected DcmElement put(DcmElement newElem) {
        int tag = newElem.tag();
        if ((tag & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException(newElem.toString());
        }
        try {
            switch (tag) {
                case 2: 
                case 3: {
                    this.sopClassUID = newElem.getString(null);
                    break;
                }
                case 256: {
                    this.cmdField = newElem.getInt();
                    break;
                }
                case 272: 
                case 288: {
                    this.msgID = newElem.getInt();
                    break;
                }
                case 2048: {
                    this.dataSetType = newElem.getInt();
                    break;
                }
                case 2304: {
                    this.status = newElem.getInt();
                    break;
                }
                case 4096: 
                case 4097: {
                    this.sopInstUID = newElem.getString(null);
                }
            }
        }
        catch (DcmValueException ex) {
            throw new IllegalArgumentException(newElem.toString());
        }
        return super.put(newElem);
    }

    public int length() {
        return this.grLen() + 12;
    }

    private int grLen() {
        int len = 0;
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            len += ((DcmElement)this.list.get(i)).length() + 8;
        }
        return len;
    }

    public void write(DcmHandler handler) throws IOException {
        handler.setDcmDecodeParam(DcmDecodeParam.IVR_LE);
        this.write(0, this.grLen(), handler);
    }

    public void write(OutputStream out) throws IOException {
        this.write(new DcmStreamHandlerImpl(out));
    }

    public void read(InputStream in) throws IOException {
        DcmParserImpl parser = new DcmParserImpl(in);
        parser.setDcmHandler(this.getDcmHandler());
        parser.parseCommand();
    }

    public String toString() {
        return this.toStringBuffer(new StringBuffer()).toString();
    }

    private StringBuffer toStringBuffer(StringBuffer sb) {
        Integer i;
        String s;
        sb.append(this.msgID).append(':').append(this.cmdFieldAsString());
        if (this.dataSetType != 257) {
            sb.append(" with Dataset");
        }
        if (this.sopClassUID != null) {
            sb.append("\n\tclass:\t").append(DICT.lookup(this.sopClassUID));
        }
        if (this.sopInstUID != null) {
            sb.append("\n\tinst:\t").append(DICT.lookup(this.sopInstUID));
        }
        if (this.status != -1) {
            sb.append("\n\tstatus:\t").append(Integer.toHexString(this.status));
        }
        if ((s = this.getString(2306)) != null) {
            sb.append("\n\terror comment:\t").append(s);
        }
        if ((s = this.getString(1536)) != null) {
            sb.append("\n\tmove dest:\t").append(s);
        }
        if ((i = this.getInteger(4104)) != null) {
            sb.append("\n\taction type:\t").append(i);
        }
        if ((i = this.getInteger(4098)) != null) {
            sb.append("\n\tevent type:\t").append(i);
        }
        return sb;
    }

    public String cmdFieldAsString() {
        switch (this.cmdField) {
            case 1: {
                return "C_STORE_RQ";
            }
            case 16: {
                return "C_GET_RQ";
            }
            case 32: {
                return "C_FIND_RQ";
            }
            case 33: {
                return "C_MOVE_RQ";
            }
            case 48: {
                return "C_ECHO_RQ";
            }
            case 256: {
                return "N_EVENT_REPORT_RQ";
            }
            case 272: {
                return "N_GET_RQ";
            }
            case 288: {
                return "N_SET_RQ";
            }
            case 304: {
                return "N_ACTION_RQ";
            }
            case 320: {
                return "N_CREATE_RQ";
            }
            case 336: {
                return "N_DELETE_RQ";
            }
            case 4095: {
                return "C_CANCEL_RQ";
            }
            case 32769: {
                return "C_STORE_RSP";
            }
            case 32784: {
                return "C_GET_RSP";
            }
            case 32800: {
                return "C_FIND_RSP";
            }
            case 32801: {
                return "C_MOVE_RSP";
            }
            case 32816: {
                return "C_ECHO_RSP";
            }
            case 33024: {
                return "N_EVENT_REPORT_RSP";
            }
            case 33040: {
                return "N_GET_RSP";
            }
            case 33056: {
                return "N_SET_RSP";
            }
            case 33072: {
                return "N_ACTION_RSP";
            }
            case 33088: {
                return "N_CREATE_RSP";
            }
            case 33104: {
                return "N_DELETE_RSP";
            }
        }
        return "cmd:" + Integer.toHexString(this.cmdField);
    }
}

