/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.data.FileFormat;
import org.dcm4che.data.SpecificCharacterSet;
import org.dcm4cheri.data.BaseDatasetImpl;
import org.dcm4cheri.data.DcmParserImpl;
import org.dcm4cheri.data.SQElement;

final class DatasetImpl
extends BaseDatasetImpl
implements Dataset {
    private final Dataset parent;
    private SpecificCharacterSet charset = null;
    private String privateCreatorID = null;
    private long itemOffset = -1L;

    DatasetImpl() {
        this(null);
    }

    DatasetImpl(Dataset parent) {
        this.parent = parent;
    }

    public void setPrivateCreatorID(String privateCreatorID) {
        this.privateCreatorID = privateCreatorID;
    }

    public String getPrivateCreatorID() {
        return this.privateCreatorID != null ? this.privateCreatorID : (this.parent != null ? this.parent.getPrivateCreatorID() : null);
    }

    public SpecificCharacterSet getSpecificCharacterSet() {
        return this.charset != null ? this.charset : (this.parent != null ? this.parent.getSpecificCharacterSet() : null);
    }

    public final Dataset getParent() {
        return this.parent;
    }

    public final Dataset setItemOffset(long itemOffset) {
        this.itemOffset = itemOffset;
        return this;
    }

    public final long getItemOffset() {
        if (this.itemOffset != -1L || this.list.isEmpty()) {
            return this.itemOffset;
        }
        long elm1pos = ((DcmElement)this.list.get(0)).getStreamPosition();
        return elm1pos == -1L ? -1L : elm1pos - 8L;
    }

    public DcmElement putSQ(int tag) {
        return this.put(new SQElement(tag, this));
    }

    protected DcmElement put(DcmElement newElem) {
        if (newElem.tag() >>> 16 < 4) {
            log.warn("Ignore illegal attribute " + newElem);
            return newElem;
        }
        if (newElem.tag() == 524293) {
            try {
                this.charset = SpecificCharacterSet.valueOf(newElem.getStrings(null));
            }
            catch (Exception ex) {
                log.warn("Failed to consider specified Charset!");
                this.charset = null;
            }
        }
        return super.put(newElem);
    }

    public DcmElement remove(int tag) {
        if (tag == 524293) {
            this.charset = null;
        }
        return super.remove(tag);
    }

    public void clear() {
        super.clear();
        this.charset = null;
        this.totLen = 0;
    }

    public void readFile(InputStream in, FileFormat format, int stopTag) throws IOException, DcmValueException {
        DcmParserImpl parser = new DcmParserImpl(in);
        parser.setDcmHandler(this.getDcmHandler());
        parser.parseDcmFile(format, stopTag);
    }

    public void readDataset(InputStream in, DcmDecodeParam param, int stopTag) throws IOException, DcmValueException {
        DcmParserImpl parser = new DcmParserImpl(in);
        parser.setDcmHandler(this.getDcmHandler());
        parser.parseDataset(param, stopTag);
    }

    public void readFile(ImageInputStream in, FileFormat format, int stopTag) throws IOException, DcmValueException {
        DcmParserImpl parser = new DcmParserImpl(in);
        parser.setDcmHandler(this.getDcmHandler());
        parser.parseDcmFile(format, stopTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFile(File f, FileFormat format, int stopTag) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        try {
            this.readFile(in, format, stopTag);
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException ignore) {}
        }
    }
}

