/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.IOException;
import java.nio.charset.Charset;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SAXHandlerAdapter
extends DefaultHandler {
    private final DcmHandler handler;
    private int vr;
    static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");

    public SAXHandlerAdapter(DcmHandler handler) {
        this.handler = handler;
    }

    public void startDocument() throws SAXException {
        this.handler.setDcmDecodeParam(DcmDecodeParam.EVR_LE);
    }

    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        try {
            if ("elm".equals(qName)) {
                this.element(attr.getValue("tag"), attr.getValue("vr"), attr.getValue("pos"));
            } else if ("val".equals(qName)) {
                this.value(attr.getValue("len"), attr.getValue("data"));
            } else if ("seq".equals(qName)) {
                this.handler.startSequence(-1);
            } else if ("item".equals(qName)) {
                this.item(attr.getValue("id"), attr.getValue("pos"));
            } else if ("frag".equals(qName)) {
                this.fragment(attr.getValue("id"), attr.getValue("pos"), attr.getValue("len"), attr.getValue("data"));
            } else if ("filemetainfo".equals(qName)) {
                this.handler.startFileMetaInfo(this.preamble(attr.getValue("preamble")));
            } else if ("dataset".equals(qName)) {
                this.handler.startDataset();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SAXException(qName, ex);
        }
    }

    private byte[] preamble(String data) {
        return data == null ? null : StringUtils.parseBytes(data);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if ("elm".equals(qName)) {
                this.handler.endElement();
            } else if ("seq".equals(qName)) {
                this.handler.endSequence(-1);
            } else if ("item".equals(qName)) {
                this.handler.endItem(-1);
            } else if ("filemetainfo".equals(qName)) {
                this.handler.endFileMetaInfo();
            } else if ("dataset".equals(qName)) {
                this.handler.endDataset();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SAXException(qName, ex);
        }
    }

    private void element(String tag, String vrStr, String pos) throws IOException {
        this.vr = VRs.valueOf(vrStr);
        this.handler.startElement(Integer.parseInt(tag, 16), this.vr, pos != null ? (long)Integer.parseInt(pos) : -1L);
    }

    private void value(String len, String val) throws IOException {
        int l = Integer.parseInt(len);
        byte[] b = StringUtils.parseValue(this.vr, val, ISO_8859_1);
        this.handler.value(b, 0, b.length);
    }

    private void sequence(String tag) throws IOException {
        this.handler.startSequence(-1);
    }

    private void item(String id, String pos) throws IOException {
        this.handler.startItem(Integer.parseInt(id), pos != null ? (long)Integer.parseInt(pos) : -1L, -1);
    }

    private void fragment(String id, String pos, String len, String val) throws IOException {
        int l = Integer.parseInt(len);
        byte[] b = StringUtils.parseValue(this.vr, val, null);
        this.handler.fragment(Integer.parseInt(id), pos != null ? (long)Integer.parseInt(pos) : -1L, b, 0, l);
    }
}

