/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.image;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.image.ColorModelParam;
import org.dcm4cheri.image.BasicColorModelParam;

final class PaletteColorParam
extends BasicColorModelParam {
    private static final Logger log = Logger.getLogger(PaletteColorParam.class);
    private final byte[] r;
    private final byte[] g;
    private final byte[] b;

    public PaletteColorParam(Dataset ds) {
        super(ds);
        if (this.min < 0) {
            throw new UnsupportedOperationException("Signed PALETTE COLOR not supported!");
        }
        this.r = PaletteColorParam.generate(this.size, ds, 2625793, 2626049, 0x281221);
        this.g = PaletteColorParam.generate(this.size, ds, 2625794, 2626050, 0x281222);
        this.b = PaletteColorParam.generate(this.size, ds, 2625795, 2626051, 2626083);
    }

    public ColorModel newColorModel() {
        log.info("Creatinga  plaett color model.");
        return new IndexColorModel(this.bits, this.size, this.r, this.g, this.b);
    }

    private static void throwLengthMismatch(int lutLen, int descLen) {
        throw new IllegalArgumentException("LUT Data length: " + lutLen + " mismatch entry value: " + descLen + " in LUT Descriptor");
    }

    private static byte[] generate(int size, Dataset ds, int descTag, int dataTag, int segmTag) {
        int[] desc = ds.getInts(descTag);
        if (desc == null) {
            throw new IllegalArgumentException("Missing LUT Descriptor!");
        }
        if (desc.length != 3) {
            throw new IllegalArgumentException("Illegal LUT Descriptor: " + desc);
        }
        int len = desc[0] == 0 ? 65536 : desc[0];
        int off = desc[1];
        if (len < 0) {
            throw new IllegalArgumentException("Illegal LUT Descriptor: len=" + len);
        }
        if (off < 0) {
            throw new IllegalArgumentException("off: " + off);
        }
        ByteBuffer data = ds.getByteBuffer(dataTag);
        ByteBuffer segm = ds.getByteBuffer(segmTag);
        if (data == null && segm == null) {
            throw new IllegalArgumentException("Missing LUT Data!");
        }
        byte[] out = new byte[size];
        switch (desc[2]) {
            case 16: {
                if (data != null) {
                    if (data.limit() != len * 2) {
                        PaletteColorParam.throwLengthMismatch(data.limit(), len);
                    }
                    data.rewind();
                    int i = off;
                    while (data.hasRemaining()) {
                        out[i] = (byte)(data.getShort() >> 8);
                        ++i;
                    }
                    break;
                }
                PaletteColorParam.inflate(segm, out, off, len);
                break;
            }
            case 8: {
                if (data != null) {
                    if (data.limit() != len) {
                        PaletteColorParam.throwLengthMismatch(data.limit(), len);
                    }
                    data.rewind();
                    int i = off;
                    while (data.hasRemaining()) {
                        short tmp = data.getShort();
                        out[i++] = (byte)(tmp & 0xFF);
                        out[i++] = (byte)(tmp >> 8 & 0xFF);
                    }
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Illegal LUT Descriptor: bits=" + desc[2]);
            }
        }
        Arrays.fill(out, 0, off, out[off]);
        Arrays.fill(out, off + len, size, out[off + len - 1]);
        return out;
    }

    private static void inflate(ByteBuffer segm, byte[] out, int off, int len) {
        int x0 = off;
        int y0 = 0;
        segm.rewind();
        block9: while (segm.hasRemaining()) {
            short op = segm.getShort();
            int n = segm.getShort() & 0xFFFF;
            switch (op) {
                case 0: {
                    int j;
                    for (j = 0; j < n; ++j) {
                        int n2 = x0++;
                        y0 = segm.getShort() & 0xFFFF;
                        out[n2] = (byte)(y0 >> 8);
                    }
                    continue block9;
                }
                case 1: {
                    int y1 = segm.getShort() & 0xFFFF;
                    int dy = y1 - y0;
                    int j = 0;
                    while (j < n) {
                        out[x0++] = (byte)(y0 + dy * ++j / n >> 8);
                    }
                    y0 = y1;
                    break;
                }
                case 2: {
                    int dy;
                    int y1;
                    int pos = segm.getShort() & 0xFFFF | segm.getShort() << 16;
                    segm.mark();
                    segm.position(pos);
                    block12: for (int j = 0; j < n; ++j) {
                        short op2 = segm.getShort();
                        int n2 = segm.getShort() & 0xFFFF;
                        switch (op2) {
                            case 0: {
                                int j2;
                                for (j2 = 0; j2 < n2; ++j2) {
                                    int n3 = x0++;
                                    y0 = segm.getShort() & 0xFFFF;
                                    out[n3] = (byte)(y0 >> 8);
                                }
                                continue block12;
                            }
                            case 1: {
                                y1 = segm.getShort() & 0xFFFF;
                                dy = y1 - y0;
                                int j2 = 0;
                                while (j2 < n2) {
                                    out[x0++] = (byte)(y0 + dy * ++j2 / n2 >> 8);
                                }
                                y0 = y1;
                                continue block12;
                            }
                            default: {
                                throw new IllegalArgumentException("illegal op code:" + op2 + ", index:" + (segm.position() - 4));
                            }
                        }
                    }
                    segm.reset();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal op code:" + op + ", index:" + (segm.position() - 4));
                }
            }
        }
        if (x0 - off != len) {
            PaletteColorParam.throwLengthMismatch(x0 - off, len);
        }
    }

    public ColorModelParam update(float center, float width, boolean inverse) {
        throw new UnsupportedOperationException();
    }

    public float getRescaleSlope() {
        throw new UnsupportedOperationException();
    }

    public float getRescaleIntercept() {
        throw new UnsupportedOperationException();
    }

    public float getWindowCenter(int index) {
        throw new UnsupportedOperationException();
    }

    public float getWindowWidth(int index) {
        throw new UnsupportedOperationException();
    }

    public int getNumberOfWindows() {
        throw new UnsupportedOperationException();
    }

    public boolean isMonochrome() {
        return false;
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isInverse() {
        return false;
    }

    public float toMeasureValue(int pxValue) {
        throw new UnsupportedOperationException();
    }

    public int toPixelValue(float measureValue) {
        throw new UnsupportedOperationException();
    }
}

