/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.dcm4che.net.AsyncOpsWindow;
import org.dcm4che.net.PDUException;
import org.dcm4cheri.net.AAbortImpl;

final class AsyncOpsWindowImpl
implements AsyncOpsWindow {
    private final int maxOpsInvoked;
    private final int maxOpsPerformed;
    static final AsyncOpsWindow DEFAULT = new AsyncOpsWindowImpl(1, 1);

    AsyncOpsWindowImpl(int maxOpsInvoked, int maxOpsPerformed) {
        this.maxOpsInvoked = maxOpsInvoked;
        this.maxOpsPerformed = maxOpsPerformed;
    }

    AsyncOpsWindowImpl(DataInputStream din, int len) throws IOException, PDUException {
        if (len != 4) {
            throw new PDUException("Illegal length of AsyncOpsWindow sub-item: " + len, new AAbortImpl(2, 6));
        }
        this.maxOpsInvoked = din.readUnsignedShort();
        this.maxOpsPerformed = din.readUnsignedShort();
    }

    public final int getMaxOpsInvoked() {
        return this.maxOpsInvoked;
    }

    public final int getMaxOpsPerformed() {
        return this.maxOpsPerformed;
    }

    void writeTo(DataOutputStream dout) throws IOException {
        dout.write(83);
        dout.write(0);
        dout.writeShort(4);
        dout.writeShort(this.maxOpsInvoked);
        dout.writeShort(this.maxOpsPerformed);
    }

    public String toString() {
        return "AsyncOpsWindow[maxOpsInvoked=" + this.maxOpsInvoked + ",maxOpsPerformed=" + this.maxOpsPerformed + "]";
    }
}

