/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.IOException;
import java.io.OutputStream;
import org.dcm4che.data.Command;
import org.dcm4che.net.Dimse;
import org.dcm4cheri.net.DimseImpl;
import org.dcm4cheri.net.FsmImpl;
import org.dcm4cheri.net.PDataTFImpl;

final class DimseWriterImpl {
    private final FsmImpl fsm;
    private PDataTFImpl pDataTF = null;
    private int pcid;
    private boolean cmd;
    private boolean packPDVs = false;

    public DimseWriterImpl(FsmImpl fsm) {
        this.fsm = fsm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(Dimse dimse) throws IOException {
        this.pcid = dimse.pcid();
        String tsUID = this.fsm.getAcceptedTransferSyntaxUID(this.pcid);
        if (tsUID == null) {
            throw new IllegalStateException();
        }
        ((DimseImpl)dimse).setTransferSyntaxUID(tsUID);
        this.fsm.fireWrite(dimse);
        if (this.pDataTF == null) {
            this.pDataTF = new PDataTFImpl(this.fsm.getWriteMaxLength());
        }
        this.cmd = true;
        this.pDataTF.openPDV(this.pcid, true);
        PDataTFOutputStream out = new PDataTFOutputStream();
        Command c = dimse.getCommand();
        try {
            c.write(out);
        }
        finally {
            ((OutputStream)out).close();
        }
        if (c.hasDataset()) {
            if (!this.packPDVs) {
                this.flushPDataTF();
            }
            this.cmd = false;
            this.pDataTF.openPDV(this.pcid, false);
            out = new PDataTFOutputStream();
            try {
                dimse.writeTo(out, tsUID);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        this.flushPDataTF();
    }

    public void flushPDataTF() throws IOException {
        boolean open = this.pDataTF.isOpenPDV();
        if (open) {
            this.pDataTF.closePDV(false);
        }
        if (!this.pDataTF.isEmpty()) {
            this.fsm.write(this.pDataTF);
        }
        this.pDataTF.clear();
        if (open) {
            this.pDataTF.openPDV(this.pcid, this.cmd);
        }
    }

    private void closeStream() throws IOException {
        this.pDataTF.closePDV(true);
        if (!this.cmd) {
            this.flushPDataTF();
        }
    }

    public boolean isPackPDVs() {
        return this.packPDVs;
    }

    public void setPackPDVs(boolean packPDVs) {
        this.packPDVs = packPDVs;
    }

    private class PDataTFOutputStream
    extends OutputStream {
        private PDataTFOutputStream() {
        }

        public final void write(int b) throws IOException {
            if (DimseWriterImpl.this.pDataTF.free() == 0) {
                DimseWriterImpl.this.flushPDataTF();
            }
            DimseWriterImpl.this.pDataTF.write(b);
        }

        public final void write(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return;
            }
            int toWrite = len;
            while (true) {
                int n = Math.min(DimseWriterImpl.this.pDataTF.free(), toWrite);
                DimseWriterImpl.this.pDataTF.write(b, off, n);
                off += n;
                if ((toWrite -= n) == 0) {
                    return;
                }
                DimseWriterImpl.this.flushPDataTF();
            }
        }

        public void close() throws IOException {
            DimseWriterImpl.this.closeStream();
        }
    }
}

