/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.dcm4che.net.ExtNegotiation;
import org.dcm4cheri.net.AAssociateRQACImpl;
import org.dcm4cheri.util.StringUtils;

final class ExtNegotiationImpl
implements ExtNegotiation {
    private final String asuid;
    private final byte[] info;

    ExtNegotiationImpl(String asuid, byte[] info) {
        this.asuid = asuid;
        this.info = (byte[])info.clone();
    }

    ExtNegotiationImpl(DataInputStream din, int len) throws IOException {
        int uidLen = din.readUnsignedShort();
        this.asuid = AAssociateRQACImpl.readASCII(din, uidLen);
        this.info = new byte[len - uidLen - 2];
        din.readFully(this.info);
    }

    public final String getSOPClassUID() {
        return this.asuid;
    }

    public final byte[] info() {
        return (byte[])this.info.clone();
    }

    final int length() {
        return 2 + this.asuid.length() + this.info.length;
    }

    void writeTo(DataOutputStream dout) throws IOException {
        dout.write(86);
        dout.write(0);
        dout.writeShort(this.length());
        dout.writeShort(this.asuid.length());
        dout.writeBytes(this.asuid);
        dout.write(this.info);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("ExtNegotiation[sop=").append(AAssociateRQACImpl.DICT.lookup(this.asuid)).append(", info=");
        StringUtils.promptBytes(sb, this.info, 0, this.info.length, Integer.MAX_VALUE);
        sb.append("]");
        return sb.toString();
    }
}

