/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.dcm4che.net.AAbort;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRJ;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.AReleaseRP;
import org.dcm4che.net.AReleaseRQ;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationListener;
import org.dcm4che.net.AsyncOpsWindow;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.PDU;
import org.dcm4che.net.PDUException;
import org.dcm4che.net.PDataTF;
import org.dcm4che.net.PresContext;
import org.dcm4cheri.net.AAbortImpl;
import org.dcm4cheri.net.AAssociateACImpl;
import org.dcm4cheri.net.AAssociateRJImpl;
import org.dcm4cheri.net.AAssociateRQImpl;
import org.dcm4cheri.net.AReleaseRPImpl;
import org.dcm4cheri.net.AReleaseRQImpl;
import org.dcm4cheri.net.AssociationImpl;
import org.dcm4cheri.net.Multicaster;
import org.dcm4cheri.net.PDataTFImpl;
import org.dcm4cheri.net.UnparsedPDUImpl;
import org.dcm4cheri.util.LF_ThreadPool;

final class FsmImpl {
    static final Logger log = Logger.getLogger(FsmImpl.class);
    private final AssociationImpl assoc;
    private final boolean requestor;
    private final Socket s;
    private final InputStream in;
    private final OutputStream out;
    private int soCloseDelay = 500;
    private AAssociateRQ rq = null;
    private AAssociateAC ac = null;
    private AAssociateRJ rj = null;
    private AAbort aa = null;
    private AssociationListener assocListener = null;
    private LF_ThreadPool pool = null;
    private final State STA1;
    private State state = this.STA1 = new State(1){

        public String toString() {
            return "Sta 1 - Idle";
        }

        void entry() {
            if (FsmImpl.this.pool != null) {
                FsmImpl.this.pool.shutdown();
            }
            if (FsmImpl.this.assocListener != null) {
                FsmImpl.this.assocListener.closing(FsmImpl.this.assoc);
            }
            if (log.isInfoEnabled()) {
                log.info("closing connection - " + FsmImpl.this.s);
            }
            try {
                FsmImpl.this.in.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            try {
                FsmImpl.this.out.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            try {
                FsmImpl.this.s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (FsmImpl.this.assocListener != null) {
                FsmImpl.this.assocListener.closed(FsmImpl.this.assoc);
            }
        }

        void write(AAbort abort) throws IOException {
        }
    };
    private final State STA2 = new State(2){

        public String toString() {
            return "Sta 2 - Transport connection open (Awaiting A-ASSOCIATE-RQ PDU)";
        }

        PDU parse(UnparsedPDUImpl raw) throws PDUException {
            try {
                switch (raw.type()) {
                    case 1: {
                        FsmImpl.this.rq = AAssociateRQImpl.parse(raw);
                        FsmImpl.this.initMDC();
                        FsmImpl.this.fireReceived(FsmImpl.this.rq);
                        FsmImpl.this.changeState(FsmImpl.this.STA3);
                        return FsmImpl.this.rq;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        throw new PDUException("Unexpected " + raw, new AAbortImpl(2, 2));
                    }
                    case 7: {
                        FsmImpl.this.fireReceived(FsmImpl.this.aa = AAbortImpl.parse(raw));
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return FsmImpl.this.aa;
                    }
                }
                throw new PDUException("Unrecognized " + raw, new AAbortImpl(2, 1));
            }
            catch (PDUException ule) {
                try {
                    FsmImpl.this.write(ule.getAAbort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ule;
            }
        }
    };
    private final State STA3 = new State(3){

        public String toString() {
            return "Sta 3 - Awaiting local A-ASSOCIATE response primitive";
        }

        void write(AAssociateAC ac) throws IOException {
            try {
                ac.writeTo(FsmImpl.this.out);
            }
            catch (IOException e) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw e;
            }
            FsmImpl.this.changeState(FsmImpl.this.STA6);
        }

        void write(AAssociateRJ rj) throws IOException {
            try {
                rj.writeTo(FsmImpl.this.out);
            }
            catch (IOException e) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw e;
            }
            FsmImpl.this.changeState(FsmImpl.this.STA13);
        }
    };
    private final State STA4 = new State(4){

        public String toString() {
            return "Sta 4 - Awaiting transport connection opening to complete";
        }

        void write(AAssociateRQ rq) throws IOException {
            try {
                rq.writeTo(FsmImpl.this.out);
            }
            catch (IOException e) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw e;
            }
            FsmImpl.this.changeState(FsmImpl.this.STA5);
        }

        void write(AAbort abort) throws IOException {
            FsmImpl.this.changeState(FsmImpl.this.STA1);
        }
    };
    private final State STA5 = new State(5){

        public String toString() {
            return "Sta 5 - Awaiting A-ASSOCIATE-AC or A-ASSOCIATE-RJ PDU";
        }

        PDU parse(UnparsedPDUImpl raw) throws PDUException {
            try {
                switch (raw.type()) {
                    case 1: {
                        throw new PDUException("Unexpected " + raw, new AAbortImpl(2, 2));
                    }
                    case 2: {
                        FsmImpl.this.fireReceived(FsmImpl.this.ac = AAssociateACImpl.parse(raw));
                        FsmImpl.this.changeState(FsmImpl.this.STA6);
                        return FsmImpl.this.ac;
                    }
                    case 3: {
                        FsmImpl.this.fireReceived(FsmImpl.this.rj = AAssociateRJImpl.parse(raw));
                        FsmImpl.this.changeState(FsmImpl.this.STA13);
                        return FsmImpl.this.rj;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        throw new PDUException("Unexpected " + raw, new AAbortImpl(2, 2));
                    }
                    case 7: {
                        FsmImpl.this.fireReceived(FsmImpl.this.aa = AAbortImpl.parse(raw));
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return FsmImpl.this.aa;
                    }
                }
                throw new PDUException("Unrecognized " + raw, new AAbortImpl(2, 1));
            }
            catch (PDUException ule) {
                try {
                    FsmImpl.this.write(ule.getAAbort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ule;
            }
        }
    };
    private final State STA6 = new State(6){

        public String toString() {
            return "Sta 6 - Association established and ready for data transfer";
        }

        public boolean isOpen() {
            return true;
        }

        public boolean canWritePDataTF() {
            return true;
        }

        public boolean canReadPDataTF() {
            return true;
        }

        PDU parse(UnparsedPDUImpl raw) throws PDUException {
            try {
                switch (raw.type()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        throw new PDUException("Unexpected " + raw, new AAbortImpl(2, 2));
                    }
                    case 4: {
                        return FsmImpl.this.fireReceived(PDataTFImpl.parse(raw));
                    }
                    case 5: {
                        PDU pdu = FsmImpl.this.fireReceived(AReleaseRQImpl.parse(raw));
                        FsmImpl.this.changeState(FsmImpl.this.STA8);
                        return pdu;
                    }
                    case 6: {
                        throw new PDUException("Unexpected " + raw, new AAbortImpl(2, 2));
                    }
                    case 7: {
                        FsmImpl.this.fireReceived(FsmImpl.this.aa = AAbortImpl.parse(raw));
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return FsmImpl.this.aa;
                    }
                }
                throw new PDUException("Unrecognized " + raw, new AAbortImpl(2, 1));
            }
            catch (PDUException ule) {
                try {
                    FsmImpl.this.write(ule.getAAbort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ule;
            }
        }

        void write(PDataTF tf) throws IOException {
            try {
                tf.writeTo(FsmImpl.this.out);
            }
            catch (IOException e) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw e;
            }
        }

        void write(AReleaseRQ rq) throws IOException {
            try {
                FsmImpl.this.changeState(FsmImpl.this.STA7);
                rq.writeTo(FsmImpl.this.out);
            }
            catch (IOException e) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw e;
            }
        }
    };
    private final State STA7 = new State(7){

        public String toString() {
            return "Sta 7 - Awaiting A-RELEASE-RP PDU";
        }

        public boolean canReadPDataTF() {
            return true;
        }

        PDU parse(UnparsedPDUImpl raw) throws PDUException {
            try {
                switch (raw.type()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        throw new PDUException("Unexpected " + raw, new AAbortImpl(2, 2));
                    }
                    case 4: {
                        return FsmImpl.this.fireReceived(PDataTFImpl.parse(raw));
                    }
                    case 5: {
                        PDU pdu = FsmImpl.this.fireReceived(AReleaseRQImpl.parse(raw));
                        FsmImpl.this.changeState(FsmImpl.this.requestor ? FsmImpl.this.STA9 : FsmImpl.this.STA10);
                        return pdu;
                    }
                    case 6: {
                        AReleaseRPImpl pdu = AReleaseRPImpl.parse(raw);
                        FsmImpl.this.fireReceived(pdu);
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return pdu;
                    }
                    case 7: {
                        FsmImpl.this.fireReceived(FsmImpl.this.aa = AAbortImpl.parse(raw));
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return FsmImpl.this.aa;
                    }
                }
                throw new PDUException("Unrecognized " + raw, new AAbortImpl(2, 1));
            }
            catch (PDUException ule) {
                try {
                    FsmImpl.this.write(ule.getAAbort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ule;
            }
        }
    };
    private final State STA8 = new State(8){

        public String toString() {
            return "Sta 8 - Awaiting local A-RELEASE response primitive";
        }

        public boolean canWritePDataTF() {
            return true;
        }

        void write(PDataTF tf) throws IOException {
            try {
                tf.writeTo(FsmImpl.this.out);
            }
            catch (IOException e) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw e;
            }
        }

        void write(AReleaseRP rp) throws IOException {
            try {
                rp.writeTo(FsmImpl.this.out);
            }
            catch (IOException e) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw e;
            }
            FsmImpl.this.changeState(FsmImpl.this.STA13);
        }
    };
    private final State STA9 = new State(9){

        public String toString() {
            return "Sta 9 - Release collision requestor side; awaiting A-RELEASE response";
        }

        void write(AReleaseRP rp) throws IOException {
            try {
                rp.writeTo(FsmImpl.this.out);
            }
            catch (IOException e) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw e;
            }
            FsmImpl.this.changeState(FsmImpl.this.STA11);
        }
    };
    private final State STA10 = new State(10){

        public String toString() {
            return "Sta 10 - Release collision acceptor side; awaiting A-RELEASE response";
        }

        PDU parse(UnparsedPDUImpl raw) throws PDUException {
            try {
                switch (raw.type()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        throw new PDUException("Unexpected " + raw, new AAbortImpl(2, 2));
                    }
                    case 6: {
                        PDU pdu = FsmImpl.this.fireReceived(AReleaseRPImpl.parse(raw));
                        FsmImpl.this.changeState(FsmImpl.this.STA12);
                        return pdu;
                    }
                    case 7: {
                        FsmImpl.this.fireReceived(FsmImpl.this.aa = AAbortImpl.parse(raw));
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return FsmImpl.this.aa;
                    }
                }
                throw new PDUException("Unrecognized " + raw, new AAbortImpl(2, 1));
            }
            catch (PDUException ule) {
                try {
                    FsmImpl.this.write(ule.getAAbort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ule;
            }
        }
    };
    private final State STA11 = new State(11){

        public String toString() {
            return "Sta 11 - Release collision requestor side; awaiting A-RELEASE-RP PDU";
        }

        PDU parse(UnparsedPDUImpl raw) throws PDUException {
            try {
                switch (raw.type()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        throw new PDUException("Unexpected " + raw, new AAbortImpl(2, 2));
                    }
                    case 6: {
                        PDU pdu = FsmImpl.this.fireReceived(AReleaseRPImpl.parse(raw));
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return pdu;
                    }
                    case 7: {
                        FsmImpl.this.fireReceived(FsmImpl.this.aa = AAbortImpl.parse(raw));
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return FsmImpl.this.aa;
                    }
                }
                throw new PDUException("Unrecognized " + raw, new AAbortImpl(2, 1));
            }
            catch (PDUException ule) {
                try {
                    FsmImpl.this.write(ule.getAAbort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ule;
            }
        }
    };
    private final State STA12 = new State(12){

        public String toString() {
            return "Sta 12 - Release collision acceptor side; awaiting A-RELEASE-RP PDU";
        }

        void write(AReleaseRP rp) throws IOException {
            try {
                rp.writeTo(FsmImpl.this.out);
            }
            catch (IOException e) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw e;
            }
            FsmImpl.this.changeState(FsmImpl.this.STA13);
        }
    };
    private final State STA13 = new State(13){

        public String toString() {
            return "Sta 13 - Awaiting Transport Connection Close Indication";
        }

        void entry() {
            if (FsmImpl.this.pool != null) {
                FsmImpl.this.pool.shutdown();
            }
            try {
                Thread.sleep(FsmImpl.this.soCloseDelay);
            }
            catch (InterruptedException e) {
                log.warn("Socket close Delay was interrupted: ", e);
            }
            FsmImpl.this.changeState(FsmImpl.this.STA1);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FsmImpl(AssociationImpl assoc, Socket s, boolean requestor) throws IOException {
        this.assoc = assoc;
        this.requestor = requestor;
        this.s = s;
        this.initMDC();
        try {
            this.in = s.getInputStream();
            this.out = s.getOutputStream();
            log.info(s.toString());
            this.changeState(requestor ? this.STA4 : this.STA2);
        }
        finally {
            this.clearMDC();
        }
    }

    public synchronized void addAssociationListener(AssociationListener l) {
        this.assocListener = Multicaster.add(this.assocListener, l);
    }

    public synchronized void removeAssociationListener(AssociationListener l) {
        this.assocListener = Multicaster.remove(this.assocListener, l);
    }

    public void setThreadPool(LF_ThreadPool pool) {
        this.pool = pool;
    }

    final Socket socket() {
        return this.s;
    }

    final boolean isRequestor() {
        return this.requestor;
    }

    final void setSoCloseDelay(int soCloseDelay) {
        if (soCloseDelay < 0) {
            throw new IllegalArgumentException("soCloseDelay:" + soCloseDelay);
        }
        this.soCloseDelay = soCloseDelay;
    }

    final int getSoCloseDelay() {
        return this.soCloseDelay;
    }

    public int getState() {
        return this.state.getType();
    }

    public String getStateAsString() {
        return this.state.toString();
    }

    final AAssociateRQ getAAssociateRQ() {
        return this.rq;
    }

    final String getCallingAET() {
        if (this.rq == null) {
            throw new IllegalStateException(this.state.toString());
        }
        return this.rq.getCallingAET();
    }

    final String getCalledAET() {
        if (this.rq == null) {
            throw new IllegalStateException(this.state.toString());
        }
        return this.rq.getCalledAET();
    }

    final AAssociateAC getAAssociateAC() {
        return this.ac;
    }

    final AAssociateRJ getAAssociateRJ() {
        return this.rj;
    }

    final AAbort getAAbort() {
        return this.aa;
    }

    final int getWriteMaxLength() {
        if (this.ac == null || this.rq == null) {
            throw new IllegalStateException(this.state.toString());
        }
        return this.requestor ? this.ac.getMaxPDULength() : this.rq.getMaxPDULength();
    }

    final int getReadMaxLength() {
        if (this.ac == null || this.rq == null) {
            throw new IllegalStateException(this.state.toString());
        }
        return this.requestor ? this.rq.getMaxPDULength() : this.ac.getMaxPDULength();
    }

    final String getAcceptedTransferSyntaxUID(int pcid) {
        if (this.ac == null) {
            throw new IllegalStateException(this.state.toString());
        }
        PresContext pc = this.ac.getPresContext(pcid);
        if (pc == null || pc.result() != 0) {
            return null;
        }
        return pc.getTransferSyntaxUID();
    }

    final PresContext getProposedPresContext(int pcid) {
        if (this.rq == null) {
            throw new IllegalStateException(this.state.toString());
        }
        return this.rq.getPresContext(pcid);
    }

    final PresContext getAcceptedPresContext(String asuid, String tsuid) {
        if (this.ac == null) {
            throw new IllegalStateException(this.state.toString());
        }
        Iterator it = this.rq.listPresContext().iterator();
        while (it.hasNext()) {
            PresContext acpc;
            PresContext rqpc = (PresContext)it.next();
            if (!asuid.equals(rqpc.getAbstractSyntaxUID()) || (acpc = this.ac.getPresContext(rqpc.pcid())) == null || acpc.result() != 0 || !tsuid.equals(acpc.getTransferSyntaxUID())) continue;
            return acpc;
        }
        return null;
    }

    public final List listAcceptedPresContext(String asuid) {
        if (this.ac == null) {
            throw new IllegalStateException(this.state.toString());
        }
        LinkedList<PresContext> list = new LinkedList<PresContext>();
        Iterator it = this.rq.listPresContext().iterator();
        while (it.hasNext()) {
            PresContext acpc;
            PresContext rqpc = (PresContext)it.next();
            if (!asuid.equals(rqpc.getAbstractSyntaxUID()) || (acpc = this.ac.getPresContext(rqpc.pcid())) == null || acpc.result() != 0) continue;
            list.add(acpc);
        }
        return Collections.unmodifiableList(list);
    }

    public final int countAcceptedPresContext() {
        if (this.ac == null) {
            throw new IllegalStateException(this.state.toString());
        }
        return this.ac.countAcceptedPresContext();
    }

    int getMaxOpsInvoked() {
        if (this.ac == null) {
            throw new IllegalStateException(this.state.toString());
        }
        AsyncOpsWindow aow = this.ac.getAsyncOpsWindow();
        if (aow == null) {
            return 1;
        }
        return this.requestor ? aow.getMaxOpsInvoked() : aow.getMaxOpsPerformed();
    }

    int getMaxOpsPerformed() {
        if (this.ac == null) {
            throw new IllegalStateException(this.state.toString());
        }
        AsyncOpsWindow aow = this.ac.getAsyncOpsWindow();
        if (aow == null) {
            return 1;
        }
        return this.requestor ? aow.getMaxOpsPerformed() : aow.getMaxOpsInvoked();
    }

    private void changeState(State state) {
        if (this.state != state) {
            State prev = this.state;
            this.state = state;
            if (log.isDebugEnabled()) {
                log.debug(state.toString());
            }
            state.entry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDU read(int timeout, byte[] buf) throws IOException {
        try {
            UnparsedPDUImpl raw = null;
            InputStream inputStream = this.in;
            synchronized (inputStream) {
                this.s.setSoTimeout(timeout);
                try {
                    raw = new UnparsedPDUImpl(this.in, buf);
                }
                catch (IOException e) {
                    this.changeState(this.STA1);
                    throw e;
                }
            }
            return this.state.parse(raw);
        }
        catch (IOException ioe) {
            if (this.assocListener != null) {
                this.assocListener.error(this.assoc, ioe);
            }
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(AAssociateRQ rq) throws IOException {
        this.fireWrite(rq);
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.state.write(rq);
            }
        }
        catch (IOException ioe) {
            if (this.assocListener != null) {
                this.assocListener.error(this.assoc, ioe);
            }
            throw ioe;
        }
        this.rq = rq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(AAssociateAC ac) throws IOException {
        this.fireWrite(ac);
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.state.write(ac);
            }
        }
        catch (IOException ioe) {
            if (this.assocListener != null) {
                this.assocListener.error(this.assoc, ioe);
            }
            throw ioe;
        }
        this.ac = ac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(AAssociateRJ rj) throws IOException {
        this.fireWrite(rj);
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.state.write(rj);
            }
        }
        catch (IOException ioe) {
            if (this.assocListener != null) {
                this.assocListener.error(this.assoc, ioe);
            }
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(PDataTF data) throws IOException {
        this.fireWrite(data);
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.state.write(data);
            }
        }
        catch (IOException ioe) {
            if (this.assocListener != null) {
                this.assocListener.error(this.assoc, ioe);
            }
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(AReleaseRQ rq) throws IOException {
        this.fireWrite(rq);
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.state.write(rq);
            }
        }
        catch (IOException ioe) {
            if (this.assocListener != null) {
                this.assocListener.error(this.assoc, ioe);
            }
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(AReleaseRP rp) throws IOException {
        this.fireWrite(rp);
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.state.write(rp);
            }
        }
        catch (IOException ioe) {
            if (this.assocListener != null) {
                this.assocListener.error(this.assoc, ioe);
            }
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(AAbort abort) throws IOException {
        this.fireWrite(abort);
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.state.write(abort);
            }
        }
        catch (IOException ioe) {
            if (this.assocListener != null) {
                this.assocListener.error(this.assoc, ioe);
            }
            throw ioe;
        }
    }

    void fireReceived(Dimse dimse) {
        if (log.isInfoEnabled()) {
            log.info("received " + dimse);
        }
        if (this.assocListener != null) {
            this.assocListener.received((Association)this.assoc, dimse);
        }
    }

    void fireWrite(Dimse dimse) {
        if (log.isInfoEnabled()) {
            log.info("sending " + dimse);
        }
        if (this.assocListener != null) {
            this.assocListener.write((Association)this.assoc, dimse);
        }
    }

    private void fireWrite(PDU pdu) {
        if (pdu instanceof PDataTF) {
            if (log.isDebugEnabled()) {
                log.debug("sending " + pdu);
            }
        } else if (log.isInfoEnabled()) {
            log.info("sending " + pdu);
        }
        if (this.assocListener != null) {
            this.assocListener.write((Association)this.assoc, pdu);
        }
    }

    private PDU fireReceived(PDU pdu) {
        if (pdu instanceof PDataTF) {
            if (log.isDebugEnabled()) {
                log.debug("received " + pdu);
            }
        } else if (log.isInfoEnabled()) {
            log.info("received " + pdu);
        }
        if (this.assocListener != null) {
            this.assocListener.received((Association)this.assoc, pdu);
        }
        return pdu;
    }

    void initMDC() {
        this.initMDC(this.rq);
    }

    void initMDC(AAssociateRQ rq) {
        MDC.put("ip", this.s.getInetAddress().getHostAddress());
        if (rq != null) {
            MDC.put("calling", rq.getCallingAET());
            MDC.put("called", rq.getCalledAET());
        }
    }

    void clearMDC() {
        MDC.remove("ip");
        MDC.remove("calling");
        MDC.remove("called");
    }

    private abstract class State {
        private final int type;

        State(int type) {
            this.type = type;
        }

        public final int getType() {
            return this.type;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean canWritePDataTF() {
            return false;
        }

        public boolean canReadPDataTF() {
            return false;
        }

        void entry() {
        }

        PDU parse(UnparsedPDUImpl raw) throws PDUException {
            try {
                switch (raw.type()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        throw new PDUException("Unexpected " + raw, new AAbortImpl(2, 2));
                    }
                    case 7: {
                        FsmImpl.this.fireReceived(FsmImpl.this.aa = AAbortImpl.parse(raw));
                        FsmImpl.this.changeState(FsmImpl.this.STA1);
                        return FsmImpl.this.aa;
                    }
                }
                throw new PDUException("Unrecognized " + raw, new AAbortImpl(2, 1));
            }
            catch (PDUException ule) {
                try {
                    FsmImpl.this.write(ule.getAAbort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ule;
            }
        }

        void write(AAssociateRQ rq) throws IOException {
            throw new IllegalStateException();
        }

        void write(AAssociateAC ac) throws IOException {
            throw new IllegalStateException();
        }

        void write(AAssociateRJ rj) throws IOException {
            throw new IllegalStateException();
        }

        void write(PDataTF data) throws IOException {
            throw new IllegalStateException();
        }

        void write(AReleaseRQ rq) throws IOException {
            throw new IllegalStateException();
        }

        void write(AReleaseRP rp) throws IOException {
            throw new IllegalStateException();
        }

        void write(AAbort abort) throws IOException {
            try {
                abort.writeTo(FsmImpl.this.out);
            }
            catch (IOException e) {
                FsmImpl.this.changeState(FsmImpl.this.STA1);
                throw e;
            }
            FsmImpl.this.changeState(FsmImpl.this.STA13);
        }
    }
}

