/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import org.dcm4che.net.PDUException;
import org.dcm4che.net.PDataTF;
import org.dcm4cheri.net.AAbortImpl;
import org.dcm4cheri.net.UnparsedPDUImpl;

final class PDataTFImpl
implements PDataTF {
    private static final int DEF_MAX_LENGTH = 65535;
    private static final int MIN_MAX_LENGTH = 128;
    private final byte[] buf;
    private int pdulen;
    private int wpos;
    private final LinkedList pdvs = new LinkedList();
    private final Iterator it;
    private PDVImpl curPDV = null;

    static PDataTFImpl parse(UnparsedPDUImpl raw) throws PDUException {
        if (raw.buffer() == null) {
            throw new PDUException("PDU length exceeds supported maximum " + raw, new AAbortImpl(2, 0));
        }
        return new PDataTFImpl(raw.length(), raw.buffer());
    }

    private PDataTFImpl(int pdulen, byte[] buf) throws PDUException {
        int off;
        PDVImpl pdv;
        this.pdulen = pdulen;
        this.wpos = pdulen + 12;
        this.buf = buf;
        for (off = 6; off <= pdulen; off += 4 + pdv.length()) {
            pdv = new PDVImpl(off);
            this.pdvs.add(pdv);
        }
        if (off != pdulen + 6) {
            throw new PDUException("Illegal " + this.toString(), new AAbortImpl(2, 6));
        }
        this.it = this.pdvs.iterator();
    }

    PDataTFImpl(int maxLength) {
        if (maxLength == 0) {
            maxLength = 65535;
        }
        if (maxLength < 128 || (long)maxLength > 0x100000L) {
            throw new IllegalArgumentException("maxLength:" + maxLength);
        }
        this.pdulen = 0;
        this.wpos = 12;
        this.buf = new byte[6 + maxLength];
        this.it = null;
    }

    public void clear() {
        if (this.it != null) {
            throw new IllegalStateException("P-DATA-TF read only");
        }
        this.pdulen = 0;
        this.wpos = 12;
        this.pdvs.clear();
    }

    public PDataTF.PDV readPDV() {
        if (this.it == null) {
            throw new IllegalStateException("P-DATA-TF write only");
        }
        return this.it.hasNext() ? (PDataTF.PDV)this.it.next() : null;
    }

    public String toString(boolean verbose) {
        return this.toString();
    }

    public String toString() {
        return this.toStringBuffer(new StringBuffer()).toString();
    }

    StringBuffer toStringBuffer(StringBuffer sb) {
        sb.append("P-DATA-TF[pdulen=").append(this.pdulen).append("]");
        Iterator it = this.pdvs.iterator();
        while (it.hasNext()) {
            sb.append("\n\t").append(it.next());
        }
        return sb;
    }

    public final int free() {
        return this.buf.length - this.wpos;
    }

    public void openPDV(int pcid, boolean cmd) {
        if (this.it != null) {
            throw new IllegalStateException("P-DATA-TF read only");
        }
        if ((pcid & 1) == 0) {
            throw new IllegalArgumentException("pcid=" + pcid);
        }
        if (this.curPDV != null) {
            throw new IllegalStateException("Open PDV " + this.curPDV);
        }
        if (this.free() < 0) {
            throw new IllegalStateException("Maximal length of PDU reached");
        }
        this.curPDV = new PDVImpl(6 + this.pdulen);
        this.curPDV.pcid(pcid);
        this.curPDV.cmd(cmd);
        this.pdulen += 6;
    }

    boolean isOpenPDV() {
        return this.curPDV != null;
    }

    boolean isEmpty() {
        return this.pdvs.isEmpty();
    }

    public void closePDV(boolean last) {
        if (this.curPDV == null) {
            throw new IllegalStateException("No open PDV");
        }
        this.curPDV.last(last);
        this.curPDV.close();
        this.pdvs.add(this.curPDV);
        this.curPDV = null;
        this.wpos += 6;
    }

    public final boolean write(int b) {
        if (this.curPDV == null) {
            throw new IllegalStateException("No open PDV");
        }
        if (this.wpos >= this.buf.length) {
            return false;
        }
        this.buf[this.wpos++] = (byte)b;
        ++this.pdulen;
        return true;
    }

    public final int write(byte[] b, int off, int len) {
        if (this.curPDV == null) {
            throw new IllegalStateException("No open PDV");
        }
        int wlen = Math.min(len, this.buf.length - this.wpos);
        System.arraycopy(b, off, this.buf, this.wpos, wlen);
        this.wpos += wlen;
        this.pdulen += wlen;
        return wlen;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.curPDV != null) {
            throw new IllegalStateException("Open PDV " + this.curPDV);
        }
        this.buf[0] = 4;
        this.buf[1] = 0;
        this.buf[2] = (byte)(this.pdulen >> 24);
        this.buf[3] = (byte)(this.pdulen >> 16);
        this.buf[4] = (byte)(this.pdulen >> 8);
        this.buf[5] = (byte)(this.pdulen >> 0);
        out.write(this.buf, 0, this.pdulen + 6);
    }

    final class PDVImpl
    implements PDataTF.PDV {
        final int off;

        PDVImpl(int off) {
            this.off = off;
            byte[] byArray = PDataTFImpl.this.buf;
            int n = off + 5;
            byArray[n] = (byte)(byArray[n] & 3);
        }

        final void pcid(int pcid) {
            ((PDataTFImpl)PDataTFImpl.this).buf[this.off + 4] = (byte)pcid;
        }

        final void length(int pdvLen) {
            ((PDataTFImpl)PDataTFImpl.this).buf[this.off] = (byte)(pdvLen >> 24);
            ((PDataTFImpl)PDataTFImpl.this).buf[this.off + 1] = (byte)(pdvLen >> 16);
            ((PDataTFImpl)PDataTFImpl.this).buf[this.off + 2] = (byte)(pdvLen >> 8);
            ((PDataTFImpl)PDataTFImpl.this).buf[this.off + 3] = (byte)(pdvLen >> 0);
        }

        final void cmd(boolean cmd) {
            if (cmd) {
                byte[] byArray = PDataTFImpl.this.buf;
                int n = this.off + 5;
                byArray[n] = (byte)(byArray[n] | 1);
            } else {
                byte[] byArray = PDataTFImpl.this.buf;
                int n = this.off + 5;
                byArray[n] = (byte)(byArray[n] & 0xFFFFFFFE);
            }
        }

        final void last(boolean last) {
            if (last) {
                byte[] byArray = PDataTFImpl.this.buf;
                int n = this.off + 5;
                byArray[n] = (byte)(byArray[n] | 2);
            } else {
                byte[] byArray = PDataTFImpl.this.buf;
                int n = this.off + 5;
                byArray[n] = (byte)(byArray[n] & 0xFFFFFFFD);
            }
        }

        final void close() {
            this.length(PDataTFImpl.this.wpos - this.off - 4);
        }

        public final int length() {
            return (PDataTFImpl.this.buf[this.off] & 0xFF) << 24 | (PDataTFImpl.this.buf[this.off + 1] & 0xFF) << 16 | (PDataTFImpl.this.buf[this.off + 2] & 0xFF) << 8 | (PDataTFImpl.this.buf[this.off + 3] & 0xFF) << 0;
        }

        public final int pcid() {
            return PDataTFImpl.this.buf[this.off + 4] & 0xFF;
        }

        public final boolean cmd() {
            return (PDataTFImpl.this.buf[this.off + 5] & 1) != 0;
        }

        public final boolean last() {
            return (PDataTFImpl.this.buf[this.off + 5] & 2) != 0;
        }

        public final InputStream getInputStream() {
            return new ByteArrayInputStream(PDataTFImpl.this.buf, this.off + 6, this.length() - 2);
        }

        public String toString() {
            return this.toStringBuffer(new StringBuffer()).toString();
        }

        StringBuffer toStringBuffer(StringBuffer sb) {
            return sb.append("PDV[pc-").append(this.pcid()).append(this.cmd() ? ",cmd" : ",data").append(this.last() ? "(last),off=" : ",off=").append(this.off).append(",pdvlen=").append(this.length()).append("]");
        }
    }
}

