/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.dcm4che.net.PDUException;
import org.dcm4che.net.PresContext;
import org.dcm4cheri.net.AAbortImpl;
import org.dcm4cheri.net.AAssociateRQACImpl;

final class PresContextImpl
implements PresContext {
    private final int type;
    private final int pcid;
    private final int result;
    private final String asuid;
    private final List tsuids;

    PresContextImpl(int type, int pcid, int result, String asuid, String[] tsuids) {
        if ((pcid | 1) == 0 || (pcid & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("pcid=" + pcid);
        }
        if (tsuids.length == 0) {
            throw new IllegalArgumentException("Missing TransferSyntax");
        }
        this.type = type;
        this.pcid = pcid;
        this.result = result;
        this.asuid = asuid;
        this.tsuids = new ArrayList<String>(Arrays.asList(tsuids));
    }

    PresContextImpl(int type, DataInputStream din, int len) throws IOException, PDUException {
        int remain;
        int uidlen;
        this.type = type;
        this.pcid = din.readUnsignedByte();
        din.readUnsignedByte();
        this.result = din.readUnsignedByte();
        din.readUnsignedByte();
        String asuid = null;
        this.tsuids = new LinkedList();
        block4: for (remain = len - 4; remain > 0; remain -= 4 + uidlen) {
            int uidtype = din.readUnsignedByte();
            din.readUnsignedByte();
            uidlen = din.readUnsignedShort();
            switch (uidtype) {
                case 48: {
                    if (type == 33 || asuid != null) {
                        throw new PDUException("Unexpected Abstract Syntax sub-item in Presentation Context", new AAbortImpl(2, 5));
                    }
                    asuid = AAssociateRQACImpl.readASCII(din, uidlen);
                    continue block4;
                }
                case 64: {
                    if (type == 33 && !this.tsuids.isEmpty()) {
                        throw new PDUException("Unexpected Transfer Syntax sub-item in Presentation Context", new AAbortImpl(2, 5));
                    }
                    this.tsuids.add(AAssociateRQACImpl.readASCII(din, uidlen));
                    continue block4;
                }
                default: {
                    throw new PDUException("unrecognized item type " + Integer.toHexString(uidtype) + 'H', new AAbortImpl(2, 4));
                }
            }
        }
        this.asuid = asuid;
        if (remain < 0) {
            throw new PDUException("Presentation item length: " + len + " mismatch length of sub-items", new AAbortImpl(2, 6));
        }
    }

    void writeTo(DataOutputStream dout) throws IOException {
        dout.write(this.type);
        dout.write(0);
        dout.writeShort(this.length());
        dout.write(this.pcid);
        dout.write(0);
        dout.write(this.result);
        dout.write(0);
        if (this.asuid != null) {
            dout.write(48);
            dout.write(0);
            dout.writeShort(this.asuid.length());
            dout.writeBytes(this.asuid);
        }
        Iterator it = this.tsuids.iterator();
        while (it.hasNext()) {
            String tsuid = (String)it.next();
            dout.write(64);
            dout.write(0);
            dout.writeShort(tsuid.length());
            dout.writeBytes(tsuid);
        }
    }

    final int length() {
        int retval = 4;
        if (this.asuid != null) {
            retval += 4 + this.asuid.length();
        }
        Iterator it = this.tsuids.iterator();
        while (it.hasNext()) {
            retval += 4 + ((String)it.next()).length();
        }
        return retval;
    }

    final int type() {
        return this.type;
    }

    public final int pcid() {
        return this.pcid;
    }

    public final int result() {
        return this.result;
    }

    public final String getAbstractSyntaxUID() {
        return this.asuid;
    }

    public final List getTransferSyntaxUIDs() {
        return Collections.unmodifiableList(this.tsuids);
    }

    public final String getTransferSyntaxUID() {
        return this.tsuids.isEmpty() ? null : (String)this.tsuids.get(0);
    }

    public String toString() {
        return this.toStringBuffer(new StringBuffer()).toString();
    }

    private StringBuffer toStringBuffer(StringBuffer sb) {
        sb.append("PresContext[pcid=").append(this.pcid);
        if (this.type == 32) {
            sb.append(", as=").append(AAssociateRQACImpl.DICT.lookup(this.asuid));
        } else {
            sb.append(", result=").append(this.resultAsString());
        }
        Iterator it = this.tsuids.iterator();
        sb.append(", ts=").append(AAssociateRQACImpl.DICT.lookup((String)it.next()));
        while (it.hasNext()) {
            sb.append(", ").append(AAssociateRQACImpl.DICT.lookup((String)it.next()));
        }
        return sb.append("]");
    }

    public String resultAsString() {
        switch (this.result()) {
            case 0: {
                return "0 - acceptance";
            }
            case 1: {
                return "1 - user-rejection";
            }
            case 2: {
                return "2 - no-reason-given";
            }
            case 3: {
                return "3 - abstract-syntax-not-supported";
            }
            case 4: {
                return "4 - transfer-syntaxes-not-supported";
            }
        }
        return String.valueOf(this.result());
    }
}

