/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.IconImage;
import org.dcm4che.srom.ImageContent;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.RefSOP;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.CompositeContentImpl;

class ImageContentImpl
extends CompositeContentImpl
implements ImageContent {
    private static final int[] NULL_FRAMENUMBER = new int[0];
    protected int[] frameNumbers;
    protected RefSOP refPresentationSOP;
    protected IconImage iconImage;

    ImageContentImpl(KeyObject owner, Date obsDateTime, Template template, Code name, RefSOP refSOP, int[] frameNumbers, RefSOP refPresentationSOP, IconImage iconImage) {
        super(owner, obsDateTime, template, name, refSOP);
        this.setFrameNumbers(frameNumbers);
        this.refPresentationSOP = refPresentationSOP;
        this.iconImage = iconImage;
    }

    Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
        return new ImageContentImpl(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.refSOP, this.frameNumbers, this.refPresentationSOP, this.iconImage);
    }

    public String toString() {
        StringBuffer sb = this.prompt().append(this.refSOP);
        for (int i = 0; i < this.frameNumbers.length; ++i) {
            sb.append(",[").append(this.frameNumbers[0]).append("]");
        }
        if (this.refPresentationSOP != null) {
            sb.append(",").append(this.refPresentationSOP);
        }
        return sb.append(')').toString();
    }

    public final Content.ValueType getValueType() {
        return Content.ValueType.IMAGE;
    }

    public final int[] getFrameNumbers() {
        return (int[])this.frameNumbers.clone();
    }

    public final void setFrameNumbers(int[] frameNumbers) {
        this.frameNumbers = frameNumbers != null ? (int[])frameNumbers.clone() : NULL_FRAMENUMBER;
    }

    public final RefSOP getRefPresentationSOP() {
        return this.refPresentationSOP;
    }

    public final void setRefPresentationSOP(RefSOP refPresentationSOP) {
        this.refPresentationSOP = refPresentationSOP;
    }

    public final IconImage getIconImage() {
        return this.iconImage;
    }

    public final void setIconImage(IconImage iconImage) {
        this.iconImage = iconImage;
    }

    public void toDataset(Dataset ds) {
        super.toDataset(ds);
        if (this.frameNumbers.length == 0 && this.refPresentationSOP == null) {
            return;
        }
        Dataset sop = ds.get(528793).getItem();
        if (this.frameNumbers.length != 0) {
            sop.putIS(528736, this.frameNumbers);
        }
        if (this.refPresentationSOP != null) {
            this.refPresentationSOP.toDataset(sop.putSQ(528793).addNewItem());
        }
        if (this.iconImage != null) {
            this.iconImage.toDataset(sop.putSQ(0x880200).addNewItem());
        }
    }
}

