/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Study;
import org.dcm4cheri.srom.CodeImpl;

class StudyImpl
implements Study {
    private final String studyInstanceUID;
    private final String studyID;
    private final Long studyDateTime;
    private final String referringPhysicianName;
    private final String accessionNumber;
    private final String studyDescription;
    private final Code[] procedureCodes;

    public StudyImpl(String studyInstanceUID, String studyID, Date studyDateTime, String referringPhysicianName, String accessionNumber, String studyDescription, Code[] procedureCodes) {
        if (studyInstanceUID.length() == 0) {
            throw new IllegalArgumentException(studyInstanceUID);
        }
        this.studyInstanceUID = studyInstanceUID;
        this.studyID = studyID;
        this.studyDateTime = studyDateTime != null ? new Long(studyDateTime.getTime()) : null;
        this.referringPhysicianName = referringPhysicianName;
        this.accessionNumber = accessionNumber;
        this.studyDescription = studyDescription;
        this.procedureCodes = procedureCodes != null ? (Code[])procedureCodes.clone() : CodeImpl.EMPTY_ARRAY;
    }

    public StudyImpl(Dataset ds) throws DcmValueException {
        this(ds.getString(0x20000D), ds.getString(0x200010), ds.getDateTime(524320, 524336), ds.getString(524432), ds.getString(524368), ds.getString(528432), CodeImpl.newCodes(ds.get(528434)));
    }

    public final String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public final String getStudyID() {
        return this.studyID;
    }

    public final Date getStudyDateTime() {
        return this.studyDateTime != null ? new Date(this.studyDateTime) : null;
    }

    public final String getReferringPhysicianName() {
        return this.referringPhysicianName;
    }

    public final String getAccessionNumber() {
        return this.accessionNumber;
    }

    public final String getStudyDescription() {
        return this.studyDescription;
    }

    public final Code[] getProcedureCodes() {
        return (Code[])this.procedureCodes.clone();
    }

    public int hashCode() {
        return this.studyInstanceUID.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Study)) {
            return false;
        }
        Study sty = (Study)o;
        return this.studyInstanceUID.equals(sty.getStudyInstanceUID());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Study[").append(this.studyInstanceUID);
        sb.append(",ID=").append(this.studyID);
        sb.append(",A#=").append(this.accessionNumber);
        for (int i = 0; i < this.procedureCodes.length; ++i) {
            sb.append(",PC=").append(this.procedureCodes[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public void toDataset(Dataset ds) {
        ds.putUI(0x20000D, this.studyInstanceUID);
        ds.putSH(0x200010, this.studyID);
        Date date = this.getStudyDateTime();
        ds.putDA(524320, date);
        ds.putTM(524336, date);
        ds.putPN(524432, this.referringPhysicianName);
        ds.putLO(524368, this.accessionNumber);
        if (this.studyDescription != null) {
            ds.putLO(528432, this.studyDescription);
        }
        if (this.procedureCodes.length != 0) {
            DcmElement sq = ds.putSQ(528434);
            for (int i = 0; i < this.procedureCodes.length; ++i) {
                this.procedureCodes[i].toDataset(sq.addNewItem());
            }
        }
    }
}

