/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Verification;
import org.dcm4cheri.srom.CodeImpl;

class VerificationImpl
implements Verification {
    static final Verification[] EMPTY_ARRAY = new Verification[0];
    private final long time;
    private final String observerName;
    private final String observerOrg;
    private final Code observerCode;

    public VerificationImpl(Date time, String observerName, String observerOrg, Code observerCode) {
        this.time = time.getTime();
        this.observerName = observerName;
        if (this.observerName.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.observerOrg = observerOrg;
        this.observerCode = observerCode;
    }

    public VerificationImpl(Dataset ds) throws DcmValueException {
        this(ds.getDate(4235312), ds.getString(4235381), ds.getString(4235303), CodeImpl.newCode(ds.getItem(4235400)));
    }

    public String getVerifyingObserverName() {
        return this.observerName;
    }

    public Code getVerifyingObserverCode() {
        return this.observerCode;
    }

    public String getVerifyingOrganization() {
        return this.observerOrg;
    }

    public Date getVerificationDateTime() {
        return new Date(this.time);
    }

    public String toString() {
        return "Verification[" + this.getVerificationDateTime() + "/" + this.observerName + "]";
    }

    public int compareTo(Object obj) {
        VerificationImpl v = (VerificationImpl)obj;
        return (int)(v.time - this.time);
    }

    public void toDataset(Dataset ds) {
        ds.putDT(4235312, new Date(this.time));
        ds.putPN(4235381, this.observerName);
        ds.putLO(4235303, this.observerOrg);
        if (this.observerCode != null) {
            this.observerCode.toDataset(ds.putSQ(4235400).addNewItem());
        }
    }
}

