/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import open.dolphin.client.TreeInfo;
import open.dolphin.client.editor.stamp.StampBoxFrame;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.client.editor.stamp.StampTreePanel;
import open.dolphin.component.DnDTabbedPane;
import open.dolphin.infomodel.IStampTreeModel;
import open.dolphin.infomodel.ModuleInfoBean;

public abstract class AbstractStampBox
extends DnDTabbedPane {
    private IStampTreeModel stampTreeModel;
    private StampBoxFrame context;

    public AbstractStampBox(StampBoxFrame plugin, IStampTreeModel model) {
        this.setContext(plugin);
        this.setStampTreeModel(model);
        this.buildStampBox();
    }

    public StampBoxFrame getContext() {
        return this.context;
    }

    private void setContext(StampBoxFrame plugin) {
        this.context = plugin;
    }

    public IStampTreeModel getStampTreeModel() {
        return this.stampTreeModel;
    }

    private void setStampTreeModel(IStampTreeModel stampTreeModel) {
        this.stampTreeModel = stampTreeModel;
    }

    protected abstract void buildStampBox();

    protected abstract void buildStampBox(String var1);

    public StampTree getStampTree(String entity) {
        int count = this.getTabCount();
        boolean found = false;
        StampTree tree = null;
        for (int i = 0; i < count; ++i) {
            StampTreePanel panel = (StampTreePanel)this.getComponentAt(i);
            tree = panel.getTree();
            if (!entity.equals(tree.getEntity())) continue;
            found = true;
            break;
        }
        return found ? tree : null;
    }

    public StampTree getStampTree(int index) {
        if (index >= 0 && index < this.getTabCount()) {
            StampTreePanel panel = (StampTreePanel)this.getComponentAt(index);
            return panel.getTree();
        }
        return null;
    }

    public boolean isHasEditor(int index) {
        return false;
    }

    public void setHasNoEditorEnabled(boolean b) {
    }

    public List<TreeInfo> getAllTreeInfos() {
        ArrayList<TreeInfo> ret = new ArrayList<TreeInfo>();
        int cnt = this.getTabCount();
        for (int i = 0; i < cnt; ++i) {
            StampTreePanel tp = (StampTreePanel)this.getComponent(i);
            StampTree tree = tp.getTree();
            TreeInfo info = tree.getTreeInfo();
            ret.add(info);
        }
        return ret;
    }

    public List<StampTree> getAllTrees() {
        ArrayList<StampTree> ret = new ArrayList<StampTree>();
        int cnt = this.getTabCount();
        for (int i = 0; i < cnt; ++i) {
            StampTreePanel tp = (StampTreePanel)this.getComponent(i);
            StampTree tree = tp.getTree();
            ret.add(tree);
        }
        return ret;
    }

    public List<StampTree> getAllPTrees() {
        ArrayList<StampTree> ret = new ArrayList<StampTree>();
        int cnt = this.getTabCount();
        for (int i = 0; i < cnt; ++i) {
            StampTreePanel tp = (StampTreePanel)this.getComponent(i);
            StampTree tree = tp.getTree();
            if (tree.getEntity().equals("diagnosis")) continue;
            ret.add(tree);
        }
        return ret;
    }

    public List<ModuleInfoBean> getAllStamps(String entity) {
        StampTree tree = this.getStampTree(entity);
        if (tree != null) {
            ArrayList<ModuleInfoBean> ret = new ArrayList<ModuleInfoBean>();
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)tree.getModel().getRoot();
            Enumeration<TreeNode> e = rootNode.preorderEnumeration();
            while (e.hasMoreElements()) {
                StampTreeNode node = (StampTreeNode)e.nextElement();
                if (!node.isLeaf()) continue;
                ModuleInfoBean info = (ModuleInfoBean)node.getUserObject();
                ret.add(info);
            }
            return ret;
        }
        return null;
    }

    public List<String> getEntities() {
        ArrayList<String> ret = new ArrayList<String>();
        List<TreeInfo> infos = this.getAllTreeInfos();
        for (TreeInfo ti : infos) {
            ret.add(ti.getEntity());
        }
        return ret;
    }

    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStampTreeModel().getName());
        sb.append(" ");
        sb.append(this.getStampTreeModel().getPartyName());
        if (sb.length() > 16) {
            sb.setLength(12);
            sb.append("...");
        }
        return sb.toString();
    }

    public void removeAllTab() {
        while (this.getTabCount() != 1) {
            this.removeTabAt(0);
        }
    }
}

