/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.ActionMap;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import open.dolphin.client.IKarteComposite;

public class CompositeArea
extends JTextArea
implements IKarteComposite,
CaretListener {
    private boolean hasSelection;
    private ActionMap map;

    public CompositeArea() {
        this.addCaretListener(this);
    }

    public CompositeArea(int row, int col) {
        super(row, col);
        this.addCaretListener(this);
    }

    @Override
    public void enter(ActionMap map) {
        this.map = map;
        map.get("paste").setEnabled(this.canPaste());
    }

    @Override
    public void exit(ActionMap map) {
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        boolean newSelection;
        boolean bl = newSelection = e.getDot() != e.getMark();
        if (newSelection != this.hasSelection) {
            this.hasSelection = newSelection;
            this.map.get("paste").setEnabled(this.canPaste());
            this.map.get("cut").setEnabled(this.hasSelection);
            this.map.get("copy").setEnabled(this.hasSelection);
        }
    }

    private boolean canPaste() {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        return t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor);
    }
}

