/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.LinkedList;
import open.dolphin.client.TreeInfo;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.infomodel.ModuleInfoBean;

public class DefaultStampTreeXmlBuilder {
    private static final String[] MATCHES = new String[]{"<", ">", "&", "'", "\""};
    private static final String[] REPLACES = new String[]{"&lt;", "&gt;", "&amp;", "&apos;", "&quot;"};
    private LinkedList<StampTreeNode> linkedList;
    private BufferedWriter writer;
    private StringWriter stringWriter;
    private StampTreeNode rootNode;

    public String getProduct() {
        String result = this.stringWriter.toString();
        return result;
    }

    public void buildStart() throws IOException {
        this.stringWriter = new StringWriter();
        this.writer = new BufferedWriter(this.stringWriter);
        this.writer.write("<stampTree project=");
        this.writer.write(this.addQuote("open.dolphin"));
        this.writer.write(" version=");
        this.writer.write(this.addQuote("1.0"));
        this.writer.write(">");
        this.writer.write(System.getProperty("line.separator"));
    }

    public void buildRoot(StampTreeNode root) throws IOException {
        this.rootNode = root;
        TreeInfo treeInfo = (TreeInfo)this.rootNode.getUserObject();
        this.writer.write("<root name=");
        this.writer.write(this.addQuote(treeInfo.getName()));
        this.writer.write(" entity=");
        this.writer.write(this.addQuote(treeInfo.getEntity()));
        this.writer.write(">");
        this.writer.write(System.getProperty("line.separator"));
        this.linkedList = new LinkedList();
        this.linkedList.addFirst(this.rootNode);
    }

    public void buildNode(StampTreeNode node) throws IOException {
        if (node.isLeaf()) {
            this.buildLeafNode(node);
        } else {
            this.buildDirectoryNode(node);
        }
    }

    private void buildDirectoryNode(StampTreeNode node) throws IOException {
        if (node.getChildCount() != 0) {
            StampTreeNode curNode;
            StampTreeNode myParent = (StampTreeNode)node.getParent();
            if (myParent != (curNode = this.getCurrentNode())) {
                this.closeBeforeMyParent(myParent);
            }
            this.linkedList.addFirst(node);
            this.writer.write("<node name=");
            String val = this.toXmlText(node.toString());
            this.writer.write(this.addQuote(val));
            this.writer.write(">");
            this.writer.write(System.getProperty("line.separator"));
        }
    }

    private void buildLeafNode(StampTreeNode node) throws IOException {
        StampTreeNode curNode;
        StampTreeNode myParent = (StampTreeNode)node.getParent();
        if (myParent != (curNode = this.getCurrentNode())) {
            this.closeBeforeMyParent(myParent);
        }
        this.writer.write("<stampInfo name=");
        String val = this.toXmlText(node.toString());
        this.writer.write(this.addQuote(val));
        ModuleInfoBean info = (ModuleInfoBean)node.getUserObject();
        this.writer.write(" role=");
        this.writer.write(this.addQuote(info.getStampRole()));
        this.writer.write(" entity=");
        this.writer.write(this.addQuote(info.getEntity()));
        this.writer.write(" editable=");
        val = String.valueOf(info.isEditable());
        this.writer.write(this.addQuote(val));
        val = info.getStampMemo();
        if (val != null) {
            this.writer.write(" memo=");
            val = this.toXmlText(val);
            this.writer.write(this.addQuote(val));
        }
        if (info.isSerialized()) {
            val = info.getStampId();
            this.writer.write(" stampId=");
            this.writer.write(this.addQuote(val));
        }
        this.writer.write("/>");
        this.writer.write(System.getProperty("line.separator"));
    }

    public void buildRootEnd() throws IOException {
        this.closeBeforeMyParent(this.rootNode);
        this.writer.write("</root>");
        this.writer.write(System.getProperty("line.separator"));
    }

    public void buildEnd() throws IOException {
        this.writer.write("</stampTree>");
        this.writer.write(System.getProperty("line.separator"));
        this.writer.flush();
    }

    private StampTreeNode getCurrentNode() {
        return this.linkedList.getFirst();
    }

    private void closeBeforeMyParent(StampTreeNode parent) throws IOException {
        int index = this.linkedList.indexOf(parent);
        for (int j = 0; j < index; ++j) {
            this.writer.write("</node>");
            this.writer.write(System.getProperty("line.separator"));
            this.linkedList.removeFirst();
        }
    }

    private String addQuote(String s) {
        StringBuffer buf = new StringBuffer();
        buf.append("\"");
        buf.append(s);
        buf.append("\"");
        return buf.toString();
    }

    private String toXmlText(String text) {
        for (int i = 0; i < REPLACES.length; ++i) {
            text = text.replaceAll(MATCHES[i], REPLACES[i]);
        }
        return text;
    }
}

