/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.ChartWindow;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.IDocumentViewer;
import open.dolphin.client.IKarteViewer;
import open.dolphin.client.KarteDocumentViewer;
import open.dolphin.client.LetterReplyViewer;
import open.dolphin.client.LetterViewer;
import open.dolphin.client.karte.DocumentHistoryPanel;
import open.dolphin.helper.IChartCommandAccepter;
import open.dolphin.infomodel.DocInfoModel;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;

public class DocumentBridgeImpl
extends JPanel
implements PropertyChangeListener,
IChartDocument {
    public static final String TITLE = "\u53c2 \u7167";
    private IDocumentViewer curViwer;
    private static final String[] CHART_MENUS = new String[]{"openKarte", "save", "direction", "delete", "print", "modifyKarte", "ascending", "descending", "showModified", "showUnsend", "showSend", "showNewest", "insertText", "insertSchema", "insertStamp", "selectInsurance", "cut", "copy", "paste", "undo", "redo"};
    private IChart parent;
    private String title = "\u53c2 \u7167";
    private boolean dirty;
    private JScrollPane scroller;

    public DocumentBridgeImpl(IChart parent) {
        this.parent = parent;
        this.initComponents();
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.DocumentBridgeImpl;
    }

    private void initComponents() {
        this.scroller = new JScrollPane();
        this.scroller.setName("scroller");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    @Override
    public void start() {
        this.scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroller, "Center");
        this.scroller.getVerticalScrollBar().setUnitIncrement(GlobalSettings.karteScrollUnitIncrement());
        DocumentHistoryPanel historyPanel = this.parent.getDocumentHistory();
        historyPanel.addPropertyChangeListener("documentTypeProp", this);
        historyPanel.addPropertyChangeListener("historyUpdated", this);
        historyPanel.addPropertyChangeListener("selectedHistories", this);
        this.curViwer = new KarteDocumentViewer(this.parent);
        this.curViwer.start();
        this.enter();
    }

    @Override
    public void stop() {
        if (this.curViwer != null) {
            this.curViwer.stop();
        }
    }

    @Override
    public void enter() {
        if (this.curViwer != null) {
            this.curViwer.enter();
        } else {
            this.parent.getStatusPanel().setMessage("");
            this.parent.getChartMediator().setAccepter(this);
            this.disableMenus();
            this.parent.enabledAction("newKarte", true);
            this.parent.enabledAction("newDocument", true);
            this.parent.enabledAction("addUser", GlobalVariables.isAdmin());
        }
    }

    private void showDocuments(DocInfoModel[] docs) {
        if (docs == null || docs.length == 0) {
            return;
        }
        if (this.curViwer != null) {
            this.curViwer.showDocuments(docs, this.scroller);
            ((ChartWindow)this.parent).showDocument(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ChartMediator med = this.parent.getChartMediator();
        med.setCurKarteComposit(null);
        String prop = evt.getPropertyName();
        if (prop.equals("documentTypeProp")) {
            String docType = (String)evt.getNewValue();
            this.curViwer = docType.equals("letter") ? new LetterViewer(this.parent) : (docType.equals("letterReply") ? new LetterReplyViewer(this.parent) : new KarteDocumentViewer(this.parent));
            this.curViwer.start();
            return;
        }
        if (prop.equals("historyUpdated")) {
            if (this.curViwer != null) {
                this.curViwer.historyPeriodChanged();
            }
            this.scroller.setViewportView(null);
            return;
        }
        if (prop.equals("selectedHistories")) {
            if (evt.getOldValue() != null) {
                DocInfoModel[] selectedHistoroes = (DocInfoModel[])evt.getNewValue();
                this.showDocuments(selectedHistoroes);
            }
            return;
        }
    }

    public KarteDocumentViewer getCurrentViewer() {
        return (KarteDocumentViewer)this.curViwer;
    }

    public IKarteViewer getBaseKarte() {
        if (this.curViwer != null && this.curViwer instanceof KarteDocumentViewer) {
            return ((KarteDocumentViewer)this.curViwer).getBaseKarte();
        }
        return null;
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isReadOnly() {
        return this.parent.isReadOnly();
    }

    public void disableMenus() {
        ChartMediator mediator = this.parent.getChartMediator();
        mediator.disableMenus(CHART_MENUS);
    }

    protected void warning(String title, String message) {
        Window parentWindow = SwingUtilities.getWindowAncestor(this);
        JOptionPane.showMessageDialog(parentWindow, message, GlobalConstants.getFrameTitle(title), 2);
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        return false;
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    @Override
    public boolean update(Object o) {
        return true;
    }
}

