/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import open.dolphin.client.BlockGlass;
import open.dolphin.client.ChartWindow;
import open.dolphin.client.IChart;
import open.dolphin.client.IMainComponent;
import open.dolphin.client.IMainService;
import open.dolphin.client.IMainTool;
import open.dolphin.client.IMainWindow;
import open.dolphin.client.LoginDialog;
import open.dolphin.client.MainWindow;
import open.dolphin.client.ProfileDialog;
import open.dolphin.client.SchemaBox;
import open.dolphin.client.UserDialog;
import open.dolphin.client.WindowsMenuAdapter;
import open.dolphin.client.editor.stamp.StampBoxFrame;
import open.dolphin.client.editor.template.TemplateDialog;
import open.dolphin.client.labotestimporter.LaboTestImporter;
import open.dolphin.client.patientsearch.PatientSearchView;
import open.dolphin.client.settings.ProjectSettingDialog;
import open.dolphin.client.waitinglist.WaitingListView;
import open.dolphin.helper.ComponentMemory;
import open.dolphin.helper.IMainCommandAccepter;
import open.dolphin.helper.MainMenuSupport;
import open.dolphin.helper.PlugInMenuSupport;
import open.dolphin.helper.SchemaSupport;
import open.dolphin.helper.SynchronizedTask;
import open.dolphin.helper.WindowSupport;
import open.dolphin.infomodel.PatientVisitModel;
import open.dolphin.infomodel.UserModel;
import open.dolphin.log.LogWriter;
import open.dolphin.plugin.IPlugin;
import open.dolphin.plugin.PluginWrapper;
import open.dolphin.plugin.allergypanel.AllergyPanelPlugin;
import open.dolphin.plugin.labotestdocumentpanel.LaboTestDocumentPanelPlugin;
import open.dolphin.plugin.memopanel.MemoPanelPlugin;
import open.dolphin.plugin.patientinfodocumentpanel.PatientInfoDocumentPanelPlugin;
import open.dolphin.plugin.patientvisitinspector.PatientVisitInspectorPlugin;
import open.dolphin.plugin.physicalpanel.PhysicalPanelPlugin;
import open.dolphin.project.AbstractProjectFactory;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.pvtclientserver.PVTClientServer;
import open.dolphin.security.CertificateManager;
import open.dolphin.sendclaim.SendClaimImpl;
import open.dolphin.sendmml.SendMmlImpl;
import open.dolphin.server.IPVTServer;
import open.dolphin.utils.UserDirectoryInitializer;
import open.socket.data.Command;
import open.socket.data.RequestObject;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

public class Dolphin
extends Application
implements IMainWindow,
IMainCommandAccepter {
    private WindowSupport windowSupport;
    private MenuMediator menuMediator;
    private StateManager stateManager;
    private final HashMap<String, IMainService> providers = new HashMap();
    private JTabbedPane tabbedPane;
    private PageFormat pageFormat;
    private Properties saveEnv;
    private BlockGlass blockGlass;
    private SchemaBox imageBox;
    private TemplateDialog templateEditor;
    private IPVTServer pvtServer;
    private SendClaimImpl sendClaim;
    private SendMmlImpl sendMml;
    private ResourceMap resource;
    private JPanel content;
    private static StampBoxFrame stampBox;
    private static JFrame mainWindow;
    private static List<IChart> allEditorFrames;
    private static List<IChart> allCharts;
    private PlugInMenuSupport plugins;

    public static StampBoxFrame getStampBox() {
        return stampBox;
    }

    public void duplicateGuard() {
        try {
            final File lockFile = new File(this.getContext().getLocalStorage().getDirectory(), "lock");
            final FileOutputStream fos = new FileOutputStream(lockFile);
            final FileChannel fc = fos.getChannel();
            final FileLock lock = fc.tryLock();
            if (lock == null) {
                JOptionPane.showMessageDialog(null, "\u65e2\u306b OpenDolphin \u306f\u8d77\u52d5\u3057\u3066\u3044\u307e\u3059.", "\u30a8\u30e9\u30fc", 2);
                System.exit(0);
            } else {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            try {
                                if (lock != null && lock.isValid()) {
                                    lock.release();
                                }
                            }
                            finally {
                                fc.close();
                                fos.close();
                                lockFile.delete();
                            }
                        }
                        catch (IOException ex) {
                            LogWriter.fatal(this.getClass(), "\u30ed\u30c3\u30af\u306e\u89e3\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f.");
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    private void initPlugins() throws IllegalAccessException, InstantiationException, MalformedURLException, ClassNotFoundException {
        this.plugins = new PlugInMenuSupport();
        this.plugins.loadPlugin(new AllergyPanelPlugin());
        this.plugins.loadPlugin(new LaboTestDocumentPanelPlugin());
        this.plugins.loadPlugin(new MemoPanelPlugin());
        this.plugins.loadPlugin(new PatientInfoDocumentPanelPlugin());
        this.plugins.loadPlugin(new PatientVisitInspectorPlugin());
        this.plugins.loadPlugin(new PhysicalPanelPlugin());
        if (this.plugins.installPlugins(GlobalConstants.getPluginsTempDirectory(), GlobalConstants.getPluginsDirectory())) {
            this.plugins.loadPlugins(GlobalConstants.getPluginsDirectory(), "open.dolphin.plugin.");
        }
    }

    private void initSchemas() throws IllegalAccessException, InstantiationException, MalformedURLException, ClassNotFoundException {
        SchemaSupport schemas = new SchemaSupport();
        schemas.installSchemas(GlobalConstants.getSchemasTempDirectory(), GlobalConstants.getSchemasDirectory());
    }

    protected void initialize(String[] args) {
        this.duplicateGuard();
        ApplicationContext context = this.getContext();
        UserDirectoryInitializer.run(context);
        StringBuilder logFile = new StringBuilder();
        logFile.append(context.getLocalStorage().getDirectory()).append(File.separator).append("log").append(File.separator).append("dolphin.log");
        LogWriter.config(logFile.toString(), "INFO");
        this.resource = context.getResourceManager().getResourceMap(Dolphin.class);
        GlobalConstants.createGlobalConstants(context);
        GlobalVariables.createGlobalVariables();
        CertificateManager.createCertificateFile(context);
        allEditorFrames = new ArrayList<IChart>(3);
        allCharts = new ArrayList<IChart>(3);
    }

    protected void startup() {
        try {
            this.initPlugins();
            this.initSchemas();
        }
        catch (Exception ex) {
            LogWriter.error(this.getClass(), ex);
        }
        this.addExitListener(new ExitAdapter());
        PropertyChangeListener pl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                LoginDialog.LoginStatus result = (LoginDialog.LoginStatus)((Object)e.getNewValue());
                switch (result) {
                    case AUTHENTICATED: {
                        Dolphin.this.startServices();
                        Dolphin.this.initCustomComponents();
                        break;
                    }
                    case NOT_AUTHENTICATED: {
                        Dolphin.this.exit();
                        break;
                    }
                    case CANCELD: {
                        Dolphin.this.exit();
                        break;
                    }
                    default: {
                        LogWriter.fatal(this.getClass(), "case default");
                    }
                }
            }
        };
        LoginDialog login = new LoginDialog(null, true, this.plugins);
        login.addPropertyChangeListener("LOGIN_PROP", pl);
        login.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        if (this.providers != null) {
            try {
                HashMap cloneMap = null;
                HashMap<String, IMainService> hashMap = this.providers;
                synchronized (hashMap) {
                    cloneMap = (HashMap)this.providers.clone();
                }
                Iterator iter = cloneMap.values().iterator();
                while (iter != null && iter.hasNext()) {
                    IMainService pl = (IMainService)iter.next();
                    pl.stop();
                }
            }
            catch (Exception e) {
                LogWriter.error(this.getClass(), e);
            }
        }
        if (this.windowSupport != null) {
            mainWindow = this.windowSupport.getFrame();
            mainWindow.setVisible(false);
            mainWindow.dispose();
        }
        if (!GlobalSettings.isTrial()) {
            String dir = "";
            Preferences pref = Preferences.userRoot().node("open/dolphin/project");
            File file = new File("");
            dir = file.getAbsolutePath();
            pref.put("whereisDolphin", dir);
        }
    }

    public boolean close() {
        this.exit();
        return true;
    }

    @Override
    public boolean dispatchMainCommand(IMainCommandAccepter.MainCommand command) {
        switch (command) {
            case printerSetup: {
                return this.printerSetup();
            }
            case setKarteEnviroment: {
                return this.setKarteEnviroment();
            }
            case showStampBox: {
                return this.showStampBox();
            }
            case showSchemaBox: {
                return this.showSchemaBox();
            }
            case showTemplateEditor: {
                return this.showTemplateEditor();
            }
            case changePassword: {
                return this.changePassword();
            }
            case addUser: {
                return this.addUser();
            }
            case close: {
                return this.close();
            }
            case browseDolphinSupport: {
                return this.browseDolphinSupport();
            }
            case browseDolphinProject: {
                return this.browseDolphinProject();
            }
            case browseMedXml: {
                return this.browseMedXml();
            }
            case showAbout: {
                return this.showAbout();
            }
        }
        return false;
    }

    private boolean openPatient(PatientVisitModel pvt) {
        boolean isReadOnry = false;
        for (IPlugin plugin : this.plugins.values()) {
            PluginWrapper pluginWrapper = new PluginWrapper(plugin);
            RequestObject request = new RequestObject();
            UserModel loginUser = GlobalVariables.getUserModel();
            request.setUserId(loginUser.getId());
            request.setUserName(loginUser.getSirName());
            request.setPatientId(pvt.getPatient().getId());
            request.setPatientName(pvt.getPatient().getFullName());
            request.setCommand(Command.KARTE_OPEN);
            Object result = pluginWrapper.message(request);
            if (result == null || !pluginWrapper.IsDispatched()) continue;
            pluginWrapper.update(result);
            break;
        }
        return isReadOnry;
    }

    private void startServices() {
        this.saveEnv = new Properties();
        if (GlobalVariables.getUseAsPVTServer()) {
            this.startPvtServer();
        } else {
            this.saveEnv.put("pvtServer", "notRunning");
        }
        if (GlobalVariables.getSendClaim()) {
            this.startSendClaim();
        } else {
            this.saveEnv.put("sendClaim", "notRunning");
        }
        if (GlobalVariables.getClaimAddress() != null) {
            this.saveEnv.put("claimAddress", GlobalVariables.getClaimAddress());
        }
        if (GlobalVariables.getSendMML()) {
            this.startSendMml();
        } else {
            this.saveEnv.put("sendMml", "notRunning");
        }
        if (GlobalVariables.getCSGWPath() != null) {
            this.saveEnv.put("csgwPath", GlobalVariables.getCSGWPath());
        }
    }

    private String getWindowTitle() {
        return GlobalConstants.getFrameTitle(this.resource.getString("title", new Object[0])) + " | " + GlobalVariables.getUserId() + " | " + GlobalVariables.getUserModel().getLicenseModel().getLicenseDesc();
    }

    private void initCustomComponents() {
        Rectangle setBounds = new Rectangle(0, 0, 1000, 690);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int defaultX = (screenSize.width - setBounds.width) / 2;
        int defaultY = (screenSize.height - setBounds.height) / 2;
        int defaultWidth = 666;
        int defaultHeight = 678;
        MainWindow frame = new MainWindow();
        this.windowSupport = WindowSupport.create(frame, this.getWindowTitle());
        mainWindow = this.windowSupport.getFrame();
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/web_32.gif"));
        mainWindow.setIconImage(icon.getImage());
        JMenuBar myMenuBar = this.windowSupport.getMenuBar();
        Point loc = new Point(defaultX, defaultY);
        Dimension size = new Dimension(defaultWidth, defaultHeight);
        mainWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Dolphin.this.close();
            }
        });
        ComponentMemory cm = new ComponentMemory(mainWindow, loc, size, this);
        cm.setToPreferenceBounds();
        this.blockGlass = new BlockGlass();
        mainWindow.setGlassPane(this.blockGlass);
        this.menuMediator = new MenuMediator(this);
        WindowsMenuAdapter appMenu = new WindowsMenuAdapter();
        appMenu.setMenuSupports(null, this.menuMediator, null, this.plugins);
        appMenu.build(myMenuBar, false);
        this.menuMediator.registerActions(appMenu.getActionMap());
        this.tabbedPane = new JTabbedPane();
        this.content = new JPanel(new BorderLayout());
        this.content.setOpaque(true);
        this.content.add((Component)this.tabbedPane, "Center");
        this.content.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
        mainWindow.setContentPane(this.content);
        ArrayList<JPanel> mainComponentList = new ArrayList<JPanel>(3);
        mainComponentList.add(0, new WaitingListView());
        mainComponentList.add(1, new PatientSearchView());
        mainComponentList.add(2, new LaboTestImporter());
        int index = 0;
        for (IMainComponent iMainComponent : mainComponentList) {
            iMainComponent.setMenu(this.menuMediator);
            iMainComponent.setContext(this);
            iMainComponent.start();
            this.tabbedPane.addTab(iMainComponent.getName(), (Component)((Object)iMainComponent));
            this.providers.put(String.valueOf(index), iMainComponent);
            ++index;
        }
        mainComponentList.clear();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = Dolphin.this.tabbedPane.getSelectedIndex();
                IMainComponent plugin = (IMainComponent)Dolphin.this.providers.get(String.valueOf(index));
                if (plugin.getContext() == null) {
                    plugin.setContext(Dolphin.this);
                    plugin.start();
                    Dolphin.this.tabbedPane.setComponentAt(index, (Component)((Object)plugin));
                } else {
                    plugin.enter();
                }
                Dolphin.this.menuMediator.setLast(plugin);
            }
        });
        this.enabledAction("showTemplateEditor", true);
        this.stateManager = new StateManager();
        this.stateManager.processLogin(true);
        stampBox = new StampBoxFrame();
        Dolphin.getStampBox().setContext(this);
        try {
            if (Dolphin.getStampBox().getStartingTask().call().booleanValue()) {
                Dolphin.getStampBox().start();
                Dolphin.getStampBox().getFrame().setVisible(true);
                this.providers.put("stampBox", Dolphin.getStampBox());
                this.windowSupport.getFrame().setVisible(true);
                this.enabledAction("showTemplateEditor", true);
            }
        }
        catch (Exception ex) {
            LogWriter.fatal(this.getClass(), "\u30b9\u30bf\u30f3\u30d7\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f." + LogWriter.stackTrace(ex));
            JOptionPane.showMessageDialog(this.getFrame(), "\u30b9\u30bf\u30f3\u30d7\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f.", "\u30a8\u30e9\u30fc", 0);
            System.exit(1);
        }
    }

    @Override
    public BlockGlass getGlassPane() {
        return this.blockGlass;
    }

    @Override
    public IMainService getPlugin(String id) {
        return this.providers.get(id);
    }

    @Override
    public PlugInMenuSupport getPlugin() {
        return this.plugins;
    }

    @Override
    public void openKarte(PatientVisitModel pvt, String keyword) {
        boolean isReadOnry = false;
        isReadOnry = this.openPatient(pvt);
        ChartWindow chart = new ChartWindow(this, pvt, isReadOnry);
        chart.setKeyword(keyword);
        chart.start();
    }

    @Override
    public MainMenuSupport getMenuSupport() {
        return this.menuMediator;
    }

    @Override
    public Action getAction(String name) {
        return this.menuMediator.getAction(name);
    }

    @Override
    public JMenuBar getMenuBar() {
        return this.windowSupport.getMenuBar();
    }

    @Override
    public void registerActions(ActionMap actions) {
        this.menuMediator.registerActions(actions);
    }

    @Override
    public void enabledAction(String name, boolean b) {
        this.menuMediator.enabledAction(name, b);
    }

    public JFrame getFrame() {
        return this.windowSupport.getFrame();
    }

    @Override
    public PageFormat getPageFormat() {
        PrinterJob printJob;
        if (this.pageFormat == null && (printJob = PrinterJob.getPrinterJob()) != null) {
            this.pageFormat = printJob.defaultPage();
        }
        return this.pageFormat;
    }

    @Override
    public void block() {
        this.blockGlass.block();
    }

    @Override
    public void unblock() {
        this.blockGlass.unblock();
    }

    private void startPvtServer() {
        this.pvtServer = new PVTClientServer();
        this.pvtServer.setContext(this);
        this.pvtServer.start();
        this.providers.put("pvtServer", this.pvtServer);
        this.saveEnv.put("pvtServer", "running");
    }

    private void startSendClaim() {
        this.sendClaim = new SendClaimImpl();
        this.sendClaim.setContext(this);
        this.sendClaim.start();
        this.providers.put("sendClaim", this.sendClaim);
        this.saveEnv.put("sendClaim", "running");
    }

    private void startSendMml() {
        this.sendMml = new SendMmlImpl();
        this.sendMml.setContext(this);
        this.sendMml.start();
        this.providers.put("sendMml", this.sendMml);
        this.saveEnv.put("sendMml", "running");
    }

    public boolean printerSetup() {
        Runnable printer_initialize = new Runnable(){

            @Override
            public void run() {
                PrinterJob printJob = PrinterJob.getPrinterJob();
                if (Dolphin.this.pageFormat != null) {
                    Dolphin.this.pageFormat = printJob.pageDialog(Dolphin.this.pageFormat);
                } else {
                    Dolphin.this.pageFormat = printJob.defaultPage();
                    Dolphin.this.pageFormat = printJob.pageDialog(Dolphin.this.pageFormat);
                }
            }
        };
        Thread t = new Thread(printer_initialize);
        t.setPriority(5);
        t.start();
        return true;
    }

    private boolean setKarteEnviroment() {
        ProjectSettingDialog sd = new ProjectSettingDialog(this.plugins);
        sd.addPropertyChangeListener("SETTING_PROP", new PreferenceListener());
        sd.setLoginState(this.stateManager.isLogin());
        sd.setProject("karteSetting");
        sd.start();
        return true;
    }

    public void doPreference() {
        ProjectSettingDialog sd = new ProjectSettingDialog(this.plugins);
        sd.addPropertyChangeListener("SETTING_PROP", new PreferenceListener());
        sd.setLoginState(this.stateManager.isLogin());
        sd.setProject(null);
        sd.start();
    }

    @Override
    public boolean isKarteOpened(long patientId) {
        boolean opened = false;
        for (IChart chart : allCharts) {
            if (chart.getPatient().getId() != patientId) continue;
            opened = true;
            break;
        }
        return opened;
    }

    @Override
    public void addChart(IChart chart) {
        allCharts.add(chart);
    }

    @Override
    public boolean removeChart(IChart chart) {
        return allCharts.remove(chart);
    }

    @Override
    public void addEditorFrame(IChart chart) {
        allEditorFrames.add(chart);
    }

    @Override
    public void removeEditorFrame(IChart chart) {
        allEditorFrames.remove(chart);
    }

    private boolean isDirty() {
        if (allCharts != null && allCharts.size() > 0) {
            for (IChart chart : allCharts) {
                if (!chart.isDirty()) continue;
                return true;
            }
        }
        if (allEditorFrames != null && allEditorFrames.size() > 0) {
            for (IChart chart : allEditorFrames) {
                if (!chart.isDirty()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Callable<Boolean>> getStoppingTask() {
        ArrayList<Callable<Boolean>> tasks = new ArrayList<Callable<Boolean>>(1);
        try {
            HashMap cloneMap = null;
            HashMap<String, IMainService> hashMap = this.providers;
            synchronized (hashMap) {
                cloneMap = (HashMap)this.providers.clone();
            }
            Iterator iter = cloneMap.values().iterator();
            while (iter != null && iter.hasNext()) {
                Callable<Boolean> task;
                IMainService pl = (IMainService)iter.next();
                if (!(pl instanceof IMainTool) || (task = ((IMainTool)pl).getStoppingTask()) == null) continue;
                tasks.add(task);
            }
        }
        catch (Exception ex) {
            LogWriter.error(this.getClass(), ex);
        }
        return tasks;
    }

    public boolean canProcessExit() {
        if (this.providers.isEmpty()) {
            return true;
        }
        if (JOptionPane.showConfirmDialog(null, "OpenDolphin \u3092\u7d42\u4e86\u3057\u3066\u826f\u3044\u3067\u3059\u304b\uff1f", "\u78ba\u8a8d", 0) == 0) {
            if (this.isDirty()) {
                this.alertDirty();
            } else {
                return true;
            }
        }
        return false;
    }

    public void processExit() {
        this.KarteClose();
        List<Callable<Boolean>> tasks = this.getStoppingTask();
        try {
            boolean success = true;
            for (Callable<Boolean> c : tasks) {
                Boolean result = c.call();
                if (result.booleanValue()) continue;
                success = false;
                break;
            }
            if (!success) {
                this.doStoppingAlert();
            }
            this.OnExit();
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    private void OnExit() {
        UserModel loginUser = GlobalVariables.getUserModel();
        if (loginUser == null) {
            return;
        }
        for (IPlugin plugin : this.plugins.values()) {
            PluginWrapper pluginWrapper = new PluginWrapper(plugin);
            RequestObject request = new RequestObject();
            request.setUserId(loginUser.getId());
            request.setUserName(loginUser.getSirName());
            request.setCommand(Command.LOGOUT);
            Object result = pluginWrapper.message(request);
        }
    }

    public void KarteClose() {
        for (IChart chart : allCharts) {
            chart.close();
        }
    }

    private void alertDirty() {
        String msg0 = this.resource.getString("exitDolphin.msg0", new Object[0]);
        String msg1 = this.resource.getString("exitDolphin.msg1", new Object[0]);
        String taskTitle = this.resource.getString("exitDolphin.taskTitle", new Object[0]);
        JOptionPane.showMessageDialog(null, new Object[]{msg0, msg1}, GlobalConstants.getFrameTitle(taskTitle), 1);
    }

    private void doStoppingAlert() {
        String msg1 = "\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306e\u74b0\u5883\u4fdd\u5b58\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u751f\u3058\u307e\u3057\u305f\u3002";
        Object[] message = new Object[]{msg1};
        String exitOption = this.resource.getString("exitDolphin.exitOption", new Object[0]);
        String taskTitle = this.resource.getString("exitDolphin.taskTitle", new Object[0]);
        String title = GlobalConstants.getFrameTitle(taskTitle);
        Object[] options = new String[]{exitOption};
        int option = JOptionPane.showOptionDialog(null, message, title, -1, 0, null, options, options[0]);
    }

    private boolean changePassword() {
        ProfileDialog cp = new ProfileDialog();
        cp.start();
        return true;
    }

    private boolean addUser() {
        UserDialog au = new UserDialog();
        au.start();
        return true;
    }

    private boolean browseDolphinSupport() {
        this.browseURL(this.resource.getString("menu.dolphinSupportUrl", new Object[0]));
        return true;
    }

    private boolean browseDolphinProject() {
        this.browseURL(this.resource.getString("menu.dolphinUrl", new Object[0]));
        return true;
    }

    private boolean browseMedXml() {
        this.browseURL(this.resource.getString("menu.medXmlUrl", new Object[0]));
        return true;
    }

    private void browseURL(final String url) {
        ApplicationContext appCtx = GlobalConstants.getApplicationContext();
        Application app = appCtx.getApplication();
        final Desktop desktop = Desktop.getDesktop();
        SynchronizedTask<Object, Void> task = new SynchronizedTask<Object, Void>(app){

            @Override
            protected Object doInBackground() throws Exception {
                try {
                    try {
                        desktop.browse(new URI(url));
                    }
                    catch (URISyntaxException ex) {
                        LogWriter.error(this.getClass(), ex);
                    }
                }
                catch (IOException ex) {
                    LogWriter.error(this.getClass(), ex);
                }
                return true;
            }

            @Override
            protected void succeeded(Object result) {
            }

            @Override
            protected void cancelled() {
            }

            @Override
            protected void failed(Throwable cause) {
            }

            @Override
            protected void interrupted(InterruptedException e) {
            }
        };
        task.execute();
    }

    private boolean showAbout() {
        AbstractProjectFactory f = GlobalVariables.getProjectFactory();
        f.createAboutDialog();
        return true;
    }

    private boolean showSchemaBox() {
        if (this.imageBox == null) {
            this.imageBox = new SchemaBox();
            this.imageBox.setContext(this);
            this.imageBox.start();
        }
        this.imageBox.getFrame().setVisible(true);
        this.imageBox.getFrame().toFront();
        return true;
    }

    private boolean showTemplateEditor() {
        if (this.templateEditor == null) {
            this.templateEditor = new TemplateDialog(null, false);
        }
        this.templateEditor.setVisible(true);
        this.templateEditor.toFront();
        return true;
    }

    private boolean showStampBox() {
        if (!stampBox.getFrame().isVisible()) {
            Dolphin.getStampBox().getFrame().setVisible(true);
        }
        Dolphin.getStampBox().getFrame().toFront();
        return true;
    }

    public static void main(String[] args) {
        Application.launch(Dolphin.class, (String[])args);
    }

    class StateManager {
        private MainWindowState loginState;
        private MainWindowState logoffState;
        private MainWindowState currentState;

        public StateManager() {
            this.loginState = new LoginState();
            this.currentState = this.logoffState = new LogoffState();
        }

        public boolean isLogin() {
            return this.currentState.isLogin();
        }

        public void processLogin(boolean b) {
            this.currentState = b ? this.loginState : this.logoffState;
            this.currentState.enter();
        }
    }

    class LogoffState
    extends MainWindowState {
        @Override
        public boolean isLogin() {
            return false;
        }

        @Override
        public void enter() {
            Dolphin.this.menuMediator.disableAllMenus();
        }
    }

    class LoginState
    extends MainWindowState {
        @Override
        public boolean isLogin() {
            return true;
        }

        @Override
        public void enter() {
            Dolphin.this.menuMediator.disableAllMenus();
            String[] enables = new String[]{"printerSetup", "processExit", "setKarteEnviroment", "showStampBox", "showSchemaBox", "changePassword", "confirmRun", "update1", "browseDolphinSupport", "browseDolphinProject", "browseMedXml", "showAbout"};
            Dolphin.this.menuMediator.enableMenus(enables);
            Dolphin.this.menuMediator.enabledAction("addUser", GlobalVariables.isAdmin());
        }
    }

    abstract class MainWindowState {
        public abstract void enter();

        public abstract boolean isLogin();
    }

    public final class MenuMediator
    extends MainMenuSupport
    implements IMainCommandAccepter {
        public MenuMediator(IMainCommandAccepter owner) {
            super(owner);
        }

        public void menuSelected(MenuEvent e) {
        }

        @Override
        public void registerActions(ActionMap actions) {
            super.registerActions(actions);
        }

        @Override
        public boolean dispatchMainCommand(IMainCommandAccepter.MainCommand command) {
            switch (command) {
                case printerSetup: {
                    return Dolphin.this.printerSetup();
                }
                case setKarteEnviroment: {
                    return Dolphin.this.setKarteEnviroment();
                }
                case showStampBox: {
                    return Dolphin.this.showStampBox();
                }
                case showSchemaBox: {
                    return Dolphin.this.showSchemaBox();
                }
                case showTemplateEditor: {
                    return Dolphin.this.showTemplateEditor();
                }
                case changePassword: {
                    return Dolphin.this.changePassword();
                }
                case addUser: {
                    return Dolphin.this.addUser();
                }
                case close: {
                    return this.close();
                }
                case browseDolphinSupport: {
                    return Dolphin.this.browseDolphinSupport();
                }
                case browseDolphinProject: {
                    return Dolphin.this.browseDolphinProject();
                }
                case browseMedXml: {
                    return Dolphin.this.browseMedXml();
                }
                case showAbout: {
                    return Dolphin.this.showAbout();
                }
            }
            return false;
        }
    }

    class PreferenceListener
    implements PropertyChangeListener {
        PreferenceListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean valid;
            if (e.getPropertyName().equals("SETTING_PROP") && (valid = ((Boolean)e.getNewValue()).booleanValue())) {
                boolean stop;
                ArrayList<String> messages = new ArrayList<String>(2);
                boolean oldRunning = Dolphin.this.saveEnv.getProperty("pvtServer").equals("running");
                boolean newRun = GlobalVariables.getUseAsPVTServer();
                boolean start = !oldRunning && newRun;
                boolean bl = stop = oldRunning && !newRun;
                if (start) {
                    Dolphin.this.startPvtServer();
                    messages.add("\u53d7\u4ed8\u53d7\u4fe1\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002");
                } else if (stop && Dolphin.this.pvtServer != null) {
                    Dolphin.this.pvtServer.stop();
                    Dolphin.this.pvtServer = null;
                    Dolphin.this.saveEnv.put("pvtServer", "notRunning");
                    messages.add("\u53d7\u4ed8\u53d7\u4fe1\u3092\u505c\u6b62\u3057\u307e\u3057\u305f\u3002");
                }
                oldRunning = Dolphin.this.saveEnv.getProperty("sendClaim").equals("running");
                newRun = GlobalVariables.getSendClaim();
                start = !oldRunning && newRun;
                stop = oldRunning && !newRun;
                boolean restart = false;
                String oldAddress = Dolphin.this.saveEnv.getProperty("claimAddress");
                String newAddress = GlobalVariables.getClaimAddress();
                if (oldAddress != null && newAddress != null && !oldAddress.equals(newAddress) && newRun) {
                    restart = true;
                }
                if (start) {
                    Dolphin.this.startSendClaim();
                    Dolphin.this.saveEnv.put("claimAddress", newAddress);
                    messages.add("CLAIM\u9001\u4fe1\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002(\u9001\u4fe1\u30a2\u30c9\u30ec\u30b9=" + newAddress + ")");
                } else if (stop && Dolphin.this.sendClaim != null) {
                    Dolphin.this.sendClaim.stop();
                    Dolphin.this.sendClaim = null;
                    Dolphin.this.saveEnv.put("sendClaim", "notRunning");
                    Dolphin.this.saveEnv.put("claimAddress", newAddress);
                    messages.add("CLAIM\u9001\u4fe1\u3092\u505c\u6b62\u3057\u307e\u3057\u305f\u3002");
                } else if (restart) {
                    Dolphin.this.sendClaim.stop();
                    Dolphin.this.sendClaim = null;
                    Dolphin.this.startSendClaim();
                    Dolphin.this.saveEnv.put("claimAddress", newAddress);
                    messages.add("CLAIM\u9001\u4fe1\u3092\u30ea\u30b9\u30bf\u30fc\u30c8\u3057\u307e\u3057\u305f\u3002(\u9001\u4fe1\u30a2\u30c9\u30ec\u30b9=" + newAddress + ")");
                }
                oldRunning = Dolphin.this.saveEnv.getProperty("sendMml").equals("running");
                newRun = GlobalVariables.getSendMML();
                start = !oldRunning && newRun;
                stop = oldRunning && !newRun;
                restart = false;
                oldAddress = Dolphin.this.saveEnv.getProperty("csgwPath");
                newAddress = GlobalVariables.getCSGWPath();
                if (oldAddress != null && newAddress != null && !oldAddress.equals(newAddress) && newRun) {
                    restart = true;
                }
                if (start) {
                    Dolphin.this.startSendMml();
                    Dolphin.this.saveEnv.put("csgwPath", newAddress);
                    messages.add("MML\u9001\u4fe1\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002(\u9001\u4fe1\u30a2\u30c9\u30ec\u30b9=" + newAddress + ")");
                } else if (stop && Dolphin.this.sendMml != null) {
                    Dolphin.this.sendMml.stop();
                    Dolphin.this.sendMml = null;
                    Dolphin.this.saveEnv.put("sendMml", "notRunning");
                    Dolphin.this.saveEnv.put("csgwPath", newAddress);
                    messages.add("MML\u9001\u4fe1\u3092\u505c\u6b62\u3057\u307e\u3057\u305f\u3002");
                } else if (restart) {
                    Dolphin.this.sendMml.stop();
                    Dolphin.this.sendMml = null;
                    Dolphin.this.startSendMml();
                    Dolphin.this.saveEnv.put("csgwPath", newAddress);
                    messages.add("MML\u9001\u4fe1\u3092\u30ea\u30b9\u30bf\u30fc\u30c8\u3057\u307e\u3057\u305f\u3002(\u9001\u4fe1\u30a2\u30c9\u30ec\u30b9=" + newAddress + ")");
                }
                if (messages.size() > 0) {
                    String[] msgArray;
                    String[] msg = msgArray = messages.toArray(new String[messages.size()]);
                    Component cmp = null;
                    String title = "\u74b0\u5883\u8a2d\u5b9a";
                    JOptionPane.showMessageDialog(cmp, msg, GlobalConstants.getFrameTitle(title), 1);
                }
            }
        }
    }

    class ExitAdapter
    implements Application.ExitListener {
        ExitAdapter() {
        }

        public boolean canExit(EventObject e) {
            return Dolphin.this.canProcessExit();
        }

        public void willExit(EventObject event) {
            Dolphin.this.processExit();
        }
    }
}

