/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.IDocumentViewer;
import open.dolphin.client.LetterReplyView;
import open.dolphin.client.PDFReplyMaker;
import open.dolphin.client.PrintablePanel;
import open.dolphin.delegater.remote.RemoteDocumentDelegater;
import open.dolphin.helper.DBTask;
import open.dolphin.helper.IChartCommandAccepter;
import open.dolphin.infomodel.DocInfoModel;
import open.dolphin.infomodel.LetterModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.TouTouReply;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;

public class LetterReplyViewer
extends PrintablePanel
implements IDocumentViewer,
IChartDocument,
IChartCommandAccepter {
    private StateMgr stateMgr;
    private LetterReplyView view;
    private TouTouReply model;
    private static final String[] CHART_MENUS = new String[]{"openKarte", "save", "direction", "delete", "print", "modifyKarte", "ascending", "descending", "showModified", "showUnsend", "showSend", "showNewest", "insertText", "insertSchema", "insertStamp", "selectInsurance", "cut", "copy", "paste", "undo", "redo"};
    private IChart parent;
    private String title;
    private boolean dirty;

    public LetterReplyViewer(IChart parent) {
        this.parent = parent;
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.LetterReplyViewer;
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        switch (command) {
            case save: {
                return this.save();
            }
            case print: {
                return this.print();
            }
        }
        return false;
    }

    @Override
    public void start() {
        this.stateMgr = new StateMgr();
        this.enter();
    }

    @Override
    public void stop() {
    }

    @Override
    public void enter() {
        this.parent.getStatusPanel().setMessage("");
        this.getParentContext().getChartMediator().setAccepter(this);
        this.disableMenus();
        this.getParentContext().enabledAction("newKarte", true);
        this.getParentContext().enabledAction("newDocument", true);
        this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
        this.stateMgr.enter();
    }

    private boolean print() {
        if (this.model == null) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("PDF\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210\u3057\u307e\u3059\u304b?");
        int option = JOptionPane.showOptionDialog(this.getParentContext().getFrame(), sb.toString(), GlobalConstants.getFrameTitle("\u7d39\u4ecb\u60a3\u8005\u7d4c\u904e\u5831\u544a\u5370\u5237"), -1, 1, null, new String[]{"PDF\u4f5c\u6210", "\u30d5\u30a9\u30fc\u30e0\u5370\u5237", "\u53d6\u6d88\u3057"}, "PDF\u4f5c\u6210");
        if (option == 0) {
            this.makePDF();
        } else if (option == 1) {
            PageFormat pageFormat = this.getParentContext().getContext().getPageFormat();
            String name = this.getParentContext().getPatient().getFullName();
            LetterReplyView panel = this.view;
            panel.printPanel(pageFormat, 1, false, name, 0);
        }
        return true;
    }

    public void makePDF() {
        if (this.model == null) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                PDFReplyMaker pdf = new PDFReplyMaker();
                String pdfDir = GlobalVariables.getPreferences().get("pdfStore", System.getProperty("user.dir"));
                pdf.setDocumentDir(pdfDir);
                pdf.setModel(LetterReplyViewer.this.model);
                final boolean result = pdf.create();
                final String fileName = pdf.getFileName();
                final String dir = pdf.getDocumentDir();
                Runnable awt = new Runnable(){

                    @Override
                    public void run() {
                        if (result) {
                            StringBuilder sb = new StringBuilder();
                            sb.append(fileName);
                            sb.append("\u3092");
                            sb.append(System.getProperty("line.separator"));
                            sb.append(dir);
                            sb.append("\u306b\u4fdd\u5b58\u3057\u307e\u3057\u305f\u3002");
                            sb.append(System.getProperty("line.separator"));
                            sb.append("PDF \u30d3\u30e5\u30ef\u30fc\u3092\u8d77\u52d5\u3057\u5370\u5237\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                            JOptionPane.showMessageDialog(LetterReplyViewer.this.getParentContext().getFrame(), sb.toString(), GlobalConstants.getFrameTitle("\u7d39\u4ecb\u72b6\u4f5c\u6210"), 1);
                        } else {
                            JOptionPane.showMessageDialog(LetterReplyViewer.this.getParentContext().getFrame(), "\u7d39\u4ecb\u72b6PDF\u30d5\u30a1\u30a4\u30eb\u3092\u751f\u6210\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002", GlobalConstants.getFrameTitle("\u7d39\u4ecb\u72b6\u4f5c\u6210"), 2);
                        }
                    }
                };
                EventQueue.invokeLater(awt);
            }
        };
        Thread t = new Thread(r);
        t.setPriority(5);
        t.start();
    }

    @Override
    public void historyPeriodChanged() {
        this.stateMgr.processEmptyEvent();
    }

    @Override
    public void showDocuments(DocInfoModel[] docs, JScrollPane scroller) {
        if (docs == null || docs.length == 0) {
            this.stateMgr.processEmptyEvent();
            return;
        }
        DocInfoModel docInfo = docs[0];
        long pk = docInfo.getDocPk();
        if (pk == 0L) {
            return;
        }
        LetterGetTask task = new LetterGetTask(this.getParentContext(), pk, scroller);
        task.execute();
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    private boolean save() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isReadOnly() {
        return this.parent.isReadOnly();
    }

    public void disableMenus() {
        ChartMediator mediator = this.getParentContext().getChartMediator();
        mediator.disableMenus(CHART_MENUS);
    }

    protected void warning(String title, String message) {
        Window parent = SwingUtilities.getWindowAncestor(this);
        JOptionPane.showMessageDialog(parent, message, GlobalConstants.getFrameTitle(title), 2);
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    @Override
    public boolean update(Object o) {
        return true;
    }

    protected final class StateMgr {
        private LetterState emptyState;
        private LetterState cleanState;
        private LetterState currentState;

        public StateMgr() {
            this.emptyState = new EmptyState();
            this.cleanState = new ClaenState();
            this.currentState = this.emptyState;
        }

        public void processEmptyEvent() {
            this.currentState = this.emptyState;
            this.enter();
        }

        public void processCleanEvent() {
            this.currentState = this.cleanState;
            this.enter();
        }

        public void enter() {
            this.currentState.enter();
        }
    }

    protected final class ClaenState
    extends LetterState {
        @Override
        public void enter() {
            boolean canEdit = !LetterReplyViewer.this.isReadOnly();
            LetterReplyViewer.this.getParentContext().enabledAction("newKarte", canEdit);
            LetterReplyViewer.this.getParentContext().enabledAction("newDocument", canEdit);
            LetterReplyViewer.this.getParentContext().enabledAction("modifyKarte", false);
            LetterReplyViewer.this.getParentContext().enabledAction("delete", false);
            LetterReplyViewer.this.getParentContext().enabledAction("print", true);
            LetterReplyViewer.this.getParentContext().enabledAction("direction", true);
            LetterReplyViewer.this.getParentContext().enabledAction("ascending", false);
            LetterReplyViewer.this.getParentContext().enabledAction("descending", false);
            LetterReplyViewer.this.getParentContext().enabledAction("showModified", false);
            LetterReplyViewer.this.getParentContext().enabledAction("showUnsend", false);
            LetterReplyViewer.this.getParentContext().enabledAction("showSend", false);
            LetterReplyViewer.this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
        }
    }

    protected final class EmptyState
    extends LetterState {
        @Override
        public void enter() {
            boolean canEdit = !LetterReplyViewer.this.isReadOnly();
            LetterReplyViewer.this.getParentContext().enabledAction("newKarte", true);
            LetterReplyViewer.this.getParentContext().enabledAction("newDocument", true);
            LetterReplyViewer.this.getParentContext().enabledAction("modifyKarte", false);
            LetterReplyViewer.this.getParentContext().enabledAction("delete", false);
            LetterReplyViewer.this.getParentContext().enabledAction("print", false);
            LetterReplyViewer.this.getParentContext().enabledAction("direction", false);
            LetterReplyViewer.this.getParentContext().enabledAction("ascending", false);
            LetterReplyViewer.this.getParentContext().enabledAction("descending", false);
            LetterReplyViewer.this.getParentContext().enabledAction("showModified", false);
            LetterReplyViewer.this.getParentContext().enabledAction("showUnsend", false);
            LetterReplyViewer.this.getParentContext().enabledAction("showSend", false);
            LetterReplyViewer.this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
        }
    }

    protected abstract class LetterState {
        public abstract void enter();
    }

    class LetterGetTask
    extends DBTask<LetterModel> {
        private long letterPk;
        private JScrollPane scroller;

        public LetterGetTask(IChart app, long letterPk, JScrollPane scroller) {
            super(app);
            this.letterPk = letterPk;
            this.scroller = scroller;
        }

        @Override
        protected LetterModel doInBackground() throws Exception {
            RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
            LetterModel letter = ddl.getLetterReply(this.letterPk);
            if (!ddl.isError()) {
                return letter;
            }
            return null;
        }

        @Override
        protected void succeeded(LetterModel letter) {
            if (letter != null) {
                LetterReplyViewer.this.model = (TouTouReply)letter;
                LetterReplyViewer.this.view = new LetterReplyView();
                LetterReplyViewer.this.view.getConfirmed().setText(ModelUtils.getDateAsString(LetterReplyViewer.this.model.getConfirmed()));
                LetterReplyViewer.this.view.getClientHospital().setText(LetterReplyViewer.this.model.getClientHospital());
                LetterReplyViewer.this.view.getClientDept().setText(LetterReplyViewer.this.model.getClientDept());
                LetterReplyViewer.this.view.getClientDoctor().setText(LetterReplyViewer.this.model.getClientDoctor());
                LetterReplyViewer.this.view.getVisited().setText(LetterReplyViewer.this.model.getVisited());
                LetterReplyViewer.this.view.getPatientName().setText(LetterReplyViewer.this.model.getPatientName());
                LetterReplyViewer.this.view.getPatientBirthday().setText(LetterReplyViewer.this.model.getPatientBirthday());
                LetterReplyViewer.this.view.getInformedContent().setText(LetterReplyViewer.this.model.getInformedContent());
                LetterReplyViewer.this.view.getClientHospital().setEditable(false);
                LetterReplyViewer.this.view.getClientDept().setEditable(false);
                LetterReplyViewer.this.view.getClientDoctor().setEditable(false);
                LetterReplyViewer.this.view.getVisited().setEditable(false);
                LetterReplyViewer.this.view.getInformedContent().setEditable(false);
                this.scroller.setViewportView(LetterReplyViewer.this.view);
                LetterReplyViewer.this.stateMgr.processCleanEvent();
            }
        }
    }
}

