/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;

public class TaskTimerMonitor
implements PropertyChangeListener,
ActionListener {
    private Task task;
    private TaskMonitor taskMonitor;
    private ProgressMonitor monitor;
    private Timer timer;
    private int current = 0;
    private int max;

    public TaskTimerMonitor(Task task, TaskMonitor taskMonitor, Component c, Object message, String note, int delay, int maxEsitimation) {
        this.task = task;
        this.taskMonitor = taskMonitor;
        this.max = maxEsitimation / delay;
        this.monitor = new ProgressMonitor(c, message, note, 0, this.max);
        this.timer = new Timer(delay, this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("started".equals(propertyName)) {
            if (!this.timer.isRunning()) {
                this.timer.start();
            }
        } else if ("done".equals(propertyName)) {
            this.timer.stop();
            this.monitor.close();
            this.taskMonitor.removePropertyChangeListener((PropertyChangeListener)this);
        } else if ("message".equals(propertyName)) {
            String text = (String)e.getNewValue();
        } else if ("progress".equals(propertyName)) {
            int value = (Integer)e.getNewValue();
            this.monitor.setProgress(value);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.monitor.isCanceled()) {
            this.task.cancel(true);
        } else if (this.current > this.max) {
            this.task.cancel(true);
        } else {
            this.monitor.setProgress(this.current++);
        }
    }
}

