/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.stamp;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import open.dolphin.client.IStampEditorDialog;
import open.dolphin.client.editor.stamp.StampModelEditor;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.delegater.remote.RemoteStampDelegater;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.StampModel;
import open.dolphin.order.LBaseChargeStampEditor;
import open.dolphin.order.LDiagnosisEditor;
import open.dolphin.order.LGeneralStampEditor;
import open.dolphin.order.LInjectionStampEditor;
import open.dolphin.order.LInstractionChargeStampEditor;
import open.dolphin.order.LOtherStampEditor;
import open.dolphin.order.LPharmaceuticalsStampEditor;
import open.dolphin.order.LPhysiologyStampEditor;
import open.dolphin.order.LRadiologyStampEditor;
import open.dolphin.order.LStayOnHomeChargeStampEditor;
import open.dolphin.order.LSurgeryStampEditor;
import open.dolphin.order.LTestStampEditor;
import open.dolphin.order.LTreatmentStampEditor;
import open.dolphin.order.MasterSetPanel;
import open.dolphin.project.GlobalConstants;

public class EditorSetPanel
extends JPanel
implements IStampEditorDialog,
PropertyChangeListener,
TreeSelectionListener {
    private LBaseChargeStampEditor baseChargeStampEditor;
    private LDiagnosisEditor diagnosisStampEditor;
    private LGeneralStampEditor generalStampEditor;
    private LInjectionStampEditor injectionStampEditor;
    private LInstractionChargeStampEditor instractionStampEditor;
    private LStayOnHomeChargeStampEditor stayOnHomeChargeStampEditor;
    private LPharmaceuticalsStampEditor medStampEditor;
    private LOtherStampEditor otherStampEditor;
    private LPhysiologyStampEditor physiologyStampEditor;
    private LRadiologyStampEditor radiologyStampEditor;
    private LSurgeryStampEditor surgeryStampEditor;
    private LTestStampEditor testStampEditor;
    private LTreatmentStampEditor treatmentStampEditor;
    private MasterSetPanel masterSet;
    private StampModelEditor currentEditor;
    private CardLayout cardLayout;
    private Map<String, StampModelEditor> editors;
    private PropertyChangeSupport boundSupport = new PropertyChangeSupport(this);
    private Object editorValue;
    private StampTreeNode selectedNode;
    private JPanel btnPanel;
    private JPanel center;
    private JPanel editorSet;
    private JButton stampLoadButton;
    private JButton stampSaveButton;

    public EditorSetPanel() {
        this.initComponents();
        this.cardLayout = new CardLayout();
        this.editorSet.setLayout(this.cardLayout);
        this.initCustomComponents();
    }

    private void initComponents() {
        this.stampSaveButton = new JButton();
        this.stampLoadButton = new JButton();
        this.editorSet = new JPanel();
        this.center = new JPanel();
        this.btnPanel = new JPanel();
        this.stampSaveButton.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/right.png")));
        this.stampSaveButton.setEnabled(false);
        this.stampSaveButton.setName("stampSaveButton");
        this.stampSaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorSetPanel.this.stampSaveButtonActionPerformed(evt);
            }
        });
        this.stampLoadButton.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/left.png")));
        this.stampLoadButton.setEnabled(false);
        this.stampLoadButton.setName("stampLoadButton");
        this.stampLoadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorSetPanel.this.stampLoadButtonActionPerformed(evt);
            }
        });
        this.editorSet.setName("editorSet");
        GroupLayout editorSetLayout = new GroupLayout(this.editorSet);
        this.editorSet.setLayout(editorSetLayout);
        editorSetLayout.setHorizontalGroup(editorSetLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        editorSetLayout.setVerticalGroup(editorSetLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 0));
        this.setPreferredSize(new Dimension(700, 690));
        this.setLayout(new BorderLayout());
        this.center.setName("center");
        this.center.setLayout(new BorderLayout());
        this.add((Component)this.center, "Center");
        this.btnPanel.setName("btnPanel");
        this.btnPanel.setLayout(new BoxLayout(this.btnPanel, 1));
        this.add((Component)this.btnPanel, "East");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stampSaveButtonActionPerformed(ActionEvent evt) {
        Cursor currentCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        try {
            this.saveStamp();
        }
        finally {
            this.setCursor(currentCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stampLoadButtonActionPerformed(ActionEvent evt) {
        Cursor currentCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        try {
            this.loadStamp();
        }
        finally {
            this.setCursor(currentCursor);
        }
    }

    private void saveStamp() {
        this.setEditorValue(this.currentEditor.getValue());
        this.clear();
        this.stampSaveButton.setEnabled(false);
    }

    private void loadStamp() {
        StampTreeNode node = this.getSelectedNode();
        if (node == null || !(node.getUserObject() instanceof ModuleInfoBean)) {
            return;
        }
        ModuleInfoBean stampInfo = (ModuleInfoBean)node.getUserObject();
        RemoteStampDelegater sdl = new RemoteStampDelegater();
        StampModel result = sdl.getStamp(stampInfo.getStampId());
        if (!sdl.isError() && result != null) {
            IInfoModel model;
            if (result != null && (model = result.toInfoModel()) != null) {
                ModuleModel stamp = new ModuleModel();
                stamp.setModel(model);
                stamp.setModuleInfo(stampInfo);
                if (this.currentEditor != null) {
                    this.currentEditor.setValue(stamp);
                }
            }
        } else {
            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this.editorSet), "\u30b9\u30bf\u30f3\u30d7\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f.", GlobalConstants.getFrameTitle("Stamp\u53d6\u5f97"), 2);
        }
    }

    public Object getEditorValue() {
        return this.editorValue;
    }

    public void setEditorValue(Object value) {
        this.editorValue = value;
        this.boundSupport.firePropertyChange("editorValueProp", null, this.editorValue);
        this.currentEditor.setValue(null);
    }

    public StampTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(StampTreeNode node) {
        this.selectedNode = node;
    }

    @Override
    public void close() {
        if (this.currentEditor != null) {
            this.currentEditor.dispose();
        }
        this.masterSet.dispose();
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener listener) {
        this.boundSupport.addPropertyChangeListener(prop, listener);
    }

    public void remopvePropertyChangeListener(String prop, PropertyChangeListener listener) {
        this.boundSupport.removePropertyChangeListener(prop, listener);
    }

    public void show(String entity) {
        if (this.currentEditor != null) {
            this.currentEditor.dispose();
            this.currentEditor.removePropertyChangeListener("validData", this);
            this.stampSaveButton.setEnabled(false);
            this.stampLoadButton.setEnabled(false);
        }
        this.currentEditor = this.editors.get(entity);
        this.currentEditor.addPropertyChangeListener("validData", this);
        this.currentEditor.start();
        if (entity.equals("diagnosis")) {
            this.stampLoadButton.setEnabled(false);
            this.currentEditor.setValue(null);
        } else {
            ModuleModel stamp = new ModuleModel();
            ModuleInfoBean stampInfo = new ModuleInfoBean();
            stampInfo.initialize(null, "\u30a8\u30c7\u30a3\u30bf\u304b\u3089\u767a\u884c", null, entity, "p");
            stamp.setModuleInfo(stampInfo);
            this.currentEditor.setValue(stamp);
        }
        if (this.currentEditor instanceof LRadiologyStampEditor) {
            this.masterSet.setRadLocationEnabled(true);
        } else {
            this.masterSet.setRadLocationEnabled(false);
        }
        this.cardLayout.show(this.editorSet, entity);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("validData")) {
            Boolean i = (Boolean)e.getNewValue();
            this.stampSaveButton.setEnabled(i);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        ModuleInfoBean info;
        StampTree tree = (StampTree)e.getSource();
        StampTreeNode node = (StampTreeNode)tree.getLastSelectedPathComponent();
        boolean enabled = false;
        StampTreeNode selected = null;
        if (node != null && node.isLeaf() && (info = (ModuleInfoBean)node.getUserObject()).isSerialized() && !info.getEntity().equals("diagnosis")) {
            enabled = true;
            selected = node;
        }
        this.stampLoadButton.setEnabled(enabled);
        this.setSelectedNode(selected);
    }

    @Override
    public JButton getOkButton() {
        return null;
    }

    public void clear() {
        if (this.baseChargeStampEditor != null) {
            this.baseChargeStampEditor.clear();
        }
        if (this.diagnosisStampEditor != null) {
            this.diagnosisStampEditor.clear();
        }
        if (this.generalStampEditor != null) {
            this.generalStampEditor.clear();
        }
        if (this.injectionStampEditor != null) {
            this.injectionStampEditor.clear();
        }
        if (this.instractionStampEditor != null) {
            this.instractionStampEditor.clear();
        }
        if (this.stayOnHomeChargeStampEditor != null) {
            this.stayOnHomeChargeStampEditor.clear();
        }
        if (this.medStampEditor != null) {
            this.medStampEditor.clear();
        }
        if (this.otherStampEditor != null) {
            this.otherStampEditor.clear();
        }
        if (this.physiologyStampEditor != null) {
            this.physiologyStampEditor.clear();
        }
        if (this.radiologyStampEditor != null) {
            this.radiologyStampEditor.clear();
        }
        if (this.surgeryStampEditor != null) {
            this.surgeryStampEditor.clear();
        }
        if (this.testStampEditor != null) {
            this.testStampEditor.clear();
        }
        if (this.treatmentStampEditor != null) {
            this.treatmentStampEditor.clear();
        }
        this.masterSet.clear();
    }

    private void initCustomComponents() {
        this.masterSet = new MasterSetPanel();
        this.baseChargeStampEditor = new LBaseChargeStampEditor(this, this.masterSet);
        this.diagnosisStampEditor = new LDiagnosisEditor(this, this.masterSet);
        this.generalStampEditor = new LGeneralStampEditor(this, this.masterSet);
        this.injectionStampEditor = new LInjectionStampEditor(this, this.masterSet);
        this.instractionStampEditor = new LInstractionChargeStampEditor(this, this.masterSet);
        this.stayOnHomeChargeStampEditor = new LStayOnHomeChargeStampEditor(this, this.masterSet);
        this.medStampEditor = new LPharmaceuticalsStampEditor(this, this.masterSet);
        this.otherStampEditor = new LOtherStampEditor(this, this.masterSet);
        this.physiologyStampEditor = new LPhysiologyStampEditor(this, this.masterSet);
        this.radiologyStampEditor = new LRadiologyStampEditor(this, this.masterSet);
        this.surgeryStampEditor = new LSurgeryStampEditor(this, this.masterSet);
        this.testStampEditor = new LTestStampEditor(this, this.masterSet);
        this.treatmentStampEditor = new LTreatmentStampEditor(this, this.masterSet);
        this.editorSet.add((Component)this.baseChargeStampEditor, "baseChargeOrder");
        this.editorSet.add((Component)this.diagnosisStampEditor, "diagnosis");
        this.editorSet.add((Component)this.generalStampEditor, "generalOrder");
        this.editorSet.add((Component)this.injectionStampEditor, "injectionOrder");
        this.editorSet.add((Component)this.instractionStampEditor, "instractionChargeOrder");
        this.editorSet.add((Component)this.stayOnHomeChargeStampEditor, "stayOnHomeChargeOrder");
        this.editorSet.add((Component)this.medStampEditor, "medOrder");
        this.editorSet.add((Component)this.otherStampEditor, "otherOrder");
        this.editorSet.add((Component)this.physiologyStampEditor, "physiologyOrder");
        this.editorSet.add((Component)this.radiologyStampEditor, "radiologyOrder");
        this.editorSet.add((Component)this.surgeryStampEditor, "surgeryOrder");
        this.editorSet.add((Component)this.testStampEditor, "testOrder");
        this.editorSet.add((Component)this.treatmentStampEditor, "treatmentOrder");
        this.editorSet.setPreferredSize(new Dimension(680, 230));
        this.center.add((Component)this.editorSet, "North");
        this.center.add((Component)this.masterSet, "Center");
        this.btnPanel.add(Box.createVerticalStrut(100));
        this.btnPanel.add(this.stampSaveButton);
        this.btnPanel.add(this.stampLoadButton);
        this.btnPanel.add(Box.createVerticalGlue());
        this.editors = new HashMap<String, StampModelEditor>();
        this.editors.put("baseChargeOrder", this.baseChargeStampEditor);
        this.editors.put("diagnosis", this.diagnosisStampEditor);
        this.editors.put("generalOrder", this.generalStampEditor);
        this.editors.put("injectionOrder", this.injectionStampEditor);
        this.editors.put("instractionChargeOrder", this.instractionStampEditor);
        this.editors.put("stayOnHomeChargeOrder", this.stayOnHomeChargeStampEditor);
        this.editors.put("medOrder", this.medStampEditor);
        this.editors.put("otherOrder", this.otherStampEditor);
        this.editors.put("physiologyOrder", this.physiologyStampEditor);
        this.editors.put("radiologyOrder", this.radiologyStampEditor);
        this.editors.put("surgeryOrder", this.surgeryStampEditor);
        this.editors.put("testOrder", this.testStampEditor);
        this.editors.put("treatmentOrder", this.treatmentStampEditor);
    }
}

