/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.stamp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import open.dolphin.client.ObjectListTable;
import open.dolphin.client.TaskTimerMonitor;
import open.dolphin.client.editor.stamp.StampBoxFrame;
import open.dolphin.delegater.remote.RemoteStampDelegater;
import open.dolphin.helper.ComponentMemory;
import open.dolphin.helper.SynchronizedTask;
import open.dolphin.infomodel.PublishedTreeModel;
import open.dolphin.infomodel.SubscribedTreeModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.table.ObjectReflectTableModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;

public class StampImporter {
    private static final String[] COLUMN_NAMES = new String[]{"\u540d  \u79f0", "\u30ab\u30c6\u30b4\u30ea", "\u516c\u958b\u8005", "\u8aac  \u660e", "\u516c\u958b\u5148", "\u30a4\u30f3\u30dd\u30fc\u30c8"};
    private static final String[] METHOD_NAMES = new String[]{"getName", "getCategory", "getPartyName", "getDescription", "getPublishType", "isImported"};
    private static final Class[] CLASSES = new Class[]{String.class, String.class, String.class, String.class, String.class, Boolean.class};
    private static final int[] COLUMN_WIDTH = new int[]{120, 90, 170, 270, 40, 40};
    private static final Color ODD_COLOR = GlobalSettings.getColors(GlobalSettings.Parts.ODD);
    private static final Color EVEN_COLOR = GlobalSettings.getColors(GlobalSettings.Parts.EVEN);
    private static final ImageIcon WEB_ICON = GlobalConstants.getImageIcon("web_16.gif");
    private static final ImageIcon HOME_ICON = GlobalConstants.getImageIcon("home_16.gif");
    private static final ImageIcon FLAG_ICON = GlobalConstants.getImageIcon("flag_16.gif");
    private static final int WIDTH = 780;
    private static final int HEIGHT = 380;
    private String title = "\u30b9\u30bf\u30f3\u30d7\u30a4\u30f3\u30dd\u30fc\u30c8";
    private JFrame frame;
    private ObjectListTable browseTable;
    private JButton importBtn;
    private JButton deleteBtn;
    private JButton cancelBtn;
    private JLabel publicLabel;
    private JLabel localLabel;
    private JLabel importedLabel;
    private StampBoxFrame stampBox;
    private List<Long> importedTreeList;
    private RemoteStampDelegater sdl;
    private ApplicationContext appCtx;
    private Application app;

    public StampImporter(StampBoxFrame stampBox) {
        this.stampBox = stampBox;
        this.importedTreeList = stampBox.getImportedTreeList();
        this.appCtx = GlobalConstants.getApplicationContext();
        this.app = this.appCtx.getApplication();
    }

    public void start() {
        this.sdl = new RemoteStampDelegater();
        SynchronizedTask<List<PublishedTreeModel>, Void> task = new SynchronizedTask<List<PublishedTreeModel>, Void>(this.app){

            @Override
            protected List<PublishedTreeModel> doInBackground() {
                List<PublishedTreeModel> result = StampImporter.this.sdl.getPublishedTrees();
                return result;
            }

            @Override
            protected void succeeded(List<PublishedTreeModel> result) {
                if (!StampImporter.this.sdl.isError() && result != null) {
                    StampImporter.this.initCustomComponents();
                    if (StampImporter.this.importedTreeList != null && StampImporter.this.importedTreeList.size() > 0) {
                        block0: for (PublishedTreeModel publishedTreeModel : result) {
                            for (Long id : StampImporter.this.importedTreeList) {
                                if (id.longValue() != publishedTreeModel.getId()) continue;
                                publishedTreeModel.setImported(true);
                                continue block0;
                            }
                        }
                    }
                    StampImporter.this.browseTable.setObjectList(result);
                } else {
                    JOptionPane.showMessageDialog(StampImporter.this.frame, "\u516c\u958b\u30b9\u30bf\u30f3\u30d7\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f.", GlobalConstants.getFrameTitle(StampImporter.this.title), 2);
                }
            }

            @Override
            protected void cancelled() {
            }

            @Override
            protected void failed(Throwable cause) {
            }

            @Override
            protected void interrupted(InterruptedException e) {
            }
        };
        task.execute();
    }

    public void initCustomComponents() {
        this.frame = new JFrame(GlobalConstants.getFrameTitle(this.title));
        ImageIcon icon = GlobalConstants.getImageIcon("web_32.gif");
        this.frame.setIconImage(icon.getImage());
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StampImporter.this.stop();
            }
        });
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int n = GlobalConstants.isMac() ? 3 : 2;
        int x = (screen.width - 780) / 2;
        int y = (screen.height - 380) / n;
        ComponentMemory cm = new ComponentMemory(this.frame, new Point(x, y), new Dimension(new Dimension(780, 380)), this);
        cm.setToPreferenceBounds();
        JPanel contentPane = this.createBrowsePane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        contentPane.setOpaque(true);
        this.frame.setContentPane(contentPane);
        this.frame.setVisible(true);
    }

    public void stop() {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    private JPanel createBrowsePane() {
        JPanel browsePane = new JPanel();
        this.browseTable = new ObjectListTable(COLUMN_NAMES, 10, METHOD_NAMES, CLASSES);
        this.browseTable.setColumnWidth(COLUMN_WIDTH);
        this.importBtn = new JButton("\u30a4\u30f3\u30dd\u30fc\u30c8");
        this.importBtn.setEnabled(false);
        this.cancelBtn = new JButton("\u9589\u3058\u308b");
        this.deleteBtn = new JButton("\u524a\u9664");
        this.deleteBtn.setEnabled(false);
        this.publicLabel = new JLabel("\u30b0\u30ed\u30fc\u30d0\u30eb", WEB_ICON, 0);
        this.localLabel = new JLabel("\u9662\u5185", HOME_ICON, 0);
        this.importedLabel = new JLabel("\u30a4\u30f3\u30dd\u30fc\u30c8\u6e08", FLAG_ICON, 0);
        browsePane.setLayout(new BorderLayout(0, 17));
        JPanel flagPanel = new JPanel(new FlowLayout(2, 7, 5));
        flagPanel.add(this.localLabel);
        flagPanel.add(this.publicLabel);
        flagPanel.add(this.importedLabel);
        JPanel cmdPanel = new JPanel();
        cmdPanel.setLayout(new BoxLayout(cmdPanel, 0));
        cmdPanel.add(Box.createHorizontalGlue());
        cmdPanel.add(this.cancelBtn);
        cmdPanel.add(Box.createHorizontalStrut(5));
        cmdPanel.add(this.deleteBtn);
        cmdPanel.add(Box.createHorizontalStrut(5));
        cmdPanel.add(this.importBtn);
        browsePane.add((Component)flagPanel, "North");
        browsePane.add((Component)this.browseTable.getScroller(), "Center");
        browsePane.add((Component)cmdPanel, "South");
        PublishTypeRenderer pubTypeRenderer = new PublishTypeRenderer();
        this.browseTable.getColumnModel().getColumn(4).setCellRenderer(pubTypeRenderer);
        ImportedRenderer importedRenderer = new ImportedRenderer();
        this.browseTable.getColumnModel().getColumn(5).setCellRenderer(importedRenderer);
        this.browseTable.setSelectionMode(0);
        PropertyChangeListener pl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Object[] selected = (Object[])e.getNewValue();
                if (selected != null && selected.length > 0) {
                    PublishedTreeModel model = (PublishedTreeModel)selected[0];
                    if (model.isImported()) {
                        StampImporter.this.importBtn.setEnabled(false);
                        StampImporter.this.deleteBtn.setEnabled(true);
                    } else {
                        StampImporter.this.importBtn.setEnabled(true);
                        StampImporter.this.deleteBtn.setEnabled(false);
                    }
                } else {
                    StampImporter.this.importBtn.setEnabled(false);
                    StampImporter.this.deleteBtn.setEnabled(false);
                }
            }
        };
        this.browseTable.addPropertyChangeListener("selectedObjects", pl);
        this.importBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StampImporter.this.importPublishedTree();
            }
        });
        this.deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StampImporter.this.removeImportedTree();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StampImporter.this.stop();
            }
        });
        return browsePane;
    }

    public void importPublishedTree() {
        Object[] objects = this.browseTable.getSelectedObject();
        if (objects == null || objects.length == 0) {
            return;
        }
        final PublishedTreeModel importTree = (PublishedTreeModel)objects[0];
        SubscribedTreeModel sm = new SubscribedTreeModel();
        sm.setUser(GlobalVariables.getUserModel());
        sm.setTreeId(importTree.getId());
        final ArrayList<SubscribedTreeModel> subscribeList = new ArrayList<SubscribedTreeModel>(1);
        subscribeList.add(sm);
        this.sdl = new RemoteStampDelegater();
        int delay = 200;
        int maxEstimation = 60000;
        String mmsg = "\u516c\u958b\u30b9\u30bf\u30f3\u30d7\u3092\u30a4\u30f3\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u3059...";
        Task<Boolean, Void> task = new Task<Boolean, Void>(this.app){

            protected Boolean doInBackground() {
                StampImporter.this.sdl.subscribeTrees(subscribeList);
                return !StampImporter.this.sdl.isError();
            }

            protected void succeeded(Boolean result) {
                if (result.booleanValue()) {
                    StampImporter.this.stampBox.importPublishedTree(importTree);
                    importTree.setImported(true);
                    ((ObjectReflectTableModel)StampImporter.this.browseTable.getModel()).fireTableDataChanged();
                    StampImporter.this.stop();
                } else {
                    JOptionPane.showMessageDialog(StampImporter.this.frame, "\u30b9\u30bf\u30f3\u30d7\u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f.", GlobalConstants.getFrameTitle(StampImporter.this.title), 2);
                    StampImporter.this.stop();
                }
            }

            protected void cancelled() {
            }

            protected void failed(Throwable cause) {
                LogWriter.error(((Object)((Object)this)).getClass(), cause.getMessage());
            }

            protected void interrupted(InterruptedException e) {
                LogWriter.error(((Object)((Object)this)).getClass(), e.getMessage());
            }
        };
        TaskMonitor taskMonitor = this.appCtx.getTaskMonitor();
        String message = "\u30b9\u30bf\u30f3\u30d7\u53d6\u308a\u8fbc\u307f";
        JFrame c = this.frame;
        TaskTimerMonitor w = new TaskTimerMonitor((Task)task, taskMonitor, c, message, mmsg, delay, maxEstimation);
        taskMonitor.addPropertyChangeListener((PropertyChangeListener)w);
        this.appCtx.getTaskService().execute((Task)task);
    }

    public void removeImportedTree() {
        Object[] objects = this.browseTable.getSelectedObject();
        if (objects == null || objects.length == 0) {
            return;
        }
        final PublishedTreeModel removeTree = (PublishedTreeModel)objects[0];
        SubscribedTreeModel sm = new SubscribedTreeModel();
        sm.setTreeId(removeTree.getId());
        sm.setUser(GlobalVariables.getUserModel());
        final ArrayList<SubscribedTreeModel> list = new ArrayList<SubscribedTreeModel>(1);
        list.add(sm);
        this.sdl = new RemoteStampDelegater();
        int delay = 200;
        int maxEstimation = 60000;
        String mmsg = "\u30a4\u30f3\u30dd\u30fc\u30c8\u6e08\u307f\u30b9\u30bf\u30f3\u30d7\u3092\u524a\u9664\u3057\u3066\u3044\u307e\u3059...";
        Task<Boolean, Void> task = new Task<Boolean, Void>(this.app){

            protected Boolean doInBackground() throws Exception {
                StampImporter.this.sdl.unsubscribeTrees(list);
                return !StampImporter.this.sdl.isError();
            }

            protected void succeeded(Boolean result) {
                if (result.booleanValue()) {
                    StampImporter.this.stampBox.removeImportedTree(removeTree.getId());
                    StampImporter.this.stampBox.getFrame().repaint();
                    removeTree.setImported(false);
                    ((ObjectReflectTableModel)StampImporter.this.browseTable.getModel()).fireTableDataChanged();
                    StampImporter.this.stop();
                } else {
                    LogWriter.error(((Object)((Object)this)).getClass(), StampImporter.this.sdl.getErrorMessage());
                    JOptionPane.showMessageDialog(StampImporter.this.frame, "\u30b9\u30bf\u30f3\u30d7\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f", GlobalConstants.getFrameTitle(StampImporter.this.title), 2);
                    StampImporter.this.stop();
                }
            }

            protected void cancelled() {
            }

            protected void failed(Throwable cause) {
                LogWriter.error(((Object)((Object)this)).getClass(), cause.getMessage());
            }

            protected void interrupted(InterruptedException e) {
                LogWriter.error(((Object)((Object)this)).getClass(), e.getMessage());
            }
        };
        TaskMonitor taskMonitor = this.appCtx.getTaskMonitor();
        String message = "\u30b9\u30bf\u30f3\u30d7\u53d6\u308a\u8fbc\u307f";
        JFrame c = this.frame;
        TaskTimerMonitor w = new TaskTimerMonitor((Task)task, taskMonitor, c, message, mmsg, delay, maxEstimation);
        taskMonitor.addPropertyChangeListener((PropertyChangeListener)w);
        this.appCtx.getTaskService().execute((Task)task);
    }

    class ImportedRenderer
    extends DefaultTableCellRenderer {
        public ImportedRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int col) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(table.getForeground());
                if (row % 2 == 0) {
                    this.setBackground(EVEN_COLOR);
                } else {
                    this.setBackground(ODD_COLOR);
                }
            }
            if (value != null && value instanceof Boolean) {
                Boolean imported = (Boolean)value;
                if (imported.booleanValue()) {
                    this.setIcon(FLAG_ICON);
                } else {
                    this.setIcon(null);
                }
                this.setText("");
            } else {
                this.setIcon(null);
                this.setText(value == null ? "" : value.toString());
            }
            return this;
        }
    }

    class PublishTypeRenderer
    extends DefaultTableCellRenderer {
        public PublishTypeRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int col) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(table.getForeground());
                if (row % 2 == 0) {
                    this.setBackground(EVEN_COLOR);
                } else {
                    this.setBackground(ODD_COLOR);
                }
            }
            if (value != null && value instanceof String) {
                String pubType = (String)value;
                if (pubType.equals("global")) {
                    this.setIcon(WEB_ICON);
                } else {
                    this.setIcon(HOME_ICON);
                }
                this.setText("");
            } else {
                this.setIcon(null);
                this.setText(value == null ? "" : value.toString());
            }
            return this;
        }
    }
}

