/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.stamp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import open.dolphin.client.DefaultStampTreeXmlBuilder;
import open.dolphin.client.editor.stamp.StampBoxFrame;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeXmlDirector;
import open.dolphin.delegater.remote.RemoteStampDelegater;
import open.dolphin.helper.ComponentMemory;
import open.dolphin.helper.GridBagBuilder;
import open.dolphin.helper.SynchronizedTask;
import open.dolphin.infomodel.FacilityModel;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.infomodel.IStampTreeModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.StampTreeModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;

public class StampPublisher {
    private static final int TT_NONE = -1;
    private static final int TT_LOCAL = 0;
    private static final int TT_PUBLIC = 1;
    private static final int WIDTH = 845;
    private static final int HEIGHT = 477;
    private StampBoxFrame stampBox;
    private String title = "\u30b9\u30bf\u30f3\u30d7\u516c\u958b";
    private JFrame dialog;
    private JLabel infoLable;
    private JLabel instLabel;
    private JLabel publishedDate;
    private JTextField stampBoxName;
    private JTextField partyName;
    private JTextField contact;
    private JTextField description;
    private JRadioButton local;
    private JRadioButton publc;
    private JButton publish;
    private JButton cancel;
    private JButton cancelPublish;
    private JCheckBox[] entities;
    private JComboBox category;
    private int publishType = -1;
    private boolean okState;
    private RemoteStampDelegater sdl;
    private PublishedState publishState;
    private ApplicationContext appCtx;
    private Application app;

    public StampPublisher(StampBoxFrame stampBox) {
        this.stampBox = stampBox;
        this.appCtx = GlobalConstants.getApplicationContext();
        this.app = this.appCtx.getApplication();
    }

    public void start() {
        this.dialog = new JFrame(GlobalConstants.getFrameTitle(this.title));
        ImageIcon icon = GlobalConstants.getImageIcon("web_32.gif");
        this.dialog.setIconImage(icon.getImage());
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StampPublisher.this.stop();
            }
        });
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int n = GlobalConstants.isMac() ? 3 : 2;
        int x = (screen.width - 845) / 2;
        int y = (screen.height - 477) / n;
        ComponentMemory cm = new ComponentMemory(this.dialog, new Point(x, y), new Dimension(845, 477), this);
        cm.setToPreferenceBounds();
        JPanel contentPane = this.createContentPane();
        contentPane.setOpaque(true);
        this.dialog.setContentPane(contentPane);
        this.stampBox.getBlockGlass().block();
        this.dialog.setResizable(false);
        this.dialog.setVisible(true);
    }

    public void stop() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.stampBox.getBlockGlass().unblock();
    }

    private JPanel createContentPane() {
        JPanel contentPane = new JPanel();
        this.infoLable = new JLabel(GlobalConstants.getImageIcon("about_16.gif"));
        this.instLabel = new JLabel("");
        this.instLabel.setFont(new Font("Dialog", 0, 10));
        this.publishedDate = new JLabel("");
        this.stampBoxName = new JTextField();
        this.stampBoxName.setColumns(15);
        this.partyName = new JTextField();
        this.partyName.setColumns(20);
        this.contact = new JTextField();
        this.contact.setColumns(30);
        this.description = new JTextField();
        this.description.setColumns(30);
        this.local = new JRadioButton("\u9662\u5185");
        this.publc = new JRadioButton("\u30b0\u30ed\u30fc\u30d0\u30eb");
        this.publish = new JButton("");
        this.publish.setEnabled(false);
        this.cancelPublish = new JButton("\u516c\u958b\u3092\u6b62\u3081\u308b");
        this.cancelPublish.setEnabled(false);
        this.cancel = new JButton("\u30c0\u30a4\u30a2\u30ed\u30b0\u3092\u9589\u3058\u308b");
        this.entities = new JCheckBox[IInfoModel.STAMP_NAMES.length];
        for (int i = 0; i < IInfoModel.STAMP_NAMES.length; ++i) {
            this.entities[i] = new JCheckBox(IInfoModel.STAMP_NAMES[i]);
            if (!IInfoModel.STAMP_NAMES[i].equals("ORCA")) continue;
            this.entities[i].setEnabled(false);
        }
        JPanel chkPanel1 = new JPanel(new FlowLayout(0, 5, 0));
        chkPanel1.add(this.entities[0]);
        chkPanel1.add(this.entities[1]);
        chkPanel1.add(this.entities[2]);
        chkPanel1.add(this.entities[3]);
        chkPanel1.add(this.entities[4]);
        chkPanel1.add(this.entities[5]);
        chkPanel1.add(this.entities[6]);
        chkPanel1.add(this.entities[7]);
        JPanel chkPanel2 = new JPanel(new FlowLayout(0, 5, 0));
        chkPanel2.add(this.entities[8]);
        chkPanel2.add(this.entities[9]);
        chkPanel2.add(this.entities[10]);
        chkPanel2.add(this.entities[11]);
        chkPanel2.add(this.entities[12]);
        chkPanel2.add(this.entities[13]);
        chkPanel2.add(this.entities[14]);
        chkPanel2.add(this.entities[15]);
        String[] categories = new String[]{"\u533b\u85ac\u54c1", "\u30b8\u30a7\u30cd\u30ea\u30c3\u30af\u533b\u85ac\u54c1", "\u691c\u67fb", "\u5668\u6750", "\u30d1\u30b9", "\u5730\u57df\u9023\u643a", "\u8abf\u67fb", "\u6cbb\u9a13", "\u9662\u5185\u30b7\u30a7\u30a2"};
        this.category = new JComboBox<String>(categories);
        JPanel categoryPanel = new JPanel(new FlowLayout(0, 0, 0));
        categoryPanel.add(this.category);
        JPanel radioPanel = new JPanel(new FlowLayout(0, 5, 0));
        radioPanel.add(this.local);
        radioPanel.add(this.publc);
        JPanel attributePanel = new JPanel(new BorderLayout());
        GridBagBuilder gbl = new GridBagBuilder(attributePanel, "\u30b9\u30bf\u30f3\u30d7\u516c\u958b\u8a2d\u5b9a");
        int y = 0;
        gbl.add(this.infoLable, 0, y, 13);
        gbl.add(this.instLabel, 1, y, 17);
        gbl.add(new JLabel("\u516c\u958b\u30b9\u30bf\u30f3\u30d7\u30bb\u30c3\u30c8\u540d"), 0, ++y, 13);
        gbl.add(this.stampBoxName, 1, y, 17);
        gbl.add(new JLabel("\u516c\u958b\u5148"), 0, ++y, 13);
        gbl.add(radioPanel, 1, y, 17);
        gbl.add(new JLabel("\u30ab\u30c6\u30b4\u30ea"), 0, ++y, 13);
        gbl.add(categoryPanel, 1, y, 17);
        gbl.add(new JLabel("\u516c\u958b\u3059\u308b\u30b9\u30bf\u30f3\u30d7"), 0, ++y, 13);
        gbl.add(chkPanel1, 1, y, 17);
        gbl.add(new JLabel(" "), 0, ++y, 13);
        gbl.add(chkPanel2, 1, y, 17);
        gbl.add(new JLabel("\u516c\u958b\u8005\u540d"), 0, ++y, 13);
        gbl.add(this.partyName, 1, y, 17);
        gbl.add(new JLabel("URL\u7b49"), 0, ++y, 13);
        gbl.add(this.contact, 1, y, 17);
        gbl.add(new JLabel("\u5229\u7528\u8005\u3078\u306e\u8aac\u660e"), 0, ++y, 13);
        gbl.add(this.description, 1, y, 17);
        gbl.add(new JLabel("\u516c\u958b\u65e5"), 0, ++y, 13);
        gbl.add(this.publishedDate, 1, y, 17);
        JPanel cmdPanel = null;
        if (GlobalConstants.isMac()) {
            cmdPanel = new JPanel();
            cmdPanel.setLayout(new BoxLayout(cmdPanel, 0));
            cmdPanel.add(Box.createHorizontalGlue());
            cmdPanel.add(this.cancel);
            cmdPanel.add(Box.createHorizontalStrut(5));
            cmdPanel.add(this.cancelPublish);
            cmdPanel.add(Box.createHorizontalStrut(5));
            cmdPanel.add(this.publish);
        } else {
            cmdPanel = new JPanel();
            cmdPanel.setLayout(new BoxLayout(cmdPanel, 0));
            cmdPanel.add(Box.createHorizontalGlue());
            cmdPanel.add(this.publish);
            cmdPanel.add(Box.createHorizontalStrut(5));
            cmdPanel.add(this.cancelPublish);
            cmdPanel.add(Box.createHorizontalStrut(5));
            cmdPanel.add(this.cancel);
        }
        contentPane.setLayout(new BorderLayout(0, 17));
        contentPane.add((Component)attributePanel, "Center");
        contentPane.add((Component)cmdPanel, "South");
        contentPane.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        IStampTreeModel stmpTree = this.stampBox.getUserStampBox().getStampTreeModel();
        FacilityModel facility = GlobalVariables.getUserModel().getFacility();
        String facilityId = facility.getFacilityId();
        long treeId = stmpTree.getId();
        String publishTypeStr = stmpTree.getPublishType();
        if (treeId == 0L && publishTypeStr == null) {
            this.publishState = PublishedState.NONE;
        } else if (treeId != 0L && publishTypeStr == null) {
            this.publishState = PublishedState.SAVED_NONE;
        } else if (treeId != 0L && publishTypeStr != null && publishTypeStr.equals(facilityId)) {
            this.publishState = PublishedState.LOCAL;
        } else if (treeId != 0L && publishTypeStr != null && publishTypeStr.equals("global")) {
            this.publishState = PublishedState.GLOBAL;
        }
        switch (this.publishState) {
            case NONE: {
                this.instLabel.setText("\u3053\u306e\u30b9\u30bf\u30f3\u30d7\u306f\u516c\u958b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                this.partyName.setText(facility.getFacilityName());
                String url = facility.getUrl();
                if (url != null) {
                    this.contact.setText(url);
                }
                String dateStr = ModelUtils.getDateAsString(new Date());
                this.publishedDate.setText(dateStr);
                this.publish.setText("\u516c\u958b\u3059\u308b");
                break;
            }
            case SAVED_NONE: {
                this.instLabel.setText("\u3053\u306e\u30b9\u30bf\u30f3\u30d7\u306f\u516c\u958b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                this.partyName.setText(stmpTree.getPartyName());
                String url = facility.getUrl();
                if (url != null) {
                    this.contact.setText(url);
                }
                String dateStr = ModelUtils.getDateAsString(new Date());
                this.publishedDate.setText(dateStr);
                this.publish.setText("\u516c\u958b\u3059\u308b");
                break;
            }
            case LOCAL: {
                this.instLabel.setText("\u3053\u306e\u30b9\u30bf\u30f3\u30d7\u306f\u9662\u5185\u306b\u516c\u958b\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
                this.stampBoxName.setText(stmpTree.getName());
                this.local.setSelected(true);
                this.publc.setSelected(false);
                this.publishType = 0;
                String published = ((StampTreeModel)stmpTree).getPublished();
                if (published != null) {
                    StringTokenizer st = new StringTokenizer(published, ",");
                    block7: while (st.hasMoreTokens()) {
                        String entity = st.nextToken();
                        for (int i = 0; i < IInfoModel.STAMP_ENTITIES.length; ++i) {
                            if (!entity.equals(IInfoModel.STAMP_ENTITIES[i])) continue;
                            this.entities[i].setSelected(true);
                            continue block7;
                        }
                    }
                }
                this.category.setSelectedItem(stmpTree.getCategory());
                this.partyName.setText(stmpTree.getPartyName());
                this.contact.setText(stmpTree.getUrl());
                this.description.setText(stmpTree.getDescription());
                StringBuilder sb = new StringBuilder();
                sb.append(ModelUtils.getDateAsString(stmpTree.getPublishedDate()));
                sb.append("  \u6700\u7d42\u66f4\u65b0\u65e5( ");
                sb.append(ModelUtils.getDateAsString(stmpTree.getLastUpdated()));
                sb.append(" )");
                this.publishedDate.setText(sb.toString());
                this.publish.setText("\u66f4\u65b0\u3059\u308b");
                this.publish.setEnabled(true);
                this.cancelPublish.setEnabled(true);
                break;
            }
            case GLOBAL: {
                this.instLabel.setText("\u3053\u306e\u30b9\u30bf\u30f3\u30d7\u306f\u30b0\u30ed\u30fc\u30d0\u30eb\u306b\u516c\u958b\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
                this.stampBoxName.setText(stmpTree.getName());
                this.local.setSelected(false);
                this.publc.setSelected(true);
                this.category.setSelectedItem(stmpTree.getCategory());
                this.partyName.setText(stmpTree.getPartyName());
                this.contact.setText(stmpTree.getUrl());
                this.description.setText(stmpTree.getDescription());
                this.publishType = 1;
                String published = ((StampTreeModel)stmpTree).getPublished();
                if (published != null) {
                    StringTokenizer st = new StringTokenizer(published, ",");
                    block9: while (st.hasMoreTokens()) {
                        String entity = st.nextToken();
                        for (int i = 0; i < IInfoModel.STAMP_ENTITIES.length; ++i) {
                            if (!entity.equals(IInfoModel.STAMP_ENTITIES[i])) continue;
                            this.entities[i].setSelected(true);
                            continue block9;
                        }
                    }
                }
                StringBuilder sb = new StringBuilder();
                sb.append(ModelUtils.getDateAsString(stmpTree.getPublishedDate()));
                sb.append("  \u6700\u7d42\u66f4\u65b0\u65e5( ");
                sb.append(ModelUtils.getDateAsString(stmpTree.getLastUpdated()));
                sb.append(" )");
                this.publishedDate.setText(sb.toString());
                this.publish.setText("\u66f4\u65b0\u3059\u308b");
                this.publish.setEnabled(true);
                this.cancelPublish.setEnabled(true);
                break;
            }
            default: {
                LogWriter.fatal(this.getClass(), "case default");
            }
        }
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                StampPublisher.this.checkButton();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                StampPublisher.this.checkButton();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.stampBoxName.getDocument().addDocumentListener(dl);
        this.partyName.getDocument().addDocumentListener(dl);
        this.contact.getDocument().addDocumentListener(dl);
        this.description.getDocument().addDocumentListener(dl);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.local);
        bg.add(this.publc);
        PublishTypeListener pl = new PublishTypeListener();
        this.local.addActionListener(pl);
        this.publc.addActionListener(pl);
        ActionListener cbListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StampPublisher.this.checkButton();
            }
        };
        for (JCheckBox cb : this.entities) {
            cb.addActionListener(cbListener);
        }
        this.publish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StampPublisher.this.publish();
            }
        });
        this.cancelPublish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StampPublisher.this.cancelPublish();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StampPublisher.this.stop();
            }
        });
        return contentPane;
    }

    public void publish() {
        ArrayList<StampTree> publishList = new ArrayList<StampTree>(IInfoModel.STAMP_ENTITIES.length);
        StringBuilder sb = new StringBuilder();
        boolean nonSelected = true;
        for (int i = 0; i < IInfoModel.STAMP_ENTITIES.length; ++i) {
            if (!this.entities[i].isSelected()) continue;
            nonSelected = false;
            String entity = IInfoModel.STAMP_ENTITIES[i];
            StampTree st = this.stampBox.getStampTreeFromUserBox(entity);
            publishList.add(st);
            sb.append(",");
            sb.append(entity);
        }
        if (nonSelected) {
            JOptionPane.showMessageDialog(this.dialog, "\u516c\u958b\u3059\u308b\u30b9\u30bf\u30f3\u30d7\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044", GlobalConstants.getFrameTitle(this.title), 2);
            return;
        }
        String published = sb.toString();
        published = published.substring(1);
        DefaultStampTreeXmlBuilder builder = new DefaultStampTreeXmlBuilder();
        StampTreeXmlDirector director = new StampTreeXmlDirector(builder);
        String publishXml = director.build(publishList);
        byte[] bytes = null;
        try {
            bytes = publishXml.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LogWriter.error(this.getClass(), ex);
        }
        final byte[] publishBytes = bytes;
        List<StampTree> personalTree = this.stampBox.getUserStampBox().getAllTrees();
        builder = new DefaultStampTreeXmlBuilder();
        director = new StampTreeXmlDirector(builder);
        String treeXml = director.build(personalTree);
        final StampTreeModel stmpTree = (StampTreeModel)this.stampBox.getUserStampBox().getStampTreeModel();
        stmpTree.setTreeXml(treeXml);
        stmpTree.setName(this.stampBoxName.getText().trim());
        String pubType = this.publc.isSelected() ? "global" : GlobalVariables.getUserModel().getFacility().getFacilityId();
        stmpTree.setPublishType(pubType);
        stmpTree.setCategory((String)this.category.getSelectedItem());
        stmpTree.setPartyName(this.partyName.getText().trim());
        stmpTree.setUrl(this.contact.getText().trim());
        stmpTree.setDescription(this.description.getText().trim());
        stmpTree.setPublished(published);
        switch (this.publishState) {
            case NONE: 
            case SAVED_NONE: {
                Date date = new Date();
                stmpTree.setPublishedDate(date);
                stmpTree.setLastUpdated(date);
                break;
            }
            case LOCAL: 
            case GLOBAL: {
                stmpTree.setLastUpdated(new Date());
                break;
            }
            default: {
                LogWriter.fatal(this.getClass(), "case default");
            }
        }
        this.sdl = new RemoteStampDelegater();
        SynchronizedTask<Boolean, Void> task = new SynchronizedTask<Boolean, Void>(this.app){

            @Override
            protected Boolean doInBackground() throws Exception {
                switch (StampPublisher.this.publishState) {
                    case NONE: {
                        long id = StampPublisher.this.sdl.saveAndPublishTree(stmpTree, publishBytes);
                        stmpTree.setId(id);
                        break;
                    }
                    case SAVED_NONE: {
                        StampPublisher.this.sdl.publishTree(stmpTree, publishBytes);
                        break;
                    }
                    case LOCAL: {
                        StampPublisher.this.sdl.updatePublishedTree(stmpTree, publishBytes);
                        break;
                    }
                    case GLOBAL: {
                        StampPublisher.this.sdl.updatePublishedTree(stmpTree, publishBytes);
                        break;
                    }
                    default: {
                        LogWriter.fatal(this.getClass(), "case default");
                    }
                }
                return new Boolean(!StampPublisher.this.sdl.isError());
            }

            @Override
            protected void succeeded(Boolean result) {
                if (result.booleanValue()) {
                    JOptionPane.showMessageDialog(StampPublisher.this.dialog, "\u30b9\u30bf\u30f3\u30d7\u3092\u516c\u958b\u3057\u307e\u3057\u305f.", GlobalConstants.getFrameTitle(StampPublisher.this.title), 1);
                    StampPublisher.this.stop();
                } else {
                    JOptionPane.showMessageDialog(StampPublisher.this.dialog, "\u30b9\u30bf\u30f3\u30d7\u306e\u516c\u958b\u306b\u5931\u6557\u3057\u307e\u3057\u305f.", GlobalConstants.getFrameTitle(StampPublisher.this.title), 2);
                }
            }

            @Override
            protected void cancelled() {
            }

            @Override
            protected void failed(Throwable cause) {
            }

            @Override
            protected void interrupted(InterruptedException e) {
            }
        };
        task.execute();
    }

    public void cancelPublish() {
        JLabel msg1 = new JLabel("\u516c\u958b\u3092\u53d6\u308a\u6d88\u3059\u3068\u30b5\u30d6\u30b9\u30af\u30e9\u30a4\u30d6\u3057\u3066\u3044\u308b\u30e6\u30fc\u30b6\u304c\u3042\u306a\u305f\u306e");
        JLabel msg2 = new JLabel("\u30b9\u30bf\u30f3\u30d7\u3092\u4f7f\u7528\u3067\u304d\u306a\u304f\u306a\u308a\u307e\u3059\u3002\u516c\u958b\u3092\u53d6\u308a\u6d88\u3057\u307e\u3059\u304b?");
        JPanel p1 = new JPanel(new FlowLayout(0, 0, 3));
        p1.add(msg1);
        JPanel p2 = new JPanel(new FlowLayout(0, 0, 3));
        p2.add(msg2);
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 1));
        box.add(p1);
        box.add(p2);
        box.setBorder(BorderFactory.createEmptyBorder(0, 0, 11, 11));
        int option = JOptionPane.showConfirmDialog(this.dialog, new Object[]{box}, GlobalConstants.getFrameTitle(this.title), 0, 1, GlobalConstants.getImageIcon("sinfo_32.gif"));
        if (option != 0) {
            return;
        }
        List<StampTree> list = this.stampBox.getUserStampBox().getAllTrees();
        DefaultStampTreeXmlBuilder builder = new DefaultStampTreeXmlBuilder();
        StampTreeXmlDirector director = new StampTreeXmlDirector(builder);
        String treeXml = director.build(list);
        final StampTreeModel stmpTree = (StampTreeModel)this.stampBox.getUserStampBox().getStampTreeModel();
        stmpTree.setTreeXml(treeXml);
        stmpTree.setPublishType(null);
        stmpTree.setPublishedDate(null);
        stmpTree.setLastUpdated(null);
        stmpTree.setCategory(null);
        stmpTree.setName("\u500b\u4eba\u7528");
        stmpTree.setDescription("\u500b\u4eba\u7528\u306e\u30b9\u30bf\u30f3\u30d7\u30bb\u30c3\u30c8\u3067\u3059");
        this.sdl = new RemoteStampDelegater();
        SynchronizedTask<Boolean, Void> task = new SynchronizedTask<Boolean, Void>(this.app){

            @Override
            protected Boolean doInBackground() throws Exception {
                StampPublisher.this.sdl.cancelPublishedTree(stmpTree);
                return new Boolean(!StampPublisher.this.sdl.isError());
            }

            @Override
            protected void succeeded(Boolean result) {
                if (result.booleanValue()) {
                    JOptionPane.showMessageDialog(StampPublisher.this.dialog, "\u516c\u958b\u3092\u53d6\u308a\u6d88\u3057\u307e\u3057\u305f\u3002", GlobalConstants.getFrameTitle(StampPublisher.this.title), 1);
                    JTabbedPane tp = StampPublisher.this.stampBox.getParentBox();
                    for (int i = 0; i < tp.getComponentCount(); ++i) {
                        String tst = tp.getTitleAt(i);
                        String dst = StampPublisher.this.stampBoxName.getText().trim();
                        if (!dst.equals(tst)) continue;
                        tp.removeTabAt(i);
                    }
                    StampPublisher.this.stop();
                } else {
                    JOptionPane.showMessageDialog(StampPublisher.this.dialog, "\u516c\u958b\u306e\u53d6\u308a\u6d88\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f.", GlobalConstants.getFrameTitle(StampPublisher.this.title), 2);
                }
            }

            @Override
            protected void cancelled() {
            }

            @Override
            protected void failed(Throwable cause) {
            }

            @Override
            protected void interrupted(InterruptedException e) {
            }
        };
        task.execute();
    }

    public void checkButton() {
        switch (this.publishType) {
            case -1: {
                break;
            }
            case 0: {
                boolean newOk;
                boolean stampNameOk = !this.stampBoxName.getText().trim().equals("");
                boolean partyNameOk = !this.partyName.getText().trim().equals("");
                boolean descriptionOk = !this.description.getText().trim().equals("");
                boolean checkOk = false;
                for (JCheckBox cb : this.entities) {
                    if (!cb.isSelected()) continue;
                    checkOk = true;
                    break;
                }
                boolean bl = newOk = stampNameOk && partyNameOk && descriptionOk && checkOk;
                if (newOk == this.okState) break;
                this.okState = newOk;
                this.publish.setEnabled(this.okState);
                break;
            }
            case 1: {
                boolean newOk;
                boolean stampNameOk = !this.stampBoxName.getText().trim().equals("");
                boolean partyNameOk = !this.partyName.getText().trim().equals("");
                boolean urlOk = !this.contact.getText().trim().equals("");
                boolean descriptionOk = !this.description.getText().trim().equals("");
                boolean checkOk = false;
                for (JCheckBox cb : this.entities) {
                    if (!cb.isSelected()) continue;
                    checkOk = true;
                    break;
                }
                boolean bl = newOk = stampNameOk && partyNameOk && urlOk && descriptionOk && checkOk;
                if (newOk == this.okState) break;
                this.okState = newOk;
                this.publish.setEnabled(this.okState);
                break;
            }
            default: {
                LogWriter.fatal(this.getClass(), "case default");
            }
        }
    }

    class PublishTypeListener
    implements ActionListener {
        PublishTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StampPublisher.this.local.isSelected()) {
                StampPublisher.this.publishType = 0;
                StampPublisher.this.category.setSelectedIndex(8);
            } else if (StampPublisher.this.publc.isSelected()) {
                StampPublisher.this.publishType = 1;
            }
            StampPublisher.this.checkButton();
        }
    }

    public static enum PublishedState {
        NONE,
        SAVED_NONE,
        LOCAL,
        GLOBAL;

    }
}

