/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.stamp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.project.GlobalSettings;

public class StampTreePanel
extends JPanel
implements TreeSelectionListener {
    private static final long serialVersionUID = -268963413379453444L;
    protected StampTree stampTree;
    protected JTextArea infoArea;

    public StampTreePanel(StampTree tree) {
        this.initComponents();
        this.stampTree = tree;
        this.initCustomComponents();
    }

    private void initCustomComponents() {
        JScrollPane scroller = new JScrollPane(this.stampTree);
        scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        this.setLayout(new BorderLayout());
        this.add((Component)scroller, "Center");
        String treeEntity = this.stampTree.getEntity();
        if (treeEntity != null && !treeEntity.equals("text")) {
            this.infoArea = new JTextArea();
            this.infoArea.setMargin(new Insets(3, 2, 3, 2));
            this.infoArea.setLineWrap(true);
            this.infoArea.setPreferredSize(new Dimension(250, 40));
            Font font = new Font("Dialog", 0, 10);
            this.infoArea.setFont(font);
            this.add((Component)this.infoArea, "South");
            this.stampTree.addTreeSelectionListener(this);
        }
    }

    public StampTree getTree() {
        return this.stampTree;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        StampTree tree = (StampTree)e.getSource();
        StampTreeNode node = (StampTreeNode)tree.getLastSelectedPathComponent();
        if (node != null) {
            if (node.getUserObject() instanceof ModuleInfoBean) {
                ModuleInfoBean info = (ModuleInfoBean)node.getUserObject();
                this.infoArea.setText(info.getStampMemo());
            } else {
                this.infoArea.setText("");
            }
        } else {
            this.infoArea.setText("");
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

