/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.labotestimporter;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import open.dolphin.client.labotestimporter.AverageInformation;
import open.dolphin.client.labotestimporter.LaboTestInformation;
import open.dolphin.client.labotestimporter.LaboTestResultInformation;
import open.dolphin.utils.GUIDGenerator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class MmlParser {
    private static final Namespace mmlCm = Namespace.getNamespace((String)"mmlCm", (String)"http://www.medxml.net/MML/SharedComponent/Common/1.0");
    private static final Namespace mmlLb = Namespace.getNamespace((String)"mmlLb", (String)"http://www.medxml.net/MML/ContentModule/test/1.0");
    private LaboTestInformation laboTestInformation;
    private String patientId;
    private String patientIdType;
    private String patientIdTypeTableId;
    private String moduleUUID;
    private String confirmDate;

    public List<LaboTestInformation> parse(InputStream is) throws IOException, JDOMException {
        SAXBuilder docBuilder = new SAXBuilder();
        Document doc = docBuilder.build(is);
        Element root = doc.getRootElement();
        this.parseHeader(root.getChild("MmlHeader"));
        return this.parseBody(root.getChild("MmlBody"));
    }

    private void parseHeader(Element header) {
        Element masterId = header.getChild("masterId");
        Element id = masterId.getChild("Id", mmlCm);
        if (id == null) {
            return;
        }
        this.patientId = id.getTextTrim();
        this.patientIdType = id.getAttributeValue("type", mmlCm);
        this.patientIdTypeTableId = id.getAttributeValue("tableId", mmlCm);
    }

    private List<LaboTestInformation> parseBody(Element body) {
        List mmlModuleItemList = body.getChildren("MmlModuleItem");
        Iterator ite = mmlModuleItemList.iterator();
        ArrayList<LaboTestInformation> result = new ArrayList<LaboTestInformation>();
        while (ite.hasNext()) {
            Element mmlModuleItem = (Element)ite.next();
            Element docInfo = mmlModuleItem.getChild("docInfo");
            Element content = mmlModuleItem.getChild("content");
            if (!docInfo.getAttributeValue("contentModuleType").equals("test")) continue;
            this.moduleUUID = docInfo.getChild("docId").getChildTextTrim("uid");
            if (this.moduleUUID == null || this.moduleUUID.length() != 32) {
                this.moduleUUID = GUIDGenerator.generate(this);
            }
            this.confirmDate = docInfo.getChildTextTrim("confirmDate");
            if (this.confirmDate.indexOf("T") < 0) {
                this.confirmDate.concat("T00:00:00");
            }
            Element testModule = content.getChild("TestModule", mmlLb);
            result.add(this.parseTestModule(testModule));
        }
        return result;
    }

    private LaboTestInformation parseTestModule(Element testModule) {
        this.laboTestInformation = new LaboTestInformation();
        Namespace ns = testModule.getNamespace();
        Element info = testModule.getChild("information", ns);
        List laboTestList = testModule.getChildren("laboTest", ns);
        Iterator ite = laboTestList.iterator();
        while (ite.hasNext()) {
            this.parseInformation(info, ns);
            this.laboTestInformation.setPatientId(this.patientId);
            this.laboTestInformation.setPatientIdType(this.patientIdType);
            this.laboTestInformation.setPatientIdTypeTableId(this.patientIdTypeTableId);
            this.laboTestInformation.setModuleUUID(this.moduleUUID);
            this.laboTestInformation.setConfirmedDate(this.confirmDate);
            Element laboTest = (Element)ite.next();
            this.parseLaboTest(laboTest, ns);
        }
        return this.laboTestInformation;
    }

    private void parseInformation(Element information, Namespace ns) {
        this.laboTestInformation.setRegistId(information.getAttributeValue("registId", ns));
        this.laboTestInformation.setSampleTime(information.getAttributeValue("sampleTime", ns));
        this.laboTestInformation.setRegistTime(information.getAttributeValue("registTime", ns));
        this.laboTestInformation.setReportTime(information.getAttributeValue("reportTime", ns));
        Element reportStatus = information.getChild("reportStatus", ns);
        this.laboTestInformation.setReportStatus(reportStatus.getTextTrim());
        this.laboTestInformation.setReportStatusCode(reportStatus.getAttributeValue("statusCode", ns));
        this.laboTestInformation.setReportStatusCodeType(reportStatus.getAttributeValue("statusCodeId", ns));
        Element facility = information.getChild("facility", ns);
        this.laboTestInformation.setClientFacility(facility.getTextTrim());
        this.laboTestInformation.setClientFacilityCode(facility.getAttributeValue("facilityCode", ns));
        this.laboTestInformation.setClientFacilityCodeId(facility.getAttributeValue("facilityCodeId", ns));
        Element laboratoryCenter = information.getChild("laboratoryCenter", ns);
        this.laboTestInformation.setLaboratoryCenter(laboratoryCenter.getTextTrim());
        this.laboTestInformation.setLaboratoryCenterCode(laboratoryCenter.getAttributeValue("centerCode", ns));
        this.laboTestInformation.setLaboratoryCenterCodeId(laboratoryCenter.getAttributeValue("centerCodeId", ns));
    }

    private void parseLaboTest(Element laboTest, Namespace ns) {
        Element specimen = laboTest.getChild("specimen", ns);
        this.parseSpecimen(specimen, ns);
        List itemList = laboTest.getChildren("item", ns);
        for (Element item : itemList) {
            this.parseItem(item, ns);
        }
    }

    private void parseSpecimen(Element specimen, Namespace ns) {
        Element specimenName = specimen.getChild("specimenName", ns);
        this.laboTestInformation.setSpecimenName(specimenName.getTextTrim());
        this.laboTestInformation.setSpecimenCode(specimenName.getAttributeValue("spCode", ns));
        this.laboTestInformation.setSpecimenCodeId(specimenName.getAttributeValue("spCodeId", ns));
    }

    private void parseItem(Element item, Namespace ns) {
        LaboTestResultInformation laboTestResultInformation = new LaboTestResultInformation();
        this.laboTestInformation.addTestResultInformation(laboTestResultInformation);
        Element itemName = item.getChild("itemName", ns);
        laboTestResultInformation.setItemName(itemName.getTextTrim());
        laboTestResultInformation.setItemCode(itemName.getAttributeValue("itCode", ns));
        laboTestResultInformation.setItemCodeId(itemName.getAttributeValue("itCodeId", ns));
        laboTestResultInformation.setValue(item.getChildTextTrim("value", ns));
        AverageInformation averageInformation = new AverageInformation();
        this.laboTestInformation.addAverageInformation(averageInformation);
        Element numValue = item.getChild("numValue", ns);
        if (numValue != null) {
            numValue.getTextTrim();
            averageInformation.setUp(numValue.getAttributeValue("up", ns));
            averageInformation.setLow(numValue.getAttributeValue("low", ns));
            averageInformation.setNormal(numValue.getAttributeValue("normal", ns));
            averageInformation.setOut(numValue.getAttributeValue("out", ns));
            Element unit = item.getChild("unit", ns);
            averageInformation.setUnit(unit.getTextTrim());
            averageInformation.setUnitCode(unit.getAttributeValue("uCode", ns));
            averageInformation.setUnitCodeId(unit.getAttributeValue("uCodeId", ns));
        }
    }
}

