/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.settings;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import open.dolphin.client.settings.IAbstractSettingPanel;
import open.dolphin.client.settings.ProjectSettingDialog;
import open.dolphin.helper.PlugInMenuSupport;
import open.dolphin.log.LogWriter;
import open.dolphin.plugin.IPlugin;
import open.dolphin.plugin.PluginLoader;
import open.dolphin.plugin.PluginWrapper;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.utils.Adapter;

public class PluginsSettingPanel
extends JPanel
implements IAbstractSettingPanel {
    private ProjectSettingDialog context;
    private PlugInMenuSupport plugins;
    private PropertyChangeSupport boundSupport;
    protected IAbstractSettingPanel.State state = IAbstractSettingPanel.State.NONE_STATE;
    private boolean loginState;
    private String title;
    private String icon;
    private String id;
    private PluginsModel model;
    private String classPath;
    private String path;
    private String settingPath;
    private Adapter<Boolean, Boolean> adapter;
    private JTable PluginsTable;
    private JButton jButton1;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField pathField;
    private JLabel schemaF;
    private JTextField schemaField;
    private JScrollPane scroller;
    private JTextField settingField;

    public PluginsSettingPanel() {
        this.boundSupport = new PropertyChangeSupport(this);
        this.initComponents();
        this.setId("Plugins");
        this.setTitle("\u30d7\u30e9\u30b0\u30a4\u30f3\u8a2d\u5b9a");
        this.setIcon("preferences-plugin.png");
        this.classPath = "open.dolphin.plugin.";
        this.path = GlobalConstants.getPluginsDirectory();
        this.pathField.setText(this.path);
        this.pathField.setToolTipText(this.path);
        this.settingPath = GlobalConstants.getApplicationContext().getLocalStorage().getDirectory().getAbsolutePath();
        this.settingField.setText(this.settingPath);
        this.settingField.setToolTipText(this.settingPath);
        String schemaPath = GlobalConstants.getSchemasDirectory();
        this.schemaField.setText(schemaPath);
        this.schemaField.setToolTipText(schemaPath);
        this.scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
    }

    private void ImportPlugin() {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isFile()) {
                    String fileName = f.getName();
                    if (fileName.length() > 5 && fileName.substring(fileName.length() - 4, fileName.length()).equals(".jar")) {
                        return !PluginsSettingPanel.this.findFile(PluginsSettingPanel.this.getInstalled(PluginsSettingPanel.this.path), f.getName());
                    }
                } else {
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "Only .Jar";
            }
        };
        this.jFileChooser1.setFileFilter(filter);
        int selected = this.jFileChooser1.showOpenDialog(this);
        if (selected == 0) {
            File[] files;
            for (File file : files = this.jFileChooser1.getSelectedFiles()) {
                try {
                    this.copyTransfer(file.getAbsolutePath(), this.path + File.separator + file.getName());
                }
                catch (IOException ex) {
                    LogWriter.error(this.getClass(), ex);
                }
            }
            JOptionPane.showMessageDialog(null, "\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u5f8c\u306fOpenDolphin\u3092\u518d\u8d77\u52d5\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        this.list();
        this.plugins.loadPlugins(GlobalConstants.getPluginsDirectory(), "open.dolphin.plugin.");
    }

    @Override
    public void onChenge(Adapter<Boolean, Boolean> adapter) {
        this.adapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTransfer(String srcPath, String destPath) throws IOException {
        FileChannel srcChannel = new FileInputStream(srcPath).getChannel();
        FileChannel destChannel = new FileOutputStream(destPath).getChannel();
        try {
            srcChannel.transferTo(0L, srcChannel.size(), destChannel);
        }
        finally {
            srcChannel.close();
            destChannel.close();
        }
    }

    private File[] getInstalled(String path) {
        File[] result = null;
        File directory = new File(path);
        if (directory.isDirectory()) {
            result = directory.listFiles();
        }
        return result;
    }

    private boolean findFile(File[] files, String name) {
        for (File file : files) {
            if (!file.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public ProjectSettingDialog getContext() {
        return this.context;
    }

    @Override
    public void setContext(ProjectSettingDialog context) {
        this.context = context;
        this.plugins = context.getPlugins();
        this.addPropertyChangeListener("stateProp", context);
        this.setLogInState(context.getLoginState());
    }

    @Override
    public boolean isLoginState() {
        return this.loginState;
    }

    @Override
    public void setLogInState(boolean login) {
        this.loginState = login;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void start() {
        this.model = new PluginsModel();
        this.model.populate();
        this.list();
    }

    private Exception install(File dir) {
        Exception result = null;
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String fileName = file.getName();
            if (!fileName.substring(fileName.length() - 4, fileName.length()).equals(".jar")) continue;
            try {
                String packageName = this.classPath + fileName.substring(0, fileName.length() - 4);
                PluginLoader loader = new PluginLoader(this.path + File.separator + fileName, packageName);
                IPlugin plugin = loader.getPlugin();
                PluginWrapper pluginWrapper = new PluginWrapper(plugin);
                Object[] row = new Object[]{fileName, packageName, pluginWrapper.getName(), pluginWrapper.getReadableName()};
                result = pluginWrapper.getLastException();
                ((DefaultTableModel)this.PluginsTable.getModel()).addRow(row);
                continue;
            }
            catch (Exception ex) {
                LogWriter.error(this.getClass(), ex);
            }
        }
        return result;
    }

    @Override
    public void list() {
        ((DefaultTableModel)this.PluginsTable.getModel()).setRowCount(0);
        File dir = new File(this.path);
        if (dir.exists()) {
            this.install(dir);
        } else {
            dir.mkdir();
            this.install(dir);
        }
    }

    @Override
    public void save() {
        this.model.restore();
    }

    @Override
    public void setState(IAbstractSettingPanel.State state2) {
        this.state = state2;
        this.boundSupport.firePropertyChange("stateProp", null, (Object)this.state);
    }

    @Override
    public IAbstractSettingPanel.State getState() {
        return this.state;
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.scroller = new JScrollPane();
        this.PluginsTable = new JTable();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.pathField = new JTextField();
        this.settingField = new JTextField();
        this.schemaField = new JTextField();
        this.schemaF = new JLabel();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jFileChooser1.setMultiSelectionEnabled(true);
        this.jFileChooser1.setName("jFileChooser1");
        this.scroller.setName("scroller");
        this.PluginsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"\u30d5\u30a1\u30a4\u30eb\u540d", "\u30d1\u30c3\u30b1\u30fc\u30b8\u540d", "\u6a5f\u80fd\u62e1\u5f35\u540d", "\u8a73\u7d30"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.PluginsTable.setName("PluginsTable");
        this.scroller.setViewportView(this.PluginsTable);
        this.jPanel1.setName("jPanel1");
        this.jLabel1.setText("\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u4fdd\u5b58\u5834\u6240");
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u4fdd\u5b58\u5834\u6240");
        this.jLabel2.setName("jLabel2");
        this.pathField.setEditable(false);
        this.pathField.setName("pathField");
        this.pathField.setOpaque(false);
        this.settingField.setEditable(false);
        this.settingField.setName("settingField");
        this.settingField.setOpaque(false);
        this.schemaField.setEditable(false);
        this.schemaField.setName("schemaField");
        this.schemaF.setText("\u30b7\u30a7\u30fc\u30de\u306e\u4fdd\u5b58\u5834\u6240");
        this.schemaF.setName("schemaF");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, 133, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.schemaF, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pathField, -1, 347, Short.MAX_VALUE).addComponent(this.schemaField, -1, 347, Short.MAX_VALUE).addComponent(this.settingField, GroupLayout.Alignment.TRAILING, -1, 347, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.pathField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2, -2, 12, -2).addComponent(this.settingField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.schemaField, -2, -1, -2).addComponent(this.schemaF)).addContainerGap()));
        this.jPanel2.setName("jPanel2");
        this.jButton1.setText("\u6a5f\u80fd\u62e1\u5f35\u306e\u53d6\u308a\u8fbc\u307f");
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setName("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginsSettingPanel.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(169, Short.MAX_VALUE).addComponent(this.jButton1, -2, 184, -2).addGap(169, 169, 169)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButton1).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.scroller, -1, 522, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scroller, -2, 194, -2).addGap(41, 41, 41).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.ImportPlugin();
    }

    class StateMgr {
        StateMgr() {
        }

        public void checkState() {
        }

        public void controlSendMml() {
            this.checkState();
        }

        protected boolean isValid() {
            return true;
        }
    }

    class PluginsModel {
        PluginsModel() {
        }

        public void populate() {
        }

        public void restore() {
        }
    }
}

