/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.settings;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import open.dolphin.client.settings.AreaNetWorkSettingPanel;
import open.dolphin.client.settings.BrowserSettingPanel;
import open.dolphin.client.settings.ClaimSettingPanel;
import open.dolphin.client.settings.CodeHelperSettingPanel;
import open.dolphin.client.settings.DirectionSettingPanel;
import open.dolphin.client.settings.HostSettingPanel;
import open.dolphin.client.settings.IAbstractSettingPanel;
import open.dolphin.client.settings.KarteSettingPanel;
import open.dolphin.client.settings.PluginsSettingPanel;
import open.dolphin.client.settings.SendMmlSettingPanel;
import open.dolphin.helper.PlugInMenuSupport;
import open.dolphin.log.LogWriter;
import open.dolphin.plugin.IPlugin;
import open.dolphin.plugin.PluginWrapper;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;

public final class ProjectSettingDialog
implements PropertyChangeListener {
    private JDialog dialog;
    private JPanel itemPanel;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JButton okButton;
    private JButton cancelButton;
    private Map<String, IAbstractSettingPanel> settingMap;
    private List<IAbstractSettingPanel> allSettings;
    private List<JToggleButton> allBtns;
    private String startSettingName;
    private boolean loginState;
    private PropertyChangeSupport boundSupport;
    private static final String SETTING_PROP = "SETTING_PROP";
    private boolean okState;
    private final int DEFAULT_WIDTH = 830;
    private final int DEFAULT_HEIGHT = 600;
    private PlugInMenuSupport plugins;

    public ProjectSettingDialog(PlugInMenuSupport plugins) {
        this.plugins = plugins;
        this.boundSupport = new PropertyChangeSupport(this);
        this.allSettings = new ArrayList<IAbstractSettingPanel>();
        this.settingMap = new HashMap<String, IAbstractSettingPanel>();
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.addPropertyChangeListener(prop, l);
    }

    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.addPropertyChangeListener(prop, l);
    }

    public boolean getLoginState() {
        return this.loginState;
    }

    public void setLoginState(boolean b) {
        this.loginState = b;
    }

    public boolean getValue() {
        return GlobalVariables.isValid();
    }

    public void notifyResult() {
        boolean valid = GlobalVariables.isValid();
        this.boundSupport.firePropertyChange(SETTING_PROP, !valid, valid);
    }

    public void setProject(String startSettingName) {
        this.startSettingName = startSettingName;
    }

    public void start() {
        try {
            this.allSettings.add(new HostSettingPanel());
            this.allSettings.add(new ClaimSettingPanel());
            this.allSettings.add(new AreaNetWorkSettingPanel());
            this.allSettings.add(new SendMmlSettingPanel());
            this.allSettings.add(new KarteSettingPanel());
            this.allSettings.add(new CodeHelperSettingPanel());
            this.allSettings.add(new BrowserSettingPanel());
            this.allSettings.add(new PluginsSettingPanel());
            this.allSettings.add(new DirectionSettingPanel());
            for (IPlugin plugin : this.getPlugins().values()) {
                PluginWrapper pluginWrapper = new PluginWrapper(plugin);
                IAbstractSettingPanel panel = pluginWrapper.configure();
                if (panel == null) continue;
                this.allSettings.add(panel);
            }
        }
        catch (Exception e) {
            return;
        }
        this.initCustomComponents();
        int index = 0;
        if (this.startSettingName != null) {
            for (IAbstractSettingPanel setting : this.allSettings) {
                if (this.startSettingName.equals(setting.getId())) break;
                ++index;
            }
        }
        index = index >= 0 && index < this.allSettings.size() ? index : 0;
        this.allBtns.get(index).doClick();
    }

    private void initCustomComponents() {
        this.itemPanel = new JPanel(new FlowLayout(0));
        this.allBtns = new ArrayList<JToggleButton>();
        ButtonGroup bg = new ButtonGroup();
        for (IAbstractSettingPanel setting : this.allSettings) {
            String id = setting.getId();
            String text = setting.getTitle();
            String iconStr = setting.getIcon();
            ImageIcon icon = GlobalConstants.getImageIcon(iconStr);
            JToggleButton tb = new JToggleButton(text, icon);
            if (GlobalConstants.isWin()) {
                tb.setMargin(new Insets(0, 0, 0, 0));
            }
            tb.setHorizontalTextPosition(0);
            tb.setVerticalTextPosition(3);
            this.itemPanel.add(tb);
            bg.add(tb);
            tb.setActionCommand(id);
            this.allBtns.add(tb);
        }
        this.cardPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.okButton = new JButton();
        this.okButton.setText("\u4fdd \u5b58");
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton();
        this.cancelButton.setText("\u9589\u3058\u308b");
        JPanel panel = new JPanel(new BorderLayout(11, 0));
        JScrollPane scroller = new JScrollPane();
        scroller.setVerticalScrollBarPolicy(21);
        scroller.setViewportView(this.itemPanel);
        panel.add((Component)scroller, "North");
        panel.add((Component)this.cardPanel, "Center");
        String title = "\u74b0\u5883\u8a2d\u5b9a";
        Object[] options = new Object[]{this.okButton, this.cancelButton};
        JOptionPane jop = new JOptionPane(panel, -1, -1, null, options, this.okButton);
        this.dialog = jop.createDialog(null, GlobalConstants.getFrameTitle(title));
        this.dialog.setResizable(false);
        this.dialog.setSize(new Dimension(830, 600));
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (size.width - 830) / 2;
        int y = (size.height - 600) / 3;
        this.dialog.setLocation(x, y);
        this.connect();
    }

    private void connect() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IAbstractSettingPanel theSetting = null;
                String name = event.getActionCommand();
                for (IAbstractSettingPanel setting : ProjectSettingDialog.this.allSettings) {
                    String id = setting.getId();
                    if (!id.equals(name)) continue;
                    theSetting = setting;
                    break;
                }
                if (theSetting != null) {
                    ProjectSettingDialog.this.startSetting(theSetting);
                }
            }
        };
        for (JToggleButton btn : this.allBtns) {
            btn.addActionListener(al);
        }
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectSettingDialog.this.doOk();
            }
        });
        this.okButton.setEnabled(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectSettingDialog.this.doCancel();
            }
        });
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProjectSettingDialog.this.doCancel();
            }
        });
    }

    private void startSetting(final IAbstractSettingPanel sp) {
        if (sp.getContext() != null) {
            this.cardLayout.show(this.cardPanel, sp.getTitle());
            return;
        }
        try {
            this.settingMap.put(sp.getId(), sp);
            sp.setContext(this);
            sp.start();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectSettingDialog.this.cardPanel.add((Component)sp.getPanel(), sp.getTitle());
                    ProjectSettingDialog.this.cardLayout.show(ProjectSettingDialog.this.cardPanel, sp.getTitle());
                    if (!ProjectSettingDialog.this.dialog.isVisible()) {
                        ProjectSettingDialog.this.dialog.setVisible(true);
                    }
                }
            });
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (!prop.equals("stateProp")) {
            return;
        }
        boolean newOk = true;
        Iterator<IAbstractSettingPanel> iter = this.settingMap.values().iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            ++cnt;
            IAbstractSettingPanel p = iter.next();
            if (!p.getState().equals((Object)IAbstractSettingPanel.State.INVALID_STATE)) continue;
            newOk = false;
            break;
        }
        if (this.okState != newOk) {
            this.okState = newOk;
            this.okButton.setEnabled(this.okState);
        }
    }

    public void doOk() {
        for (IAbstractSettingPanel p : this.settingMap.values()) {
            p.save();
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.notifyResult();
    }

    public void doCancel() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.notifyResult();
    }

    public PlugInMenuSupport getPlugins() {
        return this.plugins;
    }
}

