/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import open.dolphin.infomodel.InfoModel;
import open.dolphin.infomodel.KarteBean;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.UserModel;
import open.dolphin.queries.DolphinQuery;
import org.apache.commons.lang.builder.ToStringBuilder;

@MappedSuperclass
public class KarteEntryBean
extends InfoModel
implements Comparable {
    private long id;
    @Temporal(value=TemporalType.DATE)
    private Date confirmed;
    @Temporal(value=TemporalType.DATE)
    private Date started;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date recorded;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date ended;
    private long linkId;
    private String linkRelation;
    private String status;
    private UserModel creator;
    private KarteBean karte;

    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Date getConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(Date confirmed) {
        this.confirmed = confirmed;
    }

    public Date getStarted() {
        return this.started;
    }

    public void setStarted(Date started) {
        this.started = started;
    }

    public Date getEnded() {
        return this.ended;
    }

    public void setEnded(Date ended) {
        this.ended = ended;
    }

    public Date getRecorded() {
        return this.recorded;
    }

    public void setRecorded(Date recorded) {
        this.recorded = recorded;
    }

    public long getLinkId() {
        return this.linkId;
    }

    public void setLinkId(long linkId) {
        this.linkId = linkId;
    }

    public String getLinkRelation() {
        return this.linkRelation;
    }

    public void setLinkRelation(String linkRelation) {
        this.linkRelation = linkRelation;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public UserModel getCreator() {
        return this.creator;
    }

    public void setCreator(UserModel creator) {
        this.creator = creator;
    }

    public KarteBean getKarte() {
        return this.karte;
    }

    public void setKarte(KarteBean karte) {
        this.karte = karte;
    }

    public int hashCode() {
        if (this.id == 0L) {
            return super.hashCode();
        }
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KarteEntryBean other = (KarteEntryBean)obj;
        return this.id == other.id;
    }

    public int compareTo(Object other) {
        if (other != null && this.getClass() == other.getClass()) {
            Date date2;
            Date date1 = this.getStarted();
            int result = this.compareDate(date1, date2 = ((KarteEntryBean)other).getStarted());
            if (result == 0) {
                date1 = this.getConfirmed();
                date2 = ((KarteEntryBean)other).getConfirmed();
                result = this.compareDate(date1, date2);
            }
            return result;
        }
        return -1;
    }

    private int compareDate(Date date1, Date date2) {
        if (date1 != null && date2 == null) {
            return -1;
        }
        if (date1 == null && date2 != null) {
            return 1;
        }
        if (date1 == null && date2 == null) {
            return 0;
        }
        return date1.compareTo(date2);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public Date getFirstConfirmed() {
        return this.getStarted();
    }

    public void setFirstConfirmed(Date firstConfirmed) {
        this.setStarted(firstConfirmed);
    }

    public String getFirstConfirmDate() {
        return ModelUtils.getDateTimeAsString(this.getFirstConfirmed());
    }

    public void setFirstConfirmDate(String timeStamp) {
        this.setFirstConfirmed(ModelUtils.getDateTimeAsObject(timeStamp));
    }

    public String getConfirmDate() {
        return ModelUtils.getDateTimeAsString(this.getConfirmed());
    }

    public void setConfirmDate(String timeStamp) {
        this.setConfirmed(ModelUtils.getDateTimeAsObject(timeStamp));
    }

    public String firstConfirmDateAsString() {
        return this.dateAsString(this.getFirstConfirmed());
    }

    public String confirmDateAsString() {
        return this.dateAsString(this.getConfirmed());
    }

    public String startedDateAsString() {
        return this.dateAsString(this.getStarted());
    }

    public String endedDateAsString() {
        return this.dateAsString(this.getEnded());
    }

    public String recordedDateAsString() {
        return this.dateAsString(this.getRecorded());
    }

    private String dateAsString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public String confirmedTimeStampAsString() {
        return this.timeStampAsString(this.getConfirmed());
    }

    public String startedTimeStampAsString() {
        return this.timeStampAsString(this.getStarted());
    }

    public String endedTimeStampAsString() {
        return this.timeStampAsString(this.getEnded());
    }

    public String recordedTimeStampAsString() {
        return this.timeStampAsString(this.getRecorded());
    }

    private String timeStampAsString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        return sdf.format(date);
    }

    private String nullToString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private String dateToString(Date d) {
        if (d == null) {
            return "";
        }
        return d.toString();
    }

    private String UserModelToString(UserModel d) {
        if (d == null) {
            return "";
        }
        return Long.toString(d.getId());
    }

    private String KarteBeanToString(KarteBean d) {
        if (d == null) {
            return "";
        }
        return Long.toString(d.getId());
    }

    public void serialize(Writer result) throws IOException {
        result.append("<KarteEntryBean id='" + Long.toString(this.id) + "' confirmed='" + this.dateToString(this.confirmed) + "' started='" + this.dateToString(this.started) + "' ended='" + this.dateToString(this.ended) + "' recorded='" + this.dateToString(this.recorded) + "' linkId='" + Long.toString(this.linkId) + "' linkRelation='" + this.nullToString(this.linkRelation) + "' status='" + this.nullToString(this.status) + "' creator_id='" + this.UserModelToString(this.creator) + "' karte_id='" + this.KarteBeanToString(this.karte) + "'/>" + System.getProperty("line.separator"));
    }
}

