/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.io.IOException;
import java.io.Writer;
import open.dolphin.infomodel.InfoModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.PVTPublicInsuranceItemModel;
import open.dolphin.queries.DolphinQuery;

public class PVTHealthInsuranceModel
extends InfoModel {
    private static final long serialVersionUID = 6119471803755585233L;
    private String uuid;
    private String insuranceClass;
    private String insuranceClassCode;
    private String insuranceClassCodeSys;
    private String insuranceNumber;
    private String clientGroup;
    private String clientNumber;
    private String familyClass;
    private String startDate;
    private String expiredDate;
    private String[] continuedDisease;
    private String payInRatio;
    private String payOutRatio;
    private PVTPublicInsuranceItemModel[] pvtPublicInsuranceItem;

    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    public String getGUID() {
        return this.uuid;
    }

    public void setGUID(String val) {
        this.uuid = val;
    }

    public String getInsuranceClass() {
        return this.insuranceClass;
    }

    public void setInsuranceClass(String val) {
        this.insuranceClass = val;
    }

    public String getInsuranceClassCode() {
        return this.insuranceClassCode;
    }

    public void setInsuranceClassCode(String val) {
        this.insuranceClassCode = val;
    }

    public String getInsuranceClassCodeSys() {
        return this.insuranceClassCodeSys;
    }

    public void setInsuranceClassCodeSys(String val) {
        this.insuranceClassCodeSys = val;
    }

    public String getInsuranceNumber() {
        return this.insuranceNumber;
    }

    public void setInsuranceNumber(String val) {
        this.insuranceNumber = val;
    }

    public String getClientGroup() {
        return this.clientGroup;
    }

    public void setClientGroup(String val) {
        this.clientGroup = val;
    }

    public String getClientNumber() {
        return this.clientNumber;
    }

    public void setClientNumber(String val) {
        this.clientNumber = val;
    }

    public String getFamilyClass() {
        return this.familyClass;
    }

    public void setFamilyClass(String val) {
        this.familyClass = val;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getStartFormatDate() {
        return ModelUtils.Convert("yyyy-MM-dd", "yyyy-MM-dd'('EEE')'HH:mm", this.startDate);
    }

    public void setStartDate(String val) {
        this.startDate = val;
    }

    public String getExpiredDate() {
        return this.expiredDate;
    }

    public String getExpiredFormatDate() {
        return ModelUtils.Convert("yyyy-MM-dd", "yyyy-MM-dd'('EEE')'HH:mm", this.expiredDate);
    }

    public void setExpiredDate(String val) {
        this.expiredDate = val;
    }

    public String[] getContinuedDisease() {
        return this.continuedDisease;
    }

    public void setContinuedDisease(String[] val) {
        this.continuedDisease = val;
    }

    public void addContinuedDisease(String val) {
        int len = 0;
        if (this.continuedDisease == null) {
            this.continuedDisease = new String[1];
        } else {
            len = this.continuedDisease.length;
            String[] dest = new String[len + 1];
            System.arraycopy(this.continuedDisease, 0, dest, 0, len);
            this.continuedDisease = dest;
        }
        this.continuedDisease[len] = val;
    }

    public String getPayInRatio() {
        return this.payInRatio;
    }

    public void setPayInRatio(String val) {
        this.payInRatio = val;
    }

    public String getPayOutRatio() {
        return this.payOutRatio;
    }

    public void setPayOutRatio(String val) {
        this.payOutRatio = val;
    }

    public PVTPublicInsuranceItemModel[] getPVTPublicInsuranceItem() {
        return this.pvtPublicInsuranceItem;
    }

    public void setPVTPublicInsuranceItem(PVTPublicInsuranceItemModel[] val) {
        this.pvtPublicInsuranceItem = val;
    }

    public void addPvtPublicInsuranceItem(PVTPublicInsuranceItemModel value) {
        if (this.pvtPublicInsuranceItem == null) {
            this.pvtPublicInsuranceItem = new PVTPublicInsuranceItemModel[1];
            this.pvtPublicInsuranceItem[0] = value;
            return;
        }
        int len = this.pvtPublicInsuranceItem.length;
        PVTPublicInsuranceItemModel[] dest = new PVTPublicInsuranceItemModel[len + 1];
        System.arraycopy(this.pvtPublicInsuranceItem, 0, dest, 0, len);
        this.pvtPublicInsuranceItem = dest;
        this.pvtPublicInsuranceItem[len] = value;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.insuranceNumber != null && this.insuranceClass != null) {
            buf.append(this.insuranceNumber);
            buf.append("  ");
            buf.append(this.insuranceClass);
        } else if (this.insuranceNumber != null) {
            buf.append(this.insuranceNumber);
        } else if (this.insuranceClass != null) {
            buf.append(this.insuranceClass);
        } else {
            buf.append("\u81ea\u8cbb");
        }
        if (this.pvtPublicInsuranceItem != null) {
            int len = this.pvtPublicInsuranceItem.length;
            buf.append(" ");
            for (int i = 0; i < len; ++i) {
                PVTPublicInsuranceItemModel item = this.pvtPublicInsuranceItem[i];
                if (item == null) continue;
                if (i != 0) {
                    buf.append("\u30fb");
                }
                buf.append(item.toString());
            }
            buf.append(" ");
        }
        return buf.toString();
    }

    public void serialize(Writer result) throws IOException {
    }

    public void deserialize(Writer result) throws IOException {
    }
}

