/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.order;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import open.dolphin.delegater.remote.RemoteRadiologyMasterDelegater;
import open.dolphin.infomodel.RadiologyMethodValue;
import open.dolphin.project.GlobalSettings;

public final class RadiologyMethodPanel
extends JPanel {
    private static final long serialVersionUID = 7002106454090449477L;
    public static final String RADIOLOGY_MEYTHOD_PROP = "radiologyProp";
    private List<RadiologyMethodValue> v2;
    private PropertyChangeSupport boundSupport = new PropertyChangeSupport(this);
    private JList commentList;
    private JScrollPane commentScroller;
    private JList methodList;
    private JScrollPane methodScroller;
    private JPanel p1;
    private JPanel p2;

    public RadiologyMethodPanel() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.p1 = new JPanel();
        this.methodScroller = new JScrollPane();
        this.methodList = new JList();
        this.p2 = new JPanel();
        this.commentScroller = new JScrollPane();
        this.commentList = new JList();
        this.setLayout(new BoxLayout(this, 0));
        this.p1.setBorder(BorderFactory.createTitledBorder("\u64ae\u5f71\u65b9\u6cd5"));
        this.p1.setName("p1");
        this.p1.setLayout(new BorderLayout());
        this.methodScroller.setHorizontalScrollBarPolicy(31);
        this.methodScroller.setName("methodScroller");
        this.methodList.setSelectionMode(0);
        this.methodList.setFixedCellWidth(120);
        this.methodList.setName("methodList");
        this.methodScroller.setViewportView(this.methodList);
        this.p1.add((Component)this.methodScroller, "Center");
        this.add(this.p1);
        this.p2.setBorder(BorderFactory.createTitledBorder("\u64ae\u5f71\u30b3\u30e1\u30f3\u30c8"));
        this.p2.setName("p2");
        this.p2.setLayout(new BorderLayout());
        this.commentScroller.setHorizontalScrollBarPolicy(31);
        this.commentScroller.setName("commentScroller");
        this.commentList.setSelectionMode(0);
        this.commentList.setFixedCellWidth(140);
        this.commentList.setName("commentList");
        this.commentScroller.setViewportView(this.commentList);
        this.p2.add((Component)this.commentScroller, "Center");
        this.add(this.p2);
    }

    private void initCustomComponents() {
        RemoteRadiologyMasterDelegater mdl = new RemoteRadiologyMasterDelegater();
        this.methodList.setListData(mdl.getRadiologyMethod().toArray());
        this.methodList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    RadiologyMethodValue entry = (RadiologyMethodValue)RadiologyMethodPanel.this.methodList.getSelectedValue();
                    if (entry == null) {
                        return;
                    }
                    RadiologyMethodPanel.this.fetchComments(entry.getHierarchyCode1());
                }
            }
        });
        this.methodScroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        this.commentList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    RadiologyMethodValue entry = (RadiologyMethodValue)RadiologyMethodPanel.this.commentList.getSelectedValue();
                    if (entry == null) {
                        return;
                    }
                    RadiologyMethodPanel.this.notifyComment(entry.getMethodName());
                }
            }
        });
        this.commentScroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.removePropertyChangeListener(prop, l);
    }

    private void notifyComment(String cm) {
        this.boundSupport.firePropertyChange(RADIOLOGY_MEYTHOD_PROP, null, cm);
    }

    private void fetchComments(String h1) {
        if (this.v2 != null) {
            this.v2.clear();
        }
        RemoteRadiologyMasterDelegater mdl = new RemoteRadiologyMasterDelegater();
        this.v2 = mdl.getRadiologyComments(h1);
        this.commentList.setListData(this.v2.toArray());
    }
}

