/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.plugin.allergypanel;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.CalendarCardPanel;
import open.dolphin.infomodel.AllergyModel;
import open.dolphin.infomodel.SimpleDate;
import open.dolphin.plugin.allergypanel.AllergyPanel;
import open.dolphin.project.GlobalConstants;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.layout.GroupLayout;

public class AllergyEditorPanel
extends JPanel {
    private AllergyPanel inspector;
    private JDialog dialog;
    private boolean ok;
    private JButton addBtn;
    private JButton clearBtn;
    private JTextField factorFld;
    private JLabel factorLabel;
    private JTextField identifiedFld;
    private JLabel identifiedLabel;
    private JLabel jLabel1;
    private JComboBox reactionCombo;
    private JLabel reactionLabel;

    public AllergyEditorPanel(AllergyPanel inspector) {
        this.initComponents();
        this.inspector = inspector;
        this.factorFld.addFocusListener(AutoKanjiListener.getInstance());
        this.factorFld.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AllergyEditorPanel.this.checkBtn();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AllergyEditorPanel.this.checkBtn();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AllergyEditorPanel.this.checkBtn();
            }
        });
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String todayString = sdf.format(date);
        this.identifiedFld.setText(todayString);
        new PopupListener(this.identifiedFld);
        this.identifiedFld.addFocusListener(AutoRomanListener.getInstance());
        this.identifiedFld.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AllergyEditorPanel.this.checkBtn();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AllergyEditorPanel.this.checkBtn();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AllergyEditorPanel.this.checkBtn();
            }
        });
        this.addBtn.setEnabled(false);
        this.clearBtn.setEnabled(false);
        Object[] options = new Object[]{this.addBtn, this.clearBtn};
        JOptionPane pane = new JOptionPane(this, -1, -1, null, options, this.addBtn);
        this.dialog = pane.createDialog(inspector.getParentContext().getFrame(), GlobalConstants.getFrameTitle("\u30a2\u30ec\u30eb\u30ae\u30fc\u767b\u9332"));
        this.dialog.setVisible(true);
    }

    private void initComponents() {
        this.factorLabel = new JLabel();
        this.factorFld = new JTextField();
        this.reactionLabel = new JLabel();
        this.reactionCombo = new JComboBox();
        this.identifiedLabel = new JLabel();
        this.identifiedFld = new JTextField();
        this.addBtn = new JButton();
        this.clearBtn = new JButton();
        this.jLabel1 = new JLabel();
        this.setName("Form");
        this.factorLabel.setHorizontalAlignment(4);
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(AllergyEditorPanel.class);
        this.factorLabel.setText(resourceMap.getString("factorLabel.text", new Object[0]));
        this.factorLabel.setName("factorLabel");
        this.factorFld.setName("factorFld");
        this.reactionLabel.setText(resourceMap.getString("reactionLabel.text", new Object[0]));
        this.reactionLabel.setName("reactionLabel");
        this.reactionCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"severe", "moderate", "mild", "noReaction"}));
        this.reactionCombo.setName("reactionCombo");
        this.identifiedLabel.setHorizontalAlignment(4);
        this.identifiedLabel.setName("identifiedLabel");
        this.identifiedFld.setName("identifiedFld");
        this.addBtn.setText(resourceMap.getString("addBtn.text", new Object[0]));
        this.addBtn.setName("addBtn");
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AllergyEditorPanel.this.addBtnActionPerformed(evt);
            }
        });
        this.clearBtn.setText(resourceMap.getString("clearBtn.text", new Object[0]));
        this.clearBtn.setName("clearBtn");
        this.clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AllergyEditorPanel.this.clearBtnActionPerformed(evt);
            }
        });
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.identifiedLabel, -1, 59, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.reactionLabel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.factorLabel, -1, -1, Short.MAX_VALUE))).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.reactionCombo, 0, 194, Short.MAX_VALUE).add((Component)this.factorFld, -1, 194, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add(35, 35, 35).add((Component)this.jLabel1).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.addBtn, -2, 70, -2).addPreferredGap(0).add((Component)this.clearBtn)).add((Component)this.identifiedFld, -1, 194, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.factorFld, -2, -1, -2).add((Component)this.factorLabel, -2, 18, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.reactionLabel, -2, 15, -2).add((Component)this.reactionCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.identifiedFld, -2, -1, -2).add((Component)this.jLabel1)).add(5, 5, 5).add((Component)this.identifiedLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.addBtn, -2, 23, -2).add((Component)this.clearBtn, -2, 23, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void clearBtnActionPerformed(ActionEvent evt) {
        this.clear();
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        this.add();
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    private void checkBtn() {
        String factor = this.factorFld.getText().trim();
        String date = this.identifiedFld.getText().trim();
        boolean newOk = true;
        if (factor.isEmpty() || date.isEmpty()) {
            newOk = false;
        }
        if (this.ok != newOk) {
            this.ok = newOk;
            this.addBtn.setEnabled(this.ok);
            this.clearBtn.setEnabled(this.ok);
        }
    }

    private void add() {
        AllergyModel model = new AllergyModel();
        model.setFactor(this.factorFld.getText().trim());
        model.setSeverity((String)this.reactionCombo.getSelectedItem());
        String dateStr = this.identifiedFld.getText().trim();
        if (!dateStr.equals("")) {
            model.setIdentifiedDate(dateStr);
        }
        this.addBtn.setEnabled(false);
        this.clearBtn.setEnabled(false);
        this.inspector.add(model);
    }

    private void clear() {
        this.factorFld.setText("");
        this.identifiedFld.setText("");
    }

    class PopupListener
    extends MouseAdapter
    implements PropertyChangeListener {
        private JPopupMenu popup;
        private JTextField tf;

        public PopupListener(JTextField tf) {
            this.tf = tf;
            tf.addMouseListener(this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup = new JPopupMenu();
                CalendarCardPanel cc = new CalendarCardPanel(GlobalConstants.getEventColorTable());
                cc.addPropertyChangeListener("pickedDate", this);
                cc.setCalendarRange(new int[]{-12, 0});
                this.popup.insert(cc, 0);
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("pickedDate")) {
                SimpleDate sd = (SimpleDate)e.getNewValue();
                this.tf.setText(SimpleDate.simpleDateToMmldate(sd));
                this.popup.setVisible(false);
                this.popup = null;
            }
        }
    }
}

