/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.plugin.labotestdocumentpanel;

import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import open.dolphin.plugin.labotestdocumentpanel.LaboTestItemID;
import open.dolphin.plugin.labotestdocumentpanel.SimpleLaboSpecimen;

public class AllLaboTest {
    private TreeMap<SimpleLaboSpecimen, TreeSet<LaboTestItemID>> allTests = new TreeMap();

    public void clear() {
        this.allTests.clear();
    }

    public void addSpecimen(SimpleLaboSpecimen specimen) {
        if (!this.allTests.containsKey(specimen)) {
            this.allTests.put(specimen, new TreeSet());
        }
    }

    public void addTestItem(SimpleLaboSpecimen specimen, LaboTestItemID testItem) {
        TreeSet<LaboTestItemID> treeSet = this.allTests.get(specimen);
        if (treeSet != null) {
            treeSet.add(testItem);
        }
    }

    public TreeMap getAllTests() {
        return this.allTests;
    }

    public int getRowCount() {
        int count = 0;
        for (SimpleLaboSpecimen sp : this.allTests.keySet()) {
            ++count;
            Iterator<LaboTestItemID> it = this.allTests.get(sp).iterator();
            while (it.hasNext()) {
                it.next();
                ++count;
            }
        }
        return count;
    }

    public void fillRow(Object[][] laboData, int startRow, int col) {
        for (SimpleLaboSpecimen sp : this.allTests.keySet()) {
            laboData[startRow++][col] = sp;
            for (LaboTestItemID id : this.allTests.get(sp)) {
                laboData[startRow++][col] = id.getItemName();
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (SimpleLaboSpecimen sp : this.allTests.keySet()) {
            buf.append(System.getProperty("line.separator"));
            buf.append(sp.getSpecimenName());
            buf.append(System.getProperty("line.separator"));
            for (LaboTestItemID id : this.allTests.get(sp)) {
                buf.append(id.getItemName());
                buf.append(System.getProperty("line.separator"));
            }
        }
        return buf.toString();
    }
}

