/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.plugin.labotestdocumentpanel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import open.dolphin.plugin.labotestdocumentpanel.AllLaboTest;
import open.dolphin.plugin.labotestdocumentpanel.LaboTestItemID;
import open.dolphin.plugin.labotestdocumentpanel.SimpleLaboSpecimen;
import open.dolphin.plugin.labotestdocumentpanel.SimpleLaboTest;

public class SimpleLaboModule {
    private String sampleTime;
    private String registTime;
    private String reportTime;
    private String mmlConfirmDate;
    private String reportStatus;
    private String repMemo;
    private String repMemoCodeName;
    private String repMemoCode;
    private String repMemoCodeId;
    private String repFreeMemo;
    private String testCenterName;
    private String set;
    private List simpleLaboTests;

    public String getSampleTime() {
        return this.sampleTime;
    }

    public void setSampleTime(String val) {
        this.sampleTime = val;
    }

    public String getRegistTime() {
        return this.registTime;
    }

    public void setRegistTime(String val) {
        this.registTime = val;
    }

    public String getReportTime() {
        return this.reportTime;
    }

    public void setReportTime(String val) {
        this.reportTime = val;
    }

    public String getMmlConfirmDate() {
        return this.mmlConfirmDate;
    }

    public void setMmlConfirmDate(String val) {
        this.mmlConfirmDate = val;
    }

    public String getReportStatus() {
        return this.reportStatus;
    }

    public void setReportStatus(String val) {
        this.reportStatus = val;
    }

    public String getRepMemo() {
        return this.repMemo;
    }

    public void setRepMemo(String val) {
        this.repMemo = val;
    }

    public String getRepMemoCodeName() {
        return this.repMemoCodeName;
    }

    public void setRepMemoCodeName(String val) {
        this.repMemoCodeName = val;
    }

    public String getRepMemoCode() {
        return this.repMemoCode;
    }

    public void setRepMemoCode(String val) {
        this.repMemoCode = val;
    }

    public String getRepMemoCodeId() {
        return this.repMemoCodeId;
    }

    public void setRepMemoCodeId(String val) {
        this.repMemoCodeId = val;
    }

    public String getRepFreeMemo() {
        return this.repFreeMemo;
    }

    public void setRepFreeMemo(String val) {
        this.repFreeMemo = val;
    }

    public String getTestCenterName() {
        return this.testCenterName;
    }

    public void setTestCenterName(String val) {
        this.testCenterName = val;
    }

    public String getSet() {
        return this.set;
    }

    public void setSet(String val) {
        this.set = val;
    }

    public List getSimpleLaboTest() {
        return this.simpleLaboTests;
    }

    public void setSimpleLaboTest(List list) {
        this.simpleLaboTests = list;
    }

    public void addSimpleLaboTest(SimpleLaboTest val) {
        if (this.simpleLaboTests == null) {
            this.simpleLaboTests = new ArrayList();
        }
        this.simpleLaboTests.add(val);
    }

    public String getHeader() {
        StringBuilder buf = new StringBuilder("\u63a1\u53d6: ");
        if (this.sampleTime != null) {
            int index = this.sampleTime.indexOf(84);
            if (index > 0) {
                String val = this.sampleTime.substring(0, index);
                buf.append(val);
            } else {
                buf.append(this.sampleTime);
            }
        }
        return buf.toString();
    }

    public void fillNormaliedData(Object[][] obj, int col, AllLaboTest allTests) {
        if (this.simpleLaboTests == null || this.simpleLaboTests.size() == 0) {
            return;
        }
        int row = 0;
        int size = this.simpleLaboTests.size();
        SimpleLaboSpecimen specimen2 = null;
        SimpleLaboTest test = null;
        boolean hasSpecimen = false;
        for (SimpleLaboSpecimen specimen2 : allTests.getAllTests().keySet()) {
            obj[row++][col] = specimen2;
            hasSpecimen = false;
            for (int i = 0; i < size; ++i) {
                test = (SimpleLaboTest)this.simpleLaboTests.get(i);
                if (!test.isSpecimen(specimen2)) continue;
                hasSpecimen = true;
                break;
            }
            TreeSet ts = (TreeSet)allTests.getAllTests().get(specimen2);
            for (LaboTestItemID testID : ts) {
                if (hasSpecimen) {
                    obj[row++][col] = test.getTestItem(testID);
                    continue;
                }
                obj[row++][col] = null;
            }
        }
        obj[row++][col] = "";
        obj[row++][col] = this.registTime != null ? this.registTime : "";
        obj[row++][col] = this.reportTime != null ? this.reportTime : "";
        obj[row++][col] = this.reportStatus != null ? this.reportStatus : "";
        obj[row++][col] = this.testCenterName != null ? this.testCenterName : "";
        obj[row++][col] = this.set != null ? this.set : "";
    }

    public void normalize(AllLaboTest allTests) {
        if (this.simpleLaboTests == null || this.simpleLaboTests.size() == 0) {
            return;
        }
        int size = this.simpleLaboTests.size();
        SimpleLaboSpecimen specimen = null;
        StringBuffer buf = null;
        SimpleLaboTest test = null;
        boolean hasSpecimen = false;
        Iterator iter = allTests.getAllTests().keySet().iterator();
        while (iter.hasNext()) {
            buf = new StringBuffer();
            specimen = (SimpleLaboSpecimen)iter.next();
            buf.append(specimen.getSpecimenName());
            buf.append(System.getProperty("line.separator"));
            hasSpecimen = false;
            for (int i = 0; i < size; ++i) {
                test = (SimpleLaboTest)this.simpleLaboTests.get(i);
                if (!test.isSpecimen(specimen)) continue;
                hasSpecimen = true;
                break;
            }
            TreeSet ts = (TreeSet)allTests.getAllTests().get(specimen);
            for (LaboTestItemID testID : ts) {
                if (hasSpecimen) {
                    buf.append(test.getTestValue(testID));
                } else {
                    buf.append(testID.getItemName());
                }
                buf.append(System.getProperty("line.separator"));
            }
            System.out.println(buf.toString());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.sampleTime != null) {
            buf.append(this.sampleTime);
            buf.append(System.getProperty("line.separator"));
        }
        if (this.registTime != null) {
            buf.append(this.registTime);
            buf.append(System.getProperty("line.separator"));
        }
        if (this.reportTime != null) {
            buf.append(this.reportTime);
            buf.append(System.getProperty("line.separator"));
        }
        if (this.mmlConfirmDate != null) {
            buf.append(this.mmlConfirmDate);
            buf.append(System.getProperty("line.separator"));
        }
        if (this.reportStatus != null) {
            buf.append(this.reportStatus);
            buf.append(System.getProperty("line.separator"));
        }
        if (this.testCenterName != null) {
            buf.append(this.testCenterName);
            buf.append(System.getProperty("line.separator"));
        }
        if (this.set != null) {
            buf.append(this.set);
            buf.append(System.getProperty("line.separator"));
        }
        if (this.simpleLaboTests != null) {
            for (int i = 0; i < this.simpleLaboTests.size(); ++i) {
                SimpleLaboTest test = (SimpleLaboTest)this.simpleLaboTests.get(i);
                buf.append(test.toString());
            }
        }
        return buf.toString();
    }
}

