/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.sendclaim;

import java.io.IOException;
import java.net.Socket;
import open.dolphin.log.LogWriter;

public class OrcaSocket {
    private String host;
    private int port;
    private long period;
    private int tryCnt;

    public OrcaSocket(String host, int port, long period, int tryCnt) {
        this.host = host;
        this.port = port;
        this.period = period;
        this.tryCnt = tryCnt;
    }

    public Socket getSocket() {
        Socket socket = null;
        int cnt = 0;
        while (true) {
            try {
                socket = new Socket(this.host, this.port);
            }
            catch (IOException e) {
                if (++cnt % this.tryCnt == 0) break;
                this.sleep(this.period);
                continue;
            }
            break;
        }
        return socket;
    }

    private void sleep(long msec) {
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException e) {
            LogWriter.error(this.getClass(), e);
        }
    }
}

