/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.utils;

import java.awt.Component;
import javax.swing.JFileChooser;

public class FileOpenDialog
extends JFileChooser {
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    private Component parent;
    private int mode;
    private String extention;

    public FileOpenDialog(Component parent, String title, int mode, String extention) {
        this.mode = mode;
        this.parent = parent;
        this.extention = extention;
        this.setFileSelectionMode(0);
        this.setMultiSelectionEnabled(false);
        this.setDialogTitle(title);
        this.setAcceptAllFileFilterUsed(false);
    }

    public int open() {
        int result;
        switch (this.mode) {
            case 0: {
                result = this.showOpenDialog(this.parent);
                break;
            }
            case 1: {
                result = this.showSaveDialog(this.parent);
                break;
            }
            default: {
                return -1;
            }
        }
        return result;
    }

    public String getPath() {
        String result = this.getSelectedFile().getAbsolutePath();
        switch (this.mode) {
            case 0: {
                break;
            }
            case 1: {
                if (result.endsWith('.' + this.extention)) break;
                result = result + '.' + this.extention;
                break;
            }
            default: {
                return "";
            }
        }
        return result;
    }
}

